/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.IProperty;
import org.eclipse.emf.diffmerge.structures.IPropertyValue;
import org.eclipse.emf.diffmerge.structures.PropertyValue;
import org.eclipse.emf.diffmerge.structures.binary.IBinaryRelation;
import org.eclipse.emf.diffmerge.structures.binary.IRangedBinaryRelation;
import org.eclipse.emf.diffmerge.structures.binary.qualified.IQBinaryRelation;
import org.eclipse.emf.diffmerge.structures.binary.qualified.IRangedQBinaryRelation;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.structures.common.FLinkedList;
import org.eclipse.emf.diffmerge.structures.endo.IEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.IIterableEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.IRecursivelyDefinedEndorelation;

public final class Relations {
    public static <T, U> void binaryCopyInto(IRangedBinaryRelation<T, U> sourceRelation_p, IBinaryRelation.Editable<T, U> targetRelation_p) {
        for (T source : sourceRelation_p.getSources()) {
            Collection targets = sourceRelation_p.get(source);
            targetRelation_p.addAll(source, targets);
        }
    }

    public static <V> IPropertyValue<V> binaryGetProperty(IBinaryRelation<?, ?> relation_p, IProperty<V> property_p) {
        IPropertyValue<Object> result = PropertyValue.unknownValue();
        if (relation_p instanceof IBinaryRelation.WithProperties) {
            IBinaryRelation.WithProperties binary = (IBinaryRelation.WithProperties)relation_p;
            if (property_p == binary.propertyIsFunctional()) {
                result = binary.isFunctional();
            } else if (property_p == binary.propertyIsInjective()) {
                result = binary.isInjective();
            } else if (property_p == binary.propertyIsOneToOne()) {
                result = binary.isOneToOne();
            } else if (relation_p instanceof IEndorelation.WithProperties) {
                IEndorelation.WithProperties endo = (IEndorelation.WithProperties)relation_p;
                if (property_p == endo.propertyIsIrreflexive()) {
                    result = endo.isIrreflexive();
                } else if (property_p == endo.propertyIsWithoutCycles()) {
                    result = endo.isWithoutCycles();
                } else if (relation_p instanceof IIterableEndorelation.WithProperties) {
                    IRecursivelyDefinedEndorelation.WithProperties recursive;
                    IIterableEndorelation.WithProperties iterable = (IIterableEndorelation.WithProperties)relation_p;
                    if (property_p == iterable.propertyMaximalElements()) {
                        result = iterable.getMaximalElements();
                    } else if (property_p == iterable.propertyMinimalElements()) {
                        result = iterable.getMinimalElements();
                    } else if (relation_p instanceof IRecursivelyDefinedEndorelation.WithProperties && property_p == (recursive = (IRecursivelyDefinedEndorelation.WithProperties)relation_p).propertyDepth()) {
                        result = recursive.getDepth();
                    }
                }
            }
        }
        return result;
    }

    protected static <T> int endoMinIndexOfMappingElements(IEndorelation<T> endorelation_p, T element_p, List<T> elements_p) {
        int size;
        int result = size = elements_p.size();
        int currentIndex = 0;
        Iterator<T> it = elements_p.iterator();
        while (result == size && it.hasNext()) {
            T current = it.next();
            Collection mapped = endorelation_p.get(current);
            if (mapped.contains(element_p)) {
                result = currentIndex;
            }
            ++currentIndex;
        }
        return result;
    }

    public static <T> List<T> endoTransitiveClosure(IEndorelation<T> endorelation_p, T element_p) {
        return Relations.endoTransitiveClosure(endorelation_p, Collections.singleton(element_p));
    }

    public static <T> List<T> endoTransitiveClosure(IEndorelation<T> endorelation_p, Collection<? extends T> elements_p) {
        IEqualityTester tester = endorelation_p.getEqualityTester();
        FLinkedList result = new FLinkedList(tester);
        FLinkedList<Object> toExplore = new FLinkedList<Object>(tester);
        toExplore.addAll(elements_p);
        while (!toExplore.isEmpty()) {
            Object current = toExplore.get(0);
            toExplore.remove(current);
            if (result.contains(current)) continue;
            int index = Relations.endoMinIndexOfMappingElements(endorelation_p, current, result);
            result.add(index, current);
            Collection targets = endorelation_p.get(current);
            toExplore.addAll(targets);
        }
        result.removeAll(elements_p);
        return Collections.unmodifiableList(result);
    }

    public static <T, U, Q> void qualifiedCopyInto(IRangedQBinaryRelation<T, U, Q> sourceRelation_p, IQBinaryRelation.Editable<T, U, Q> targetRelation_p) {
        for (Object source : sourceRelation_p.getSources()) {
            Map sourceData = sourceRelation_p.getWithDetails(source);
            for (Map.Entry entry : sourceData.entrySet()) {
                targetRelation_p.addAll(source, entry.getValue(), entry.getKey());
            }
        }
    }

    public static <T, U, Q> Collection<U> qualifiedGet(IQBinaryRelation<T, U, Q> relation_p, T element_p) {
        FHashSet<U> result = new FHashSet<U>(relation_p.getEqualityTester());
        Map<Q, Collection<U>> sourceData = relation_p.getWithDetails(element_p);
        for (Collection<U> targets : sourceData.values()) {
            result.addAll(targets);
        }
        return Collections.unmodifiableCollection(result);
    }

    public static <T, U, Q> Collection<U> qualifiedGet(IQBinaryRelation<T, U, Q> relation_p, T element_p, Q qualifier_p) {
        Collection<U> targets;
        Collection<Object> result = Collections.emptySet();
        Map<Q, Collection<U>> sourceData = relation_p.getWithDetails(element_p);
        if (sourceData != null && (targets = sourceData.get(qualifier_p)) != null) {
            result = Collections.unmodifiableCollection(targets);
        }
        return result;
    }

    public static <T, U, Q> Collection<Q> qualifiedGetQualifiers(IQBinaryRelation<T, U, Q> relation_p, T element_p) {
        List result = Collections.emptyList();
        Map<Q, Collection<U>> elementData = relation_p.getWithDetails(element_p);
        if (elementData != null) {
            result = new FLinkedList<Q>(elementData.keySet(), relation_p.getEqualityTester());
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    public static <T, U, Q> Collection<Q> qualifiedGetQualifiers(IQBinaryRelation<T, U, Q> relation_p, T source_p, U target_p) {
        List result = Collections.emptyList();
        Map<Q, Collection<U>> elementData = relation_p.getWithDetails(source_p);
        if (elementData != null) {
            result = new FLinkedList(relation_p.getEqualityTester());
            for (Map.Entry<Q, Collection<U>> entry : elementData.entrySet()) {
                if (!entry.getValue().contains(target_p)) continue;
                result.add(entry.getKey());
            }
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    public static <T, U, Q> boolean qualifiedMaps(IQBinaryRelation<T, U, Q> relation_p, T source_p, U target_p, Q qualifier_p) {
        Collection<U> targets;
        boolean result = false;
        Map<Q, Collection<U>> sourceData = relation_p.getWithDetails(source_p);
        if (sourceData != null && (targets = sourceData.get(qualifier_p)) != null) {
            result = targets.contains(target_p);
        }
        return result;
    }

    public static <T, U> boolean rangedIsFunctional(IRangedBinaryRelation<T, U> relation_p) {
        for (T source : relation_p.getSources()) {
            Collection targets = relation_p.get(source);
            if (targets.size() <= 1) continue;
            return false;
        }
        return true;
    }

    public static <T, U> boolean rangedIsInjective(IRangedBinaryRelation.Invertible<T, U> relation_p) {
        for (Object target : relation_p.getTargets()) {
            Collection sources = relation_p.getInverse(target);
            if (sources.size() <= 1) continue;
            return false;
        }
        return true;
    }
}

