/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.TransactionSupport;
import org.eclipse.jubula.client.core.utils.NativeSQLUtils;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.actions.TransactionWrapper;
import org.eclipse.jubula.client.ui.rcp.views.TestSuiteBrowser;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractNewHandler
extends AbstractHandler {
    protected INodePO getParentNode(ExecutionEvent event) {
        TreePath[] paths;
        INodePO parentNode = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof ITreeSelection && (paths = ((ITreeSelection)selection).getPaths()).length > 0) {
            int ind = paths[0].getSegmentCount();
            while (--ind > 0 && !(paths[0].getSegment(ind) instanceof ICategoryPO)) {
            }
            if (ind > 0) {
                parentNode = (INodePO)paths[0].getSegment(ind);
            }
        }
        if (parentNode == null) {
            IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            parentNode = activePart instanceof TestSuiteBrowser ? proj.getExecObjCont() : proj.getSpecObjCont();
        }
        return parentNode;
    }

    public void addCreatedNode(final INodePO created, ExecutionEvent ev) {
        final INodePO parent = this.getParentNode(ev);
        final ArrayList<INodePO> toLock = new ArrayList<INodePO>();
        GeneralStorage.getInstance().getProject();
        toLock.add(parent);
        boolean succ = TransactionWrapper.executeOperation(new TransactionSupport.ITransaction(){

            public Collection<? extends IPersistentObject> getToLock() {
                return toLock;
            }

            public Collection<? extends IPersistentObject> getToRefresh() {
                return toLock;
            }

            public void run(EntityManager sess) {
                sess.persist((Object)created);
                NativeSQLUtils.addNodeAFFECTS((EntityManager)sess, (INodePO)created, (IPersistentObject)parent);
            }

            public Collection<? extends IPersistentObject> getToMerge() {
                ArrayList<INodePO> toMerge = new ArrayList<INodePO>();
                toMerge.add(created);
                return toMerge;
            }
        });
        if (succ) {
            INodePO master = (INodePO)GeneralStorage.getInstance().getMasterSession().find(created.getClass(), (Object)created.getId());
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)master, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
        }
    }
}

