/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.felix;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.FrameworkInstanceDelegate;
import org.eclipse.libra.framework.core.OSGIFrameworkInstanceBehaviorDelegate;
import org.eclipse.libra.framework.core.TargetDefinitionUtil;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.felix.FelixFramework;
import org.eclipse.libra.framework.felix.IFelixFrameworkInstance;
import org.eclipse.libra.framework.felix.IFelixVersionHandler;
import org.eclipse.libra.framework.felix.Messages;
import org.eclipse.libra.framework.felix.internal.FelixRuntimeInstanceBehavior;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;

public class FelixFrameworkInstance
extends FrameworkInstanceDelegate
implements IFelixFrameworkInstance {
    protected transient IFelixVersionHandler versionHandler;

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        IStatus status = super.canModifyModules(add, remove);
        if (!status.isOK()) {
            return status;
        }
        if (this.getFelixVersionHandler() == null) {
            return new Status(4, "org.eclipse.libra.framework.felix", 0, Messages.errorNoRuntime, null);
        }
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                IModule module = add[i];
                IStatus status2 = this.getFelixVersionHandler().canAddModule(module);
                if (status2 != null && !status2.isOK()) {
                    return status2;
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        try {
            this.getFelixConfiguration();
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Can't setup for Felix configuration.", (Throwable)e);
        }
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        super.importRuntimeConfiguration(runtime, monitor);
        OSGIFrameworkInstanceBehaviorDelegate fsb = (OSGIFrameworkInstanceBehaviorDelegate)this.getServer().loadAdapter(FelixRuntimeInstanceBehavior.class, null);
        if (fsb != null) {
            IPath tempDir = fsb.getTempDirectory();
            if (!tempDir.isAbsolute()) {
                IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                tempDir = rootPath.append(tempDir);
            }
            this.setInstanceDirectory(tempDir.toPortableString());
        }
        try {
            this.getFelixConfiguration();
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Can't setup for Felix configuration.", (Throwable)e);
        }
    }

    public FelixFramework getFelixRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (FelixFramework)this.getServer().getRuntime().loadAdapter(FelixFramework.class, null);
    }

    public IFelixVersionHandler getFelixVersionHandler() {
        if (this.versionHandler == null) {
            if (this.getServer().getRuntime() == null || this.getFelixRuntime() == null) {
                return null;
            }
            this.versionHandler = this.getFelixRuntime().getVersionHandler();
        }
        return this.versionHandler;
    }

    public FrameworkInstanceConfiguration getFelixConfiguration() throws CoreException {
        return this.getFrameworkInstanceConfiguration();
    }

    private ITargetLocation[] getDefaultBundleContainers(IPath installPath) {
        ITargetLocation[] containers = new ITargetLocation[2];
        ITargetPlatformService service = TargetDefinitionUtil.getTargetPlatformService();
        containers[0] = service.newDirectoryLocation(installPath.append("bin").makeAbsolute().toPortableString());
        containers[1] = service.newDirectoryLocation(installPath.append("bundle").makeAbsolute().toPortableString());
        return containers;
    }

    public ITargetDefinition createDefaultTarget() throws CoreException {
        IPath installPath = this.getServer().getRuntime().getLocation();
        ITargetPlatformService service = TargetDefinitionUtil.getTargetPlatformService();
        ITargetDefinition targetDefinition = service.newTarget();
        targetDefinition.setName(this.getServer().getName());
        ITargetLocation[] containers = this.getDefaultBundleContainers(installPath);
        targetDefinition.setTargetLocations(containers);
        service.saveTargetDefinition(targetDefinition);
        return targetDefinition;
    }
}

