/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.HashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.infra.emf.appearance.commands.SetLayoutKindCommand;
import org.eclipse.papyrus.uml.diagram.common.figure.layout.ILayoutToolBox;
import org.eclipse.papyrus.uml.diagram.common.helper.ICompartmentLayoutHelper;

public abstract class ClassifierCompartmentLayoutHelper
implements ICompartmentLayoutHelper {
    protected HashMap<String, ILayoutToolBox> layoutToolBoxList = new HashMap();

    @Override
    public void applyLayout(AbstractGraphicalEditPart compartmentEditPart) {
        EditPart containerEditPart = compartmentEditPart.getParent();
        IFigure fig = (IFigure)((IGraphicalEditPart)containerEditPart).getFigure().getChildren().get(0);
        IFigure primaryfig = (IFigure)fig.getChildren().get(0);
        String layoutKind = this.getLayoutKindFromView((EModelElement)containerEditPart.getModel());
        ILayoutToolBox currentLayoutToolBox = this.layoutToolBoxList.get(layoutKind);
        if (currentLayoutToolBox != null) {
            compartmentEditPart.installEditPolicy((Object)"PrimaryDrag Policy", currentLayoutToolBox.getEditPolicy());
            primaryfig.setLayoutManager((LayoutManager)currentLayoutToolBox.getFigureLayout());
        }
    }

    @Override
    public String getLayoutKindFromView(EModelElement modelElement) {
        EMap entries;
        EAnnotation layoutAnnotation = modelElement.getEAnnotation("layoutFigure");
        if (layoutAnnotation != null && (entries = layoutAnnotation.getDetails()) != null) {
            String gradientvalueString = (String)entries.get((Object)"layoutFigure_value");
            return gradientvalueString;
        }
        return "";
    }

    @Override
    public SetLayoutKindCommand setLayoutKindOnView(TransactionalEditingDomain domain, EModelElement view, String layoutKind) {
        return new SetLayoutKindCommand(domain, view, layoutKind);
    }
}

