/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.tests;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pmf.pim.tests.XWTTestCase;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.Before;

public class AbstractTest
extends XWTTestCase {
    protected ProjectData projectData = new ProjectData();
    IWorkbenchWindow window;
    IWorkbenchPage page;
    IWorkspace workspace;

    protected IProject createProject(ProjectData projectData) throws CoreException {
        IFolder binFolder;
        String ee = "J2SE-1.5";
        String projectId = projectData.getProjectId();
        String[] srcs = projectData.getSrcs();
        String bin = projectData.getBin();
        String model = projectData.getModel();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectId);
        if (!project.exists()) {
            CoreUtility.createProject((IProject)project, (IPath)root.getRawLocation(), null);
        }
        project.open(null);
        CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", null);
        CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", null);
        String[] stringArray = srcs;
        int n = srcs.length;
        int n2 = 0;
        while (n2 < n) {
            String src = stringArray[n2];
            IFolder srcFolder = project.getFolder(src);
            if (!srcFolder.exists()) {
                CoreUtility.createFolder((IFolder)srcFolder);
            }
            ++n2;
        }
        IFolder modelFolder = project.getFolder(model);
        if (!modelFolder.exists()) {
            CoreUtility.createFolder((IFolder)modelFolder);
        }
        if (!(binFolder = project.getFolder(bin)).exists()) {
            CoreUtility.createFolder((IFolder)binFolder);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath path = project.getFullPath().append(bin);
        javaProject.setOutputLocation(path, null);
        IClasspathEntry[] entries = new IClasspathEntry[srcs.length + 2];
        int i = 0;
        String[] stringArray2 = srcs;
        int n3 = srcs.length;
        int n4 = 0;
        while (n4 < n3) {
            String src = stringArray2[n4];
            entries[i++] = JavaCore.newSourceEntry((IPath)project.getProject().getFullPath().append(src));
            ++n4;
        }
        ClasspathComputer.setComplianceOptions((IJavaProject)javaProject, (String)ee);
        entries[i++] = ClasspathComputer.createJREEntry((String)ee);
        entries[i++] = ClasspathComputer.createContainerEntry();
        javaProject.setRawClasspath(entries, null);
        return project;
    }

    protected void copyFile(IProject project, InputStream input, IPath targetPath) {
        try {
            int i = 1;
            int l = targetPath.segmentCount();
            while (i < l) {
                IPath elementPath = targetPath.uptoSegment(i);
                IFolder folder = project.getFolder(elementPath);
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                ++i;
            }
            IFile file = project.getFile(targetPath);
            if (!file.exists()) {
                file.create(input, true, null);
            } else {
                file.setContents(input, true, false, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.waitForJobs();
        try {
            this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (this.window != null) {
                this.page = this.window.getActivePage();
            }
            this.workspace = ResourcesPlugin.getWorkspace();
            this.waitForJobs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testAbtractTest() {
    }

    protected void delay(long waitTimeMillis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long endTimeMillis = System.currentTimeMillis() + waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.update();
        } else {
            try {
                Thread.sleep(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void waitForJobs() {
        while (Job.getJobManager().currentJob() != null) {
            this.delay(1000L);
        }
    }

    static class ProjectData {
        protected String[] srcs = new String[]{"src"};
        protected String bin = "bin";
        protected String projectId = "testproject";
        protected String model = "model";

        public String[] getSrcs() {
            return this.srcs;
        }

        public void setSrcs(String[] srcs) {
            this.srcs = srcs;
        }

        public String getBin() {
            return this.bin;
        }

        public void setBin(String bin) {
            this.bin = bin;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }
    }
}

