/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.interactive;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Operator implements Enumerator
{
    EQ(0, "EQ", "EQ"),
    NE(1, "NE", "NE"),
    GT(2, "GT", "GT"),
    LT(3, "LT", "LT"),
    GE(4, "GE", "GE"),
    LE(5, "LE", "LE"),
    LIKE(6, "LIKE", "LIKE"),
    IS_A(7, "IS_A", "IS_A"),
    IS_KIND_OF(8, "IS_KIND_OF", "IS_KIND_OF");

    public static final int EQ_VALUE = 0;
    public static final int NE_VALUE = 1;
    public static final int GT_VALUE = 2;
    public static final int LT_VALUE = 3;
    public static final int GE_VALUE = 4;
    public static final int LE_VALUE = 5;
    public static final int LIKE_VALUE = 6;
    public static final int IS_A_VALUE = 7;
    public static final int IS_KIND_OF_VALUE = 8;
    private static final Operator[] VALUES_ARRAY;
    public static final List<Operator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Operator[]{EQ, NE, GT, LT, GE, LE, LIKE, IS_A, IS_KIND_OF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Operator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator get(int value) {
        switch (value) {
            case 0: {
                return EQ;
            }
            case 1: {
                return NE;
            }
            case 2: {
                return GT;
            }
            case 3: {
                return LT;
            }
            case 4: {
                return GE;
            }
            case 5: {
                return LE;
            }
            case 6: {
                return LIKE;
            }
            case 7: {
                return IS_A;
            }
            case 8: {
                return IS_KIND_OF;
            }
        }
        return null;
    }

    private Operator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

