/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeFloat;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueFloat;
import org.eclipse.ptp.internal.debug.core.messages.Messages;
import org.eclipse.ptp.internal.debug.core.model.PValue;
import org.eclipse.ptp.internal.debug.core.model.PVariable;

public class PFloatingPointValue
extends PValue {
    private Number fFloatingPointValue;

    public PFloatingPointValue(PVariable parent, IPDIVariable variable) {
        super(parent, variable);
    }

    public Number getFloatingPointValue() throws DebugException, AIFException {
        IAIF aif;
        if (this.fFloatingPointValue == null && (aif = this.getAIF()) != null && aif.getType() instanceof IAIFTypeFloat) {
            IAIFValueFloat floatValue = (IAIFValueFloat)aif.getValue();
            if (floatValue.isDouble()) {
                this.fFloatingPointValue = new Double(floatValue.doubleValue());
            } else if (floatValue.isFloat()) {
                this.fFloatingPointValue = new Float(floatValue.floatValue());
            } else {
                PFloatingPointValue.targetRequestFailed(Messages.PFloatingPointValue_0, null);
            }
        }
        return this.fFloatingPointValue;
    }
}

