/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.CompilerProblems;
import org.eclipse.qvtd.compiler.CompilerStep;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;

public abstract class AbstractCompilerStep
implements CompilerStep {
    protected final @NonNull CompilerChain compilerChain;
    protected final @NonNull QVTbaseEnvironmentFactory environmentFactory;
    protected final @NonNull String stepName;
    protected final @NonNull String defaultFileExtension;
    private CompilerProblems compilerProblems = null;

    protected AbstractCompilerStep(@NonNull CompilerChain compilerChain, @NonNull String stepName) {
        this.compilerChain = compilerChain;
        this.environmentFactory = compilerChain.getEnvironmentFactory();
        this.stepName = stepName;
        this.defaultFileExtension = (String)ClassUtil.nonNullState((Object)AbstractCompilerChain.getDefaultFileExtension(stepName));
    }

    @Override
    public void addProblem(@NonNull CompilerProblem problem) {
        CompilerProblems compilerProblems2 = this.compilerProblems;
        if (compilerProblems2 == null) {
            this.compilerProblems = compilerProblems2 = new CompilerProblems();
        }
        compilerProblems2.addProblem(problem);
    }

    public <T> @Nullable T basicGetOption( @NonNull CompilerOptions.Key<T> optionKey) {
        return this.compilerChain.basicGetOption(this.stepName, optionKey);
    }

    protected void compiled(@NonNull Object object) {
        this.compiled(this.stepName, object);
    }

    @Deprecated
    protected void compiled(@NonNull String stepName, @NonNull Object object) {
        this.compilerChain.compiled(stepName, object);
    }

    protected @NonNull Resource createResource() throws IOException {
        return this.compilerChain.createResource(this.getURI());
    }

    @Deprecated
    protected @NonNull Resource createResource(@NonNull URI uri) throws IOException {
        return this.compilerChain.createResource(uri);
    }

    @Override
    public @NonNull String getDefaultExtension() {
        return this.defaultFileExtension;
    }

    @Override
    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    public @NonNull String getName() {
        return this.stepName;
    }

    protected @NonNull URI getURI() {
        return this.compilerChain.getURI(this.stepName, CompilerChain.URI_KEY);
    }

    protected @NonNull Resource saveResource(@NonNull Resource asResource) throws IOException {
        this.compilerChain.saveResource(asResource, this.stepName);
        this.compiled(asResource);
        return asResource;
    }

    @Deprecated
    protected @NonNull Resource saveResource(@NonNull Resource asResource, @NonNull String stepName) throws IOException {
        this.compilerChain.saveResource(asResource, stepName);
        this.compiled(stepName, asResource);
        return asResource;
    }

    @Override
    public void throwCompilerChainExceptionForErrors() throws CompilerChainException {
        if (this.compilerProblems != null) {
            this.compilerProblems.throwCompilerChainExceptionForErrors();
        }
    }
}

