/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadNodeGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.RuleAnalysis2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.TracedHeadAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2DispatchClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2InvocationClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceInterface;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;

public class RelationAnalysis2TraceGroup
extends RuleAnalysis2TraceGroup {
    protected final @Nullable RelationAnalysis2TraceClass relationAnalysis2traceClass;
    protected final @Nullable RelationAnalysis2TraceInterface relationAnalysis2traceInterface;
    protected final @Nullable RelationAnalysis2InvocationClass relationAnalysis2invocationClass;
    protected final @Nullable RelationAnalysis2DispatchClass relationAnalysis2dispatchClass;

    public RelationAnalysis2TraceGroup(@NonNull RelationAnalysis relationAnalysis) {
        super(relationAnalysis);
        Relation relation = relationAnalysis.getRule();
        QVTrelationNameGenerator nameGenerator = relationAnalysis.getNameGenerator();
        String traceClassName = null;
        String traceInterfaceName = null;
        String invocationClassName = null;
        String dispatchClassName = null;
        Rule baseRelation = QVTrelationUtil.basicGetBaseRule((Rule)relation);
        boolean hasOverrides = QVTrelationUtil.hasOverrides((Relation)relation);
        boolean isAbstract = relation.isIsAbstract();
        boolean topLevel = relation.isIsTopLevel();
        if (!isAbstract) {
            traceClassName = nameGenerator.createTraceClassName((Rule)relation);
        }
        if (hasOverrides && baseRelation == relation) {
            traceInterfaceName = nameGenerator.createTraceInterfaceName((Rule)relation);
        }
        if (hasOverrides) {
            if (!topLevel && !isAbstract) {
                invocationClassName = nameGenerator.createInvocationClassName((Rule)relation);
            }
            if (baseRelation == relation) {
                dispatchClassName = nameGenerator.createDispatchClassName((Rule)relation);
            }
        }
        this.relationAnalysis2traceClass = traceClassName != null ? new RelationAnalysis2TraceClass(this, traceClassName) : null;
        this.relationAnalysis2traceInterface = traceInterfaceName != null ? new RelationAnalysis2TraceInterface(this, traceInterfaceName) : null;
        this.relationAnalysis2dispatchClass = dispatchClassName != null ? new RelationAnalysis2DispatchClass(this, dispatchClassName) : null;
        this.relationAnalysis2invocationClass = invocationClassName != null ? new RelationAnalysis2InvocationClass(this, invocationClassName) : null;
        RelationAnalysis2TraceClass relationAnalysis2traceClass2 = this.relationAnalysis2traceClass;
        if (relationAnalysis2traceClass2 != null) {
            Variable traceVariable = QVTrelationUtil.getTraceVariable((Relation)relation);
            traceVariable.setType((Type)relationAnalysis2traceClass2.getMiddleClass());
        }
    }

    @Override
    public void analyzeTraceElements() throws CompilerChainException {
        RelationAnalysis2InvocationClass relationAnalysis2invocationClass2;
        RelationAnalysis2DispatchClass relationAnalysis2invocationInterface2;
        RelationAnalysis2TraceClass relationAnalysis2traceClass2;
        List<@NonNull HeadNodeGroup> headNodeGroups = TracedHeadAnalysis.computeTraceHeadGroupNodes(this.ruleAnalysis.getScheduleManager(), (MappingRegion)this.ruleAnalysis.getRegion());
        RelationAnalysis2TraceInterface relationAnalysis2traceInterface2 = this.relationAnalysis2traceInterface;
        if (relationAnalysis2traceInterface2 != null) {
            relationAnalysis2traceInterface2.analyzeTraceElements(headNodeGroups);
        }
        if ((relationAnalysis2traceClass2 = this.relationAnalysis2traceClass) != null) {
            relationAnalysis2traceClass2.analyzeTraceElements(headNodeGroups);
        }
        if ((relationAnalysis2invocationInterface2 = this.relationAnalysis2dispatchClass) != null) {
            relationAnalysis2invocationInterface2.analyzeTraceElements(headNodeGroups);
        }
        if ((relationAnalysis2invocationClass2 = this.relationAnalysis2invocationClass) != null) {
            relationAnalysis2invocationClass2.analyzeTraceElements(headNodeGroups);
        }
    }

    public @Nullable RelationAnalysis2InvocationClass basicGetRuleAnalysis2InvocationClass() {
        return this.relationAnalysis2invocationClass;
    }

    public @Nullable RelationAnalysis2DispatchClass basicGetRuleAnalysis2InvocationInterface() {
        return this.relationAnalysis2dispatchClass;
    }

    public @Nullable RelationAnalysis2TraceInterface basicGetRuleAnalysis2TraceInterface() {
        return this.relationAnalysis2traceInterface;
    }

    public @NonNull RelationAnalysis2TraceGroup getBaseRelationAnalysis2TraceGroup() {
        return this.getRuleAnalysis().getBaseRelationAnalysis().getRuleAnalysis2TraceGroup();
    }

    public @NonNull Class getInvocationClass() {
        if (this.relationAnalysis2dispatchClass != null) {
            return this.relationAnalysis2dispatchClass.getMiddleClass();
        }
        return this.getRuleAnalysis2TraceClass().getMiddleClass();
    }

    public @NonNull Class getInvocationInterface() {
        return this.getRuleAnalysis2InvocationInterface().getMiddleClass();
    }

    @Override
    public @NonNull String getName() {
        return this.ruleAnalysis.getName();
    }

    public @NonNull QVTrelationNameGenerator getNameGenerator() {
        return this.getScheduleManager().getNameGenerator();
    }

    public @NonNull Relation getRule() {
        return (Relation)this.ruleAnalysis.getRule();
    }

    @Override
    public @NonNull RelationAnalysis getRuleAnalysis() {
        return (RelationAnalysis)this.ruleAnalysis;
    }

    public @NonNull RelationAnalysis2DispatchClass getRuleAnalysis2DispatchClass() {
        return (RelationAnalysis2DispatchClass)ClassUtil.nonNullState((Object)this.relationAnalysis2dispatchClass);
    }

    public @NonNull RelationAnalysis2MiddleType getRuleAnalysis2InvocationInterface() {
        if (this.relationAnalysis2dispatchClass != null) {
            return this.relationAnalysis2dispatchClass;
        }
        if (this.relationAnalysis2invocationClass != null) {
            return this.relationAnalysis2invocationClass;
        }
        return this.getRuleAnalysis2TraceInterface();
    }

    public @NonNull RelationAnalysis2TraceClass getRuleAnalysis2TraceClass() {
        return (RelationAnalysis2TraceClass)ClassUtil.nonNullState((Object)this.relationAnalysis2traceClass);
    }

    public @NonNull RelationAnalysis2MiddleType getRuleAnalysis2TraceInterface() {
        if (this.relationAnalysis2traceInterface != null) {
            return this.relationAnalysis2traceInterface;
        }
        return this.getRuleAnalysis2TraceClass();
    }

    public @NonNull QVTrelationScheduleManager getScheduleManager() {
        return this.getRuleAnalysis().getScheduleManager();
    }

    @Override
    public @NonNull Class getTraceClass() {
        return this.getRuleAnalysis2TraceClass().getMiddleClass();
    }

    public @NonNull Class getTraceInterface() {
        return this.getRuleAnalysis2TraceInterface().getMiddleClass();
    }

    @Override
    public void synthesizeTraceElements() throws CompilerChainException {
        this.getRuleAnalysis().synthesizeTraceElements(this);
    }

    @Override
    public void synthesizeTraceModel() {
        if (this.relationAnalysis2traceInterface != null) {
            this.relationAnalysis2traceInterface.synthesizeTraceModel();
        }
        if (this.relationAnalysis2traceClass != null) {
            this.relationAnalysis2traceClass.synthesizeTraceModel();
        }
        if (this.relationAnalysis2dispatchClass != null) {
            this.relationAnalysis2dispatchClass.synthesizeTraceModel();
        }
        if (this.relationAnalysis2invocationClass != null) {
            this.relationAnalysis2invocationClass.synthesizeTraceModel();
        }
    }

    public @NonNull String toString() {
        return this.getRuleAnalysis().toString();
    }
}

