/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadEntryModel;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphStateFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class ThreadStatusDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<ThreadEntryModel> {
    public static final @NonNull String ID = "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider";
    public static final @NonNull String CPU = "cpu";
    public static final @NonNull String ACTIVE_THREAD_FILTER_KEY = "active_thread_filter";
    private static final String WILDCARD = "*";
    private static final Set<Integer> ACTIVE_STATES = ImmutableSet.of((Object)2, (Object)3, (Object)4);
    private static final AtomicLong fAtomicLong = new AtomicLong();
    private final KernelAnalysisModule fModule;
    private final long fTraceId = fAtomicLong.getAndIncrement();
    private final Map<Long, Integer> fQuarkMap = new HashMap<Long, Integer>();
    private final Map<Pair<Integer, Integer>, ThreadEntryModel.Builder> fBuildMap = new HashMap<Pair<Integer, Integer>, ThreadEntryModel.Builder>();
    private long fLastEnd = Long.MIN_VALUE;
    private final TreeMultimap<Integer, ThreadEntryModel.Builder> fTidToEntry = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ThreadEntryModel.Builder::getStartTime));
    private final Map<Long, @NonNull Multimap<@NonNull String, @NonNull Object>> fEntryMetadata = new HashMap<Long, Multimap<String, Object>>();

    public ThreadStatusDataProvider(@NonNull ITmfTrace trace, KernelAnalysisModule module) {
        super(trace);
        this.fModule = module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull TmfModelResponse<@NonNull TmfTreeModel<@NonNull ThreadEntryModel>> fetchTree(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        if (this.fLastEnd == Long.MAX_VALUE) {
            return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), this.filter(this.fTidToEntry, fetchParameters)), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        this.fModule.waitForInitialization();
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        Map<Pair<Integer, Integer>, ThreadEntryModel.Builder> map = this.fBuildMap;
        synchronized (map) {
            boolean complete = ss.waitUntilBuilt(0L);
            @NonNull List<@NonNull Object> list = Collections.emptyList();
            if (ss.getNbAttributes() > 0 && ss.getStartTime() != Long.MIN_VALUE) {
                long end = ss.getCurrentEndTime();
                this.fLastEnd = Long.max(this.fLastEnd, ss.getStartTime());
                TreeMultimap execNamesPPIDs = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
                ArrayList quarks = new ArrayList(ss.getQuarks(new String[]{"Threads", WILDCARD, "Exec_name"}));
                quarks.addAll(ss.getQuarks(new String[]{"Threads", WILDCARD, "PPID"}));
                try {
                    for (ITmfStateInterval interval : ss.query2D(quarks, Long.min(this.fLastEnd, end), end)) {
                        if (monitor != null && monitor.isCanceled()) {
                            return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                        }
                        execNamesPPIDs.put((Object)interval.getAttribute(), (Object)interval);
                    }
                }
                catch (StateSystemDisposedException | TimeRangeException e) {
                    return new TmfModelResponse(null, ITmfResponse.Status.FAILED, String.valueOf(e.getClass().getName()) + ':' + String.valueOf(e.getMessage()));
                }
                this.fTidToEntry.replaceValues((Object)Integer.MIN_VALUE, Collections.singleton(new ThreadEntryModel.Builder(this.fTraceId, Collections.singletonList(this.getTrace().getName()), ss.getStartTime(), end, Integer.MIN_VALUE, Integer.MIN_VALUE)));
                for (Integer threadQuark : ss.getQuarks(new String[]{"Threads", WILDCARD})) {
                    String threadAttributeName = ss.getAttributeName(threadQuark.intValue());
                    Pair<Integer, Integer> entryKey = Attributes.parseThreadAttributeName(threadAttributeName);
                    int threadId = (Integer)entryKey.getFirst();
                    if (threadId < 0) continue;
                    int execNameQuark = ss.optQuarkRelative(threadQuark.intValue(), new String[]{"Exec_name"});
                    int ppidQuark = ss.optQuarkRelative(threadQuark.intValue(), new String[]{"PPID"});
                    NavigableSet ppidIntervals = execNamesPPIDs.get((Object)ppidQuark);
                    for (ITmfStateInterval execNameInterval : execNamesPPIDs.get((Object)execNameQuark)) {
                        if (monitor != null && monitor.isCanceled()) {
                            return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                        }
                        this.updateEntry(threadQuark, entryKey, ppidIntervals, execNameInterval);
                    }
                }
                this.fLastEnd = end;
                list = this.filter(this.fTidToEntry, fetchParameters);
            }
            for (ThreadEntryModel model : list) {
                this.fEntryMetadata.put(model.getId(), model.getMetadata());
            }
            if (complete) {
                this.fBuildMap.clear();
                this.fLastEnd = Long.MAX_VALUE;
                return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), list), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            }
            return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), list), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
    }

    private void updateEntry(Integer threadQuark, Pair<Integer, Integer> entryKey, NavigableSet<ITmfStateInterval> ppidIntervals, ITmfStateInterval execNameInterval) {
        Object value = execNameInterval.getValue();
        if (value == null) {
            this.fBuildMap.remove(entryKey);
            return;
        }
        ThreadEntryModel.Builder entry = this.fBuildMap.get(entryKey);
        long startTime = execNameInterval.getStartTime();
        long endTime = execNameInterval.getEndTime() + 1L;
        String execName = String.valueOf(value);
        int threadId = (Integer)entryKey.getFirst();
        int ppid = ThreadStatusDataProvider.getPpid(ppidIntervals, endTime);
        if (entry == null) {
            long id = fAtomicLong.getAndIncrement();
            entry = new ThreadEntryModel.Builder(id, Collections.singletonList(execName), startTime, endTime, threadId, ppid);
            this.fQuarkMap.put(id, threadQuark);
        } else {
            entry.setEndTime(endTime);
            entry.setPpid(ppid);
            entry.setName(Collections.singletonList(execName));
        }
        this.fBuildMap.put(entryKey, entry);
        this.fTidToEntry.put((Object)threadId, (Object)entry);
    }

    private static int getPpid(NavigableSet<ITmfStateInterval> ppidIterator, long t) {
        Object o;
        ITmfStateInterval ppidInterval = ppidIterator.lower((ITmfStateInterval)new TmfStateInterval(t, t + 1L, 0, (Object)0));
        if (ppidInterval != null && (o = ppidInterval.getValue()) instanceof Integer) {
            return (Integer)o;
        }
        return -1;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull List<@NonNull ThreadEntryModel> filter(TreeMultimap<Integer, ThreadEntryModel.Builder> tidToEntry, @NonNull Map<@NonNull String, @NonNull Object> parameters) {
        long end;
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(parameters);
        if (filter == null) {
            return Collections.emptyList();
        }
        Boolean isActiveFilter = DataProviderParameterUtils.extractBoolean(parameters, (String)ACTIVE_THREAD_FILTER_KEY);
        if (isActiveFilter == null || !isActiveFilter.booleanValue()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ThreadEntryModel.Builder entryBuilder : tidToEntry.values()) {
                builder.add((Object)this.build(entryBuilder));
            }
            return builder.build();
        }
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return Collections.emptyList();
        }
        long start = Long.max(filter.getStart(), ss.getStartTime());
        if (start > (end = Long.min(filter.getEnd(), ss.getCurrentEndTime()))) {
            return Collections.emptyList();
        }
        @NonNull List selectedItems = DataProviderParameterUtils.extractSelectedItems(parameters);
        if (selectedItems != null) {
            HashSet cpus = Sets.newHashSet((Iterable)selectedItems);
            @NonNull List quarks = ss.getQuarks(new String[]{"Threads", WILDCARD, "Current_cpu_rq"});
            HashSet<ThreadEntryModel> models = new HashSet<ThreadEntryModel>();
            HashMap<Integer, Integer> rqToPidCache = new HashMap<Integer, Integer>();
            try {
                for (ITmfStateInterval interval : ss.query2D((Collection)quarks, Long.max(ss.getStartTime(), start), end)) {
                    Object o = interval.getValue();
                    if (!(o instanceof Number) || !cpus.contains(((Number)o).longValue())) continue;
                    int attribute = interval.getAttribute();
                    try {
                        int nameQuark = ss.getQuarkRelative(ss.getParentAttributeQuark(attribute), new String[]{"Exec_name"});
                        @NonNull Iterable names2d = ss.query2D(Collections.singleton(nameQuark), interval.getStartTime(), interval.getEndTime());
                        @NonNull Iterable names = Iterables.transform((Iterable)names2d, intervalName -> String.valueOf(intervalName.getValue()));
                        int tid = rqToPidCache.computeIfAbsent(attribute, a -> (Integer)Attributes.parseThreadAttributeName(ss.getAttributeName(ss.getParentAttributeQuark(a.intValue()))).getFirst());
                        if (tid == 0) continue;
                        for (ThreadEntryModel.Builder model : tidToEntry.get((Object)tid)) {
                            ThreadEntryModel build;
                            if (interval.getStartTime() > model.getEndTime() || model.getStartTime() > interval.getEndTime() || !Iterables.any((Iterable)names, arg_0 -> ThreadStatusDataProvider.lambda$4(build = this.build(model), arg_0))) continue;
                            models.add(build);
                        }
                    }
                    catch (AttributeNotFoundException e) {
                        Activator.getDefault().logWarning("Unable to get the quark for the attribute name", e);
                    }
                }
            }
            catch (IndexOutOfBoundsException | TimeRangeException e) {
                Activator.getDefault().logError("Invalid query parameters", e);
            }
            catch (StateSystemDisposedException e) {
                return Collections.emptyList();
            }
            return Lists.newArrayList(models);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ThreadEntryModel.Builder thread : tidToEntry.values()) {
            Integer statusQuark = this.fQuarkMap.get(thread.getId());
            if (statusQuark == null) continue;
            StateSystemUtils.QuarkIterator iterator = new StateSystemUtils.QuarkIterator(ss, statusQuark.intValue(), start, end);
            Iterator values = Iterators.transform((Iterator)iterator, ITmfStateInterval::getValue);
            if (!Iterators.any((Iterator)values, ACTIVE_STATES::contains)) continue;
            builder.add((Object)this.build(thread));
        }
        return builder.build();
    }

    private ThreadEntryModel build(ThreadEntryModel.Builder entryBuilder) {
        if (entryBuilder.getId() == this.fTraceId) {
            return entryBuilder.build(-1L);
        }
        long parentId = entryBuilder.getPpid() > 0 ? this.findEntry(entryBuilder.getPpid(), entryBuilder.getEndTime()) : this.fTraceId;
        return entryBuilder.build(parentId);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull TmfModelResponse<@NonNull TimeGraphModel> fetchRowModel(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, IProgressMonitor monitor) {
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        Map<Long, Integer> selectedIdsToQuarks = this.getSelectedIdsToQuarks(filter);
        Collection<Integer> stateAndSyscallQuarks = ThreadStatusDataProvider.addSyscall(selectedIdsToQuarks.values(), ss);
        Collection<Long> times = ThreadStatusDataProvider.getTimes(ss, (TimeQueryFilter)filter);
        try {
            for (ITmfStateInterval interval : ss.query2D(stateAndSyscallQuarks, times)) {
                if (monitor != null && monitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                intervals.put((Object)interval.getAttribute(), (Object)interval);
            }
        }
        catch (StateSystemDisposedException | TimeRangeException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, String.valueOf(e.getMessage()));
        }
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(fetchParameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        @NonNull ArrayList<@NonNull TimeGraphRowModel> rows = new ArrayList<TimeGraphRowModel>();
        for (Map.Entry<Long, Integer> entry : selectedIdsToQuarks.entrySet()) {
            int quark = entry.getValue();
            NavigableSet states = intervals.get((Object)quark);
            NavigableSet syscalls = intervals.get((Object)ss.optQuarkRelative(quark, new String[]{"System_call"}));
            if (monitor != null && monitor.isCanceled()) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            ArrayList eventList = new ArrayList();
            states.forEach(i -> {
                ITimeGraphState timegraphState = ThreadStatusDataProvider.createTimeGraphState(i, syscalls);
                Long key = Objects.requireNonNull((Long)entry.getKey());
                this.applyFilterAndAddState(eventList, timegraphState, key, predicates, monitor);
            });
            rows.add(new TimeGraphRowModel(entry.getKey().longValue(), eventList));
        }
        return new TmfModelResponse((Object)new TimeGraphModel(rows), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private Map<Long, Integer> getSelectedIdsToQuarks(SelectionTimeQueryFilter filter) {
        LinkedHashMap<Long, Integer> map = new LinkedHashMap<Long, Integer>();
        for (Long id : filter.getSelectedItems()) {
            Integer quark = this.fQuarkMap.get(id);
            if (quark == null) continue;
            map.put(id, quark);
        }
        return map;
    }

    private static Collection<Integer> addSyscall(Collection<Integer> quarks, ITmfStateSystem ss) {
        HashSet<Integer> copy = new HashSet<Integer>(quarks);
        for (Integer quark : quarks) {
            int syscallQuark = ss.optQuarkRelative(quark.intValue(), new String[]{"System_call"});
            if (syscallQuark == -2) continue;
            copy.add(syscallQuark);
        }
        return copy;
    }

    private static @NonNull Collection<@NonNull Long> getTimes(ITmfStateSystem ss, TimeQueryFilter filter) {
        long start = ss.getStartTime();
        HashSet<@NonNull Long> times = new HashSet<Long>();
        long[] lArray = filter.getTimesRequested();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long t = lArray[n2];
            if (t >= start) {
                times.add(t);
            }
            ++n2;
        }
        return times;
    }

    private static @NonNull ITimeGraphState createTimeGraphState(ITmfStateInterval interval, NavigableSet<ITmfStateInterval> syscalls) {
        long startTime = interval.getStartTime();
        long duration = interval.getEndTime() - startTime + 1L;
        Object status = interval.getValue();
        if (status instanceof Integer) {
            Object value;
            ITmfStateInterval syscall;
            int s = (Integer)status;
            if (s == 3 && (syscall = syscalls.floor((ITmfStateInterval)new TmfStateInterval(startTime, startTime + 1L, 0, (Object)0))) != null && (value = syscall.getValue()) instanceof String) {
                return new TimeGraphState(startTime, duration, s, String.valueOf(value));
            }
            return new TimeGraphState(startTime, duration, s);
        }
        return new TimeGraphState(startTime, duration, Integer.MIN_VALUE);
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, IProgressMonitor monitor) {
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        ArrayList<@NonNull TimeGraphArrow> linkList = new ArrayList<TimeGraphArrow>();
        TreeMultimap currentThreadIntervalsMap = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        List quarks = ss.getQuarks(new String[]{"CPUs", WILDCARD, "Current_thread"});
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        Collection<Long> times = ThreadStatusDataProvider.getTimes(ss, filter);
        try {
            for (ITmfStateInterval interval : ss.query2D((Collection)quarks, times)) {
                if (monitor != null && monitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                currentThreadIntervalsMap.put((Object)interval.getAttribute(), (Object)interval);
            }
            for (Collection currentThreadIntervals : currentThreadIntervalsMap.asMap().values()) {
                if (monitor != null && monitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                linkList.addAll(this.createCpuArrows(ss, (NavigableSet)currentThreadIntervals));
            }
        }
        catch (StateSystemDisposedException | TimeRangeException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, String.valueOf(e.getMessage()));
        }
        return new TmfModelResponse(linkList, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private List<@NonNull TimeGraphArrow> createCpuArrows(ITmfStateSystem ss, NavigableSet<ITmfStateInterval> intervals) throws StateSystemDisposedException {
        ITmfStateInterval last;
        long end;
        if (intervals.isEmpty()) {
            return Collections.emptyList();
        }
        ITmfStateInterval first = (ITmfStateInterval)intervals.first();
        long start = first.getStartTime() - 1L;
        if (start >= ss.getStartTime() && Objects.equals(first.getValue(), 0)) {
            intervals.add(ss.querySingleState(start, first.getAttribute()));
        }
        if ((end = (last = (ITmfStateInterval)intervals.last()).getEndTime() + 1L) <= ss.getCurrentEndTime() && Objects.equals(last.getValue(), 0)) {
            intervals.add(ss.querySingleState(end, last.getAttribute()));
        }
        ArrayList<@NonNull TimeGraphArrow> linkList = new ArrayList<TimeGraphArrow>();
        long prevEnd = 0L;
        long lastEnd = 0L;
        long prevEntry = -1L;
        for (ITmfStateInterval currentThreadInterval : intervals) {
            long time = currentThreadInterval.getStartTime();
            if (time != lastEnd) {
                prevEntry = -1L;
                prevEnd = 0L;
            }
            Integer tid = (Integer)currentThreadInterval.getValue();
            lastEnd = currentThreadInterval.getEndTime() + 1L;
            long nextEntry = -1L;
            if (tid == null || tid <= 0) continue;
            nextEntry = this.findEntry(tid, time);
            if (prevEntry >= 0L && nextEntry >= 0L) {
                linkList.add(new TimeGraphArrow(prevEntry, nextEntry, prevEnd, time - prevEnd));
            }
            prevEntry = nextEntry;
            prevEnd = lastEnd;
        }
        return linkList;
    }

    private long findEntry(int tid, long time) {
        ThreadEntryModel.Builder entry = (ThreadEntryModel.Builder)Iterables.find((Iterable)this.fTidToEntry.get((Object)tid), cfe -> cfe.getStartTime() <= time && time <= cfe.getEndTime(), null);
        return entry != null ? entry.getId() : this.fTraceId;
    }

    public @NonNull String getId() {
        return ID;
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        boolean completed = ss.waitUntilBuilt(0L);
        ITmfResponse.Status status = completed ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING;
        String statusMessage = completed ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING;
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        Integer quark = this.fQuarkMap.get(filter.getSelectedItems().iterator().next());
        if (quark == null) {
            return new TmfModelResponse(null, status, statusMessage);
        }
        long start = filter.getStart();
        int currentCpuRqQuark = ss.optQuarkRelative(quark.intValue(), new String[]{"Current_cpu_rq"});
        if (currentCpuRqQuark == -2 || start < ss.getStartTime() || start > ss.getCurrentEndTime()) {
            return new TmfModelResponse(null, status, statusMessage);
        }
        try {
            ITmfStateInterval interval = ss.querySingleState(start, currentCpuRqQuark);
            Object value = interval.getValue();
            if (value instanceof Integer) {
                return new TmfModelResponse((Object)ImmutableMap.of((Object)OsStrings.cpu(), (Object)String.valueOf(value)), status, statusMessage);
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return new TmfModelResponse(null, status, statusMessage);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Deprecated
    public TmfModelResponse<List<ThreadEntryModel>> fetchTree(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        @NonNull @NonNull @NonNull Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        TmfModelResponse<@NonNull TmfTreeModel<@NonNull ThreadEntryModel>> response = this.fetchTree(parameters, monitor);
        @NonNull TmfTreeModel model = (TmfTreeModel)response.getModel();
        List treeModel = null;
        if (model != null) {
            treeModel = model.getEntries();
        }
        return new TmfModelResponse((Object)treeModel, response.getStatus(), response.getStatusMessage());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Deprecated
    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphRowModel>> fetchRowModel(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        @NonNull @NonNull @NonNull Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
        TmfModelResponse<@NonNull TimeGraphModel> response = this.fetchRowModel(parameters, monitor);
        TimeGraphModel model = (TimeGraphModel)response.getModel();
        List rows = null;
        if (model != null) {
            rows = model.getRows();
        }
        return new TmfModelResponse((Object)rows, response.getStatus(), response.getStatusMessage());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Deprecated
    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        @NonNull @NonNull @NonNull Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        return this.fetchArrows(parameters, monitor);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Deprecated
    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        @NonNull @NonNull @NonNull Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
        return this.fetchTooltip(parameters, monitor);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Multimap<@NonNull String, @NonNull Object> getFilterData(long entryId, long time, @Nullable IProgressMonitor monitor) {
        @NonNull @NonNull Multimap data = ITimeGraphStateFilter.mergeMultimaps((Multimap[])new Multimap[]{super.getFilterData(entryId, time, monitor), this.fEntryMetadata.getOrDefault(entryId, (Multimap<String, Object>)ImmutableMultimap.of())});
        SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(Collections.singletonList(time), Collections.singleton(Objects.requireNonNull(entryId)));
        TmfModelResponse<Map<String, String>> response = this.fetchTooltip(filter, monitor);
        @NonNull @NonNull Map model = (Map)response.getModel();
        if (model != null) {
            for (Map.Entry entry : model.entrySet()) {
                data.put((Object)((String)entry.getKey()), entry.getValue());
            }
        }
        return data;
    }

    private static /* synthetic */ boolean lambda$4(ThreadEntryModel threadEntryModel, String name) {
        return name.equals(threadEntryModel.getName());
    }
}

