/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.dataprovider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class DataProviderParameterUtils {
    public static final String REQUESTED_TIME_KEY = "requested_times";
    public static final String REQUESTED_ITEMS_KEY = "requested_items";
    public static final String REQUESTED_TABLE_COUNT_KEY = "requested_table_count";
    public static final String REQUESTED_TABLE_INDEX_KEY = "requested_table_index";
    public static final String REQUESTED_COLUMN_IDS_KEY = "requested_table_column_ids";
    public static final String FILTERED_KEY = "isFiltered";
    public static final String REGEX_MAP_FILTERS_KEY = "regex_map_filters";

    private DataProviderParameterUtils() {
    }

    public static @Nullable List<Long> extractLongList(Map<String, Object> parameters, String key) {
        Object listObject = parameters.get(key);
        if (listObject instanceof List) {
            return DataProviderParameterUtils.transformToLongList((List)listObject);
        }
        return null;
    }

    public static @Nullable Boolean extractBoolean(Map<String, Object> parameters, String key) {
        Object booleanObject = parameters.get(key);
        if (booleanObject instanceof Boolean) {
            return (Boolean)booleanObject;
        }
        return null;
    }

    public static @Nullable List<Long> extractTimeRequested(Map<String, Object> parameters) {
        return DataProviderParameterUtils.extractLongList(parameters, REQUESTED_TIME_KEY);
    }

    public static @Nullable List<Long> extractSelectedItems(Map<String, Object> parameters) {
        return DataProviderParameterUtils.extractLongList(parameters, REQUESTED_ITEMS_KEY);
    }

    public static @Nullable Boolean extractIsFiltered(Map<String, Object> parameters) {
        return DataProviderParameterUtils.extractBoolean(parameters, FILTERED_KEY);
    }

    public static @Nullable Multimap<Integer, String> extractRegexFilter(Map<String, Object> parameters) {
        Object regexesObject = parameters.get(REGEX_MAP_FILTERS_KEY);
        if (!(regexesObject instanceof Map)) {
            return null;
        }
        HashMultimap regexes = HashMultimap.create();
        Map regexesMap = (Map)regexesObject;
        for (Map.Entry entry : regexesMap.entrySet()) {
            regexes.putAll((Object)((Integer)entry.getKey()), (Iterable)entry.getValue());
        }
        return regexes;
    }

    private static @Nullable List<Long> transformToLongList(List<?> listToTransform) {
        if (!listToTransform.isEmpty()) {
            if (listToTransform.stream().allMatch(e -> e instanceof Long)) {
                return listToTransform;
            }
            if (listToTransform.stream().allMatch(e -> e instanceof Integer)) {
                ArrayList<Long> list = new ArrayList<Long>();
                for (Integer n : listToTransform) {
                    list.add(n.longValue());
                }
                return list;
            }
            ArrayList<Long> list = new ArrayList<Long>();
            for (Long l : listToTransform) {
                if (!(l instanceof Number)) {
                    return null;
                }
                list.add(((Number)l).longValue());
            }
            return list;
        }
        return Collections.emptyList();
    }
}

