/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.timegraph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;

public interface ITimeGraphStateFilter {
    @Deprecated
    default public void addToStateList(List<ITimeGraphState> stateList, ITimeGraphState timeGraphState, Long key, Map<Integer, Predicate<Map<String, String>>> predicates, @Nullable IProgressMonitor monitor) {
        if (!predicates.isEmpty()) {
            long startTime = timeGraphState.getStartTime();
            SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(Collections.singletonList(startTime), Collections.singleton(Objects.requireNonNull(key)));
            Map<@NonNull String, @NonNull String> input = this.getFilterInput(filter, monitor);
            input.putAll(timeGraphState.computeData());
            for (Map.Entry<Integer, Predicate<Map<String, String>>> mapEntry : predicates.entrySet()) {
                Predicate<Map<String, String>> value = Objects.requireNonNull(mapEntry.getValue());
                boolean status = value.test(input);
                Integer property = Objects.requireNonNull(mapEntry.getKey());
                if (property == 1 || property == 4) {
                    timeGraphState.setProperty(property, !status);
                    continue;
                }
                timeGraphState.setProperty(property, status);
            }
        }
        if (timeGraphState.isPropertyActive(4)) {
            TimeGraphState timeGraphState2 = new TimeGraphState(timeGraphState.getStartTime(), timeGraphState.getDuration(), Integer.MIN_VALUE);
            timeGraphState2.setActiveProperties(timeGraphState.getActiveProperties());
            stateList.add(timeGraphState2);
        } else {
            stateList.add(timeGraphState);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    default public void applyFilterAndAddState(List<ITimeGraphState> stateList, ITimeGraphState timeGraphState, Long key, Map<Integer, Predicate<Multimap<String, Object>>> predicates, @Nullable IProgressMonitor monitor) {
        if (!predicates.isEmpty()) {
            long startTime = timeGraphState.getStartTime();
            @NonNull @NonNull HashMultimap input = HashMultimap.create();
            input.putAll(this.getFilterData(key, startTime, monitor));
            input.putAll(timeGraphState.getMetadata());
            for (Map.Entry<Integer, Predicate<Multimap<String, Object>>> mapEntry : predicates.entrySet()) {
                Predicate<Multimap<String, Object>> value = Objects.requireNonNull(mapEntry.getValue());
                boolean status = value.test((Multimap<String, Object>)input);
                Integer property = Objects.requireNonNull(mapEntry.getKey());
                if (property == 1 || property == 4) {
                    timeGraphState.setProperty(property, !status);
                    continue;
                }
                timeGraphState.setProperty(property, status);
            }
        }
        if (timeGraphState.isPropertyActive(4)) {
            TimeGraphState timeGraphState2 = new TimeGraphState(timeGraphState.getStartTime(), timeGraphState.getDuration(), Integer.MIN_VALUE);
            timeGraphState2.setActiveProperties(timeGraphState.getActiveProperties());
            stateList.add(timeGraphState2);
        } else {
            stateList.add(timeGraphState);
        }
    }

    @Deprecated
    default public Map<String, String> getFilterInput(SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new HashMap<String, String>();
    }

    default public Multimap<String, Object> getFilterData(long entryId, long time, @Nullable IProgressMonitor monitor) {
        return ImmutableMultimap.of();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SafeVarargs
    public static Multimap<String, Object> mergeMultimaps(Multimap<String, Object> ... maps) {
        @NonNull @NonNull HashMultimap data = HashMultimap.create();
        Multimap<String, Object>[] multimapArray = maps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            Multimap<String, Object> multimap = multimapArray[n2];
            data.putAll(multimap);
            ++n2;
        }
        return data;
    }
}

