/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;

public class StateItem {
    public static final String UNDEFINED_STATE_NAME = "Undefined";
    private static final int UNDEFINED_COLOR_VALUE = 255;
    private final Map<String, Object> fOriginalStyleMap;
    private final Map<String, Object> fStyleMap;

    @Deprecated
    public StateItem(RGB stateColor) {
        this(stateColor, stateColor.toString());
    }

    public StateItem(Map<String, Object> style) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.putAll(style);
        this.fStyleMap = styleMap;
        this.fOriginalStyleMap = ImmutableMap.copyOf(styleMap);
    }

    public StateItem(RGB stateColor, String stateString) {
        int stateColorInt = new RGBAColor(stateColor.red, stateColor.green, stateColor.blue).toInt();
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put(ITimeEventStyleStrings.fillStyle(), ITimeEventStyleStrings.solidColorFillStyle());
        styleMap.put(ITimeEventStyleStrings.fillColor(), stateColorInt);
        styleMap.put(ITimeEventStyleStrings.label(), stateString);
        this.fStyleMap = styleMap;
        this.fOriginalStyleMap = ImmutableMap.copyOf(styleMap);
    }

    public RGB getStateColor() {
        int rgbInt = (Integer)this.fStyleMap.getOrDefault(ITimeEventStyleStrings.fillColor(), 255);
        return new RGB(rgbInt >> 24 & 0xFF, rgbInt >> 16 & 0xFF, rgbInt >> 8 & 0xFF);
    }

    public void setStateColor(RGB stateColor) {
        if (stateColor != null) {
            int rbgVal = new RGBAColor(stateColor.red, stateColor.green, stateColor.blue).toInt();
            this.fStyleMap.put(ITimeEventStyleStrings.fillColor(), rbgVal);
        }
    }

    public float getStateHeightFactor() {
        Object itemType = this.fStyleMap.get(ITimeEventStyleStrings.itemTypeProperty());
        float defaultStateWidth = ITimeEventStyleStrings.linkType().equals(itemType) ? 0.1f : 1.0f;
        return ((Float)this.fStyleMap.getOrDefault(ITimeEventStyleStrings.heightFactor(), Float.valueOf(defaultStateWidth))).floatValue();
    }

    public String getStateString() {
        return String.valueOf(this.fStyleMap.getOrDefault(ITimeEventStyleStrings.label(), UNDEFINED_STATE_NAME));
    }

    public void reset() {
        this.fStyleMap.clear();
        this.fStyleMap.putAll(this.fOriginalStyleMap);
    }

    public void setStateString(String stateString) {
        this.fStyleMap.put(ITimeEventStyleStrings.label(), stateString);
    }

    public Map<String, Object> getStyleMap() {
        return this.fStyleMap;
    }
}

