/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.communication.timely;

import java.util.Collection;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.rete.index.IndexerListener;
import org.eclipse.viatra.query.runtime.rete.index.StandardIndexer;
import org.eclipse.viatra.query.runtime.rete.network.NetworkStructureChangeSensitiveNode;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.ProductionNode;
import org.eclipse.viatra.query.runtime.rete.network.StandardNode;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.TimelyCommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.TimelyIndexerListenerProxy;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.TimelyMailboxProxy;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.TimestampTransformation;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.single.DiscriminatorDispatcherNode;

public class TimelyCommunicationTracker
extends CommunicationTracker {
    public static final Function<Node, Function<Node, String>> EDGE_LABEL_FUNCTION = new Function<Node, Function<Node, String>>(){

        @Override
        public Function<Node, String> apply(final Node source) {
            return new Function<Node, String>(){

                @Override
                public String apply(Node target) {
                    Collection<Mailbox> mailboxes;
                    if (source instanceof StandardIndexer) {
                        Collection<IndexerListener> listeners = ((StandardIndexer)source).getListeners();
                        for (IndexerListener listener : listeners) {
                            if (listener.getOwner() != target || !(listener instanceof TimelyIndexerListenerProxy)) continue;
                            return ((TimelyIndexerListenerProxy)listener).preprocessor.toString();
                        }
                    }
                    if (source instanceof StandardNode) {
                        mailboxes = ((StandardNode)source).getChildMailboxes();
                        for (Mailbox mailbox : mailboxes) {
                            if (mailbox.getReceiver() != target || !(mailbox instanceof TimelyMailboxProxy)) continue;
                            return ((TimelyMailboxProxy)mailbox).preprocessor.toString();
                        }
                    }
                    if (source instanceof DiscriminatorDispatcherNode) {
                        mailboxes = ((DiscriminatorDispatcherNode)source).getBucketMailboxes().values();
                        for (Mailbox mailbox : mailboxes) {
                            if (mailbox.getReceiver() != target || !(mailbox instanceof TimelyMailboxProxy)) continue;
                            return ((TimelyMailboxProxy)mailbox).preprocessor.toString();
                        }
                    }
                    return null;
                }
            };
        }
    };

    @Override
    protected CommunicationGroup createGroup(Node representative, int index) {
        boolean isSingleton = this.sccInformationProvider.sccs.getPartition((Object)representative).size() == 1;
        return new TimelyCommunicationGroup(this, representative, index, isSingleton);
    }

    @Override
    public Mailbox proxifyMailbox(Node requester, Mailbox original) {
        TimestampTransformation preprocessor = this.getPreprocessor(requester, original.getReceiver());
        if (preprocessor == null) {
            return original;
        }
        return new TimelyMailboxProxy(original, preprocessor);
    }

    @Override
    public IndexerListener proxifyIndexerListener(Node requester, IndexerListener original) {
        TimestampTransformation preprocessor = this.getPreprocessor(requester, original.getOwner());
        if (preprocessor == null) {
            return original;
        }
        return new TimelyIndexerListenerProxy(original, preprocessor);
    }

    protected TimestampTransformation getPreprocessor(Node source, Node target) {
        CommunicationGroup sourceGroup = this.getGroup(source);
        CommunicationGroup targetGroup = this.getGroup(target);
        if (sourceGroup != null && targetGroup != null) {
            if (sourceGroup != targetGroup && sourceGroup.isRecursive()) {
                return TimestampTransformation.RESET;
            }
            if (sourceGroup == targetGroup && target instanceof ProductionNode) {
                return TimestampTransformation.INCREMENT;
            }
        }
        return null;
    }

    @Override
    protected void postProcessNode(Node node) {
        if (node instanceof NetworkStructureChangeSensitiveNode) {
            ((NetworkStructureChangeSensitiveNode)node).networkStructureChanged();
        }
    }
}

