/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette.command;

import java.util.List;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.xml.editor.palette.command.Command;
import org.eclipse.wb.internal.core.xml.editor.palette.model.AbstractElementInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.CategoryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.EntryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.PaletteInfo;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementVisibilityCommand
extends Command {
    public static final String ID = "visibleElement";
    private final String m_id;
    private final boolean m_visible;

    public ElementVisibilityCommand(AbstractElementInfo element, boolean visible) {
        this.m_id = element.getId();
        this.m_visible = visible;
    }

    public ElementVisibilityCommand(Attributes attributes) {
        this.m_id = attributes.getValue("id");
        this.m_visible = "true".equals(attributes.getValue("visible"));
    }

    @Override
    public void execute(PaletteInfo palette) {
        EntryInfo entry;
        CategoryInfo category = palette.getCategory(this.m_id);
        if (category != null) {
            category.setVisible(this.m_visible);
        }
        if ((entry = palette.getEntry(this.m_id)) != null) {
            entry.setVisible(this.m_visible);
        }
    }

    @Override
    protected void addAttributes() {
        this.addAttribute("id", this.m_id);
        this.addAttribute("visible", this.m_visible);
    }

    @Override
    public void addToCommandList(final List<Command> commands) {
        ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ElementVisibilityCommand.this.removeCommands(commands, ElementVisibilityCommand.class, ElementVisibilityCommand.this.m_id);
            }
        });
        commands.add(this);
    }
}

