import { StepProgressEventsEmitter, IObservableEvents, IStepStartedEventsEmitter } from '../executionTimingsReporter';
import { TargetVersions } from './chromeTargetDiscoveryStrategy';
import { Protocol as Crdp } from 'devtools-protocol';
export interface ITarget {
    description: string;
    devtoolsFrontendUrl: string;
    id: string;
    thumbnailUrl?: string;
    title: string;
    type: string;
    url?: string;
    webSocketDebuggerUrl: string;
    version: Promise<TargetVersions>;
}
export declare type ITargetFilter = (target: ITarget) => boolean;
export interface ITargetDiscoveryStrategy {
    getTarget(address: string, port: number, targetFilter?: ITargetFilter, targetUrl?: string): Promise<ITarget>;
    getAllTargets(address: string, port: number, targetFilter?: ITargetFilter, targetUrl?: string): Promise<ITarget[]>;
}
export interface IChromeError {
    code: number;
    message: string;
    data: string;
}
/**
 * Connects to a target supporting the Chrome Debug Protocol and sends and receives messages
 */
export declare class ChromeConnection implements IObservableEvents<IStepStartedEventsEmitter> {
    private static ATTACH_TIMEOUT;
    private _socket;
    private _crdpSocketMultiplexor;
    private _client;
    private _targetFilter;
    private _targetDiscoveryStrategy;
    private _attachedTarget;
    readonly events: StepProgressEventsEmitter;
    constructor(targetDiscovery?: ITargetDiscoveryStrategy & IObservableEvents<IStepStartedEventsEmitter>, targetFilter?: ITargetFilter);
    readonly isAttached: boolean;
    readonly api: Crdp.ProtocolApi;
    readonly attachedTarget: ITarget;
    setTargetFilter(targetFilter?: ITargetFilter): void;
    /**
     * Attach the websocket to the first available tab in the chrome instance with the given remote debugging port number.
     */
    attach(address?: string, port?: number, targetUrl?: string, timeout?: number, extraCRDPChannelPort?: number): Promise<void>;
    attachToWebsocketUrl(wsUrl: string, extraCRDPChannelPort?: number): void;
    getAllTargets(address?: string, port?: number, targetFilter?: ITargetFilter, targetUrl?: string): Promise<ITarget[]>;
    private _attach(address, port, targetUrl?, timeout?, extraCRDPChannelPort?);
    run(): Promise<void>;
    close(): void;
    onClose(handler: () => void): void;
    readonly version: Promise<TargetVersions>;
}
