/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ResolverUtil;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.TagCreationAttribute;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.palette.ITagDropSourceData;
import org.eclipse.jst.pagedesigner.editors.palette.MetadataTagDropSourceData;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolCreationAdapter;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteItemManager;
import org.eclipse.jst.pagedesigner.itemcreation.CreationData;
import org.eclipse.jst.pagedesigner.itemcreation.command.ElementCustomizationCommand;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.ICustomizationData;
import org.eclipse.jst.pagedesigner.utils.CommandUtil;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserCustomizedElementCustomizationCommand
extends ElementCustomizationCommand {
    public UserCustomizedElementCustomizationCommand(IDOMModel model, Element element, CreationData creationData) {
        super(model, element, creationData);
    }

    @Override
    public void execute() {
        super.execute();
    }

    @Override
    protected void applyChildElementCustomization() {
        ICustomizationData data;
        if (this._creationData.getDropCustomizationData() != null && (data = (ICustomizationData)this._creationData.getDropCustomizationData().getAdapter(ICustomizationData.class)).getChildrenData() != null) {
            int childCount = 0;
            for (ICustomizationData child : data.getChildrenData().getChildList()) {
                assert (this._element.getOwnerDocument() != null);
                Element childNode = this._element.getOwnerDocument().createElement(child.getTagIdentifier().getTagName());
                String prefix = JSPUtil.getOrCreatePrefix(this._model, child.getTagIdentifier().getUri(), null);
                childNode.setPrefix(prefix);
                Map<String, String> attrMap = child.getAttributeData().getAttributes();
                for (String attrName : attrMap.keySet()) {
                    String attrValue = attrMap.get(attrName);
                    childNode.setAttribute(attrName, attrValue);
                }
                this._element.appendChild(childNode);
                IFile fileForDocument = ResolverUtil.getFileForDocument((IDocument)this._model.getStructuredDocument());
                if (fileForDocument == null) {
                    PDPlugin.log("File not found for model: " + this._model.toString(), new Exception("Stack trace only"));
                    continue;
                }
                String uri = child.getTagIdentifier().getUri();
                String tagName = child.getTagIdentifier().getTagName();
                ITagDropSourceData creationProvider = TagToolCreationAdapter.findProviderForContainer(uri, tagName, PaletteItemManager.createPaletteContext(fileForDocument));
                IMetaDataModelContext modelContext = CommandUtil.getMetadataModelContext(child.getTagIdentifier().getUri(), this._model);
                DOMPosition domPosition = new DOMPosition(this._element, childCount++);
                CreationData creationData = new CreationData(creationProvider, this._model, (IDOMPosition)domPosition, modelContext, (IAdaptable)child);
                UserCustomizedElementCustomizationCommand command = new UserCustomizedElementCustomizationCommand(this._model, childNode, creationData);
                ((ElementCustomizationCommand)command).execute();
            }
        }
    }

    @Override
    protected void applyAttributeCustomization() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.addAttributesFromPaletteMetadata(attributes);
        this.addAttributesFromDropCustomization(attributes);
        for (Map.Entry entry : attributes.entrySet()) {
            this._element.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void addAttributesFromDropCustomization(Map<String, String> attributes) {
        if (this._creationData.getDropCustomizationData() != null) {
            ICustomizationData data = (ICustomizationData)this._creationData.getDropCustomizationData().getAdapter(ICustomizationData.class);
            Map<String, String> attrs = data.getAttributeData().getAttributes();
            for (String id : attrs.keySet()) {
                attributes.put(id, attrs.get(id) == null ? "" : attrs.get(id));
            }
        }
    }

    private void addAttributesFromPaletteMetadata(Map<String, String> attributes) {
        MetadataTagDropSourceData provider;
        List<TagCreationAttribute> list;
        ITagDropSourceData info = this._creationData.getTagCreationProvider();
        if (info != null && (list = (provider = TagToolCreationAdapter.createMdTagCreationProvider(info, this._model)).getAttributes()) != null) {
            for (TagCreationAttribute attr : list) {
                attributes.put(attr.getId(), attr.getValue() == null ? "" : attr.getValue());
            }
        }
    }
}

