/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractNewComponentNameHandler;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewLogicalNameHandler
extends AbstractNewComponentNameHandler {
    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof ObjectMappingMultiPageEditor) {
            final ObjectMappingMultiPageEditor omEditor = (ObjectMappingMultiPageEditor)activePart;
            omEditor.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    String newName = NewLogicalNameHandler.this.openDialog();
                    if (newName != null) {
                        NewLogicalNameHandler.this.performOperation(omEditor, newName);
                    }
                }
            });
        }
        return null;
    }

    private void performOperation(ObjectMappingMultiPageEditor omEditor, String newName) {
        IObjectMappingPO objMap = omEditor.getAut().getObjMap();
        IWritableComponentNameCache cache = omEditor.getCompNameCache();
        IObjectMappingAssoziationPO assoc = PoMaker.createObjectMappingAssoziationPO(null, new HashSet());
        IComponentNamePO compName = this.performOperation(newName, cache);
        cache.changeReuse((IComponentNameReuser)assoc, null, compName.getGuid());
        objMap.getUnmappedLogicalCategory().addAssociation(assoc);
        omEditor.getEditorHelper().setDirty(true);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)objMap.getUnmappedLogicalCategory(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)compName, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
        omEditor.getTreeViewer().setExpandedState((Object)objMap.getUnmappedLogicalCategory(), true);
    }
}

