/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedParamText;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.ChooseTestCaseData;
import org.eclipse.swt.widgets.Combo;

public class ReplaceExecTestCaseData
extends ChooseTestCaseData {
    private Map<IParamDescriptionPO, IParamDescriptionPO> m_newOldParamMap;
    private Map<IParamDescriptionPO, String> m_unmatchedValuesMap = new HashMap<IParamDescriptionPO, String>();

    public ReplaceExecTestCaseData(Set<IExecTestCasePO> execTestCases) {
        super(execTestCases);
    }

    @Override
    public void setNewSpecTestCase(ISpecTestCasePO newSpecTestCase) {
        super.setNewSpecTestCase(newSpecTestCase);
        ArrayList<String> oldParamNames = new ArrayList<String>();
        if (newSpecTestCase != null) {
            int size = newSpecTestCase.getParameterListSize();
            int i = 0;
            while (i < size) {
                oldParamNames.add(null);
                ++i;
            }
        }
        this.setOldParameterNames(oldParamNames);
    }

    public List<String> getOldParameterNamesByType(IParamDescriptionPO newParamDesc) {
        ArrayList<String> matchingNames = new ArrayList<String>();
        for (IParamDescriptionPO oldParamDesc : this.getOldSpecTestCase().getParameterList()) {
            String newType = newParamDesc.getType();
            if (!"java.lang.String".equals(newType) && !newParamDesc.getType().equals(oldParamDesc.getType())) continue;
            matchingNames.add(oldParamDesc.getName());
        }
        return matchingNames;
    }

    public void setOldParameterNamesWithCombos(List<Combo> oldParamNameCombos) {
        ArrayList<String> oldParamNames = new ArrayList<String>(oldParamNameCombos.size());
        for (Combo combo : oldParamNameCombos) {
            String oldParamName = null;
            if (combo != null) {
                oldParamName = combo.getText();
            }
            oldParamNames.add(oldParamName);
        }
        this.setOldParameterNames(oldParamNames);
    }

    public void setUnmatchedValuesMap(Map<IParamDescriptionPO, CheckedParamText> textFields) {
        this.m_unmatchedValuesMap.clear();
        for (IParamDescriptionPO desc : textFields.keySet()) {
            CheckedParamText text = textFields.get(desc);
            if (text.isValid()) {
                this.m_unmatchedValuesMap.put(desc, text.getText());
                continue;
            }
            this.m_unmatchedValuesMap.put(desc, "");
        }
    }

    private void setOldParameterNames(List<String> oldParamNames) {
        ISpecTestCasePO newSpec = this.getNewSpecTestCase();
        Iterator<String> it = oldParamNames.iterator();
        HashMap<IParamDescriptionPO, IParamDescriptionPO> newOldParamMap = new HashMap<IParamDescriptionPO, IParamDescriptionPO>();
        for (IParamDescriptionPO newParamDesc : newSpec.getParameterList()) {
            IParamDescriptionPO oldParamDesc = null;
            String oldName = it.next();
            if (oldName != null) {
                oldParamDesc = this.getOldSpecTestCase().getParameterForName(oldName);
            }
            newOldParamMap.put(newParamDesc, oldParamDesc);
        }
        this.m_newOldParamMap = newOldParamMap;
    }

    public Map<IParamDescriptionPO, IParamDescriptionPO> getNewOldParamMap() {
        return this.m_newOldParamMap;
    }

    public Map<IParamDescriptionPO, String> getUnmatchedValuesMap() {
        return this.m_unmatchedValuesMap;
    }

    public boolean haveNewAndOldTestCasesNoParameters() {
        return this.getNewSpecTestCase().getParameterListSize() == 0 && this.getOldSpecTestCase().getParameterListSize() == 0;
    }

    public boolean hasUnmatchedNewParameters() {
        return this.m_newOldParamMap.values().contains(null);
    }

    public boolean hasUnmatchedOldParameters() {
        ArrayList tmpParams = new ArrayList(this.getOldSpecTestCase().getParameterList());
        tmpParams.removeAll(this.m_newOldParamMap.values());
        return !tmpParams.isEmpty();
    }

    public boolean hasNoMatching() {
        Collection<IParamDescriptionPO> values = this.m_newOldParamMap.values();
        return Collections.frequency(values, null) == values.size();
    }
}

