/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.MaskLabelHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.uml2.uml.Element;

public abstract class AbstractMaskManagedEditPolicy
extends GraphicalEditPolicyEx
implements NotificationListener,
IPapyrusListener,
IMaskManagedLabelEditPolicy {
    protected Element hostSemanticElement;
    protected View view;

    public void activate() {
        this.view = this.getView();
        if (this.view == null) {
            return;
        }
        this.hostSemanticElement = this.initSemanticElement();
        if (this.hostSemanticElement != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)this.view, (NotificationListener)this);
            this.getDiagramEventBroker().addNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
            this.addAdditionalListeners();
            this.refreshDisplay();
        } else {
            Activator.log.error("No semantic element was found during activation of the mask managed label edit policy", null);
        }
    }

    protected Element initSemanticElement() {
        return (Element)this.getView().getElement();
    }

    protected void addAdditionalListeners() {
    }

    public void refresh() {
        super.refresh();
        this.refreshDisplay();
    }

    public void deactivate() {
        if (this.view != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.view, (NotificationListener)this);
        }
        if (this.hostSemanticElement != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
            this.removeAdditionalListeners();
        }
        this.hostSemanticElement = null;
        this.view = null;
    }

    protected void removeAdditionalListeners() {
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public Element getUMLElement() {
        return this.hostSemanticElement;
    }

    protected View getView() {
        if (this.getHost() == null) {
            return null;
        }
        return (View)this.getHost().getModel();
    }

    protected boolean isMaskManagedAnnotation(Object object) {
        return object instanceof NamedStyle && "maskLabel".equals(((NamedStyle)object).getName());
    }

    protected boolean isRemovedMaskManagedLabelAnnotation(Object object, Notification notification) {
        Object oldValue;
        if (object instanceof EModelElement && notification.getEventType() == 4 && (oldValue = notification.getOldValue()) instanceof NamedStyle) {
            return "maskLabel".equals(((NamedStyle)oldValue).getName());
        }
        return false;
    }

    public abstract void refreshDisplay();

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object != null && object.equals(this.getView())) {
            this.refreshDisplay();
        }
    }

    public void setDefaultDisplayValue() {
        MaskLabelHelper.unsetMaskValues((View)this.getView());
    }

    public void updateDisplayValue(Collection<String> newValue) {
        MaskLabelHelper.setMaskValues((View)this.getView(), newValue);
    }

    public Collection<String> getCurrentDisplayValue() {
        Collection maskValues = MaskLabelHelper.getMaskValues((View)this.getView());
        if (maskValues == null) {
            return this.getDefaultDisplayValue();
        }
        return maskValues;
    }

    protected abstract Collection<String> getDefaultDisplayValue();
}

