/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.assist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;

public class ProposalProviderDescriptor {
    public static final String PROPOSAL_PROVIDER_ATTRIBUTE_CLASS = "class";
    private static final String PROPOSAL_PROVIDER_ATTRIBUTE_INTERPRETER = "interpreter";
    private final IConfigurationElement element;
    private final String proposalProviderClassName;
    private final String interpreter;

    public ProposalProviderDescriptor(IConfigurationElement element) {
        this.element = element;
        this.interpreter = element.getAttribute(PROPOSAL_PROVIDER_ATTRIBUTE_INTERPRETER);
        this.proposalProviderClassName = element.getAttribute(PROPOSAL_PROVIDER_ATTRIBUTE_CLASS);
    }

    public String getClassName() {
        return this.proposalProviderClassName;
    }

    public String getInterpreter() {
        return this.interpreter;
    }

    public IProposalProvider createProposalProvider() {
        try {
            Object instance = this.element.createExecutableExtension(PROPOSAL_PROVIDER_ATTRIBUTE_CLASS);
            if (instance instanceof IProposalProvider) {
                return (IProposalProvider)instance;
            }
        }
        catch (CoreException e) {
            DslCommonPlugin.getDefault().error(e.getMessage(), e);
        }
        return null;
    }
}

