/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor;

import java.io.IOException;
import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.tcf.te.tcf.ui.editor.AbstractCustomFormToolkitEditorPage;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class AbstractConfigurationEditorPage
extends AbstractCustomFormToolkitEditorPage {
    private IEventListener listener = null;

    @Override
    protected void setInput(IEditorInput input) {
        IEditorInput oldInput = this.getEditorInput();
        if (oldInput != null && oldInput.equals(input)) {
            return;
        }
        super.setInput(input);
        if (this.listener == null) {
            this.listener = new IEventListener(){

                public void eventFired(EventObject event) {
                    ChangeEvent changeEvent = (ChangeEvent)event;
                    if (("ConnectState".equals(changeEvent.getEventId()) || "isValid".equals(changeEvent.getEventId()) || "Warnings".equals(changeEvent.getEventId())) && event.getSource() == AbstractConfigurationEditorPage.this.getEditorInputNode()) {
                        ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (!AbstractConfigurationEditorPage.this.getManagedForm().getForm().isDisposed()) {
                                    AbstractConfigurationEditorPage.this.setFormTitle(AbstractConfigurationEditorPage.this.getFormTitle());
                                    AbstractConfigurationEditorPage.this.setFormImage(AbstractConfigurationEditorPage.this.getFormImage());
                                }
                            }
                        });
                    }
                }
            };
            EventManager.getInstance().addEventListener(this.listener, ChangeEvent.class);
        }
    }

    public void dispose() {
        if (this.listener != null) {
            EventManager.getInstance().removeEventListener(this.listener);
            this.listener = null;
        }
        super.dispose();
    }

    public void postDoSave(IProgressMonitor monitor) {
        super.postDoSave(monitor);
        final Object input = this.getEditorInputNode();
        if (input instanceof IPeerNode) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                        if (uRIPersistenceService == null) {
                            throw new IOException("Persistence service instance unavailable.");
                        }
                        uRIPersistenceService.write((Object)((IPeerNode)input).getPeer(), null);
                    }
                    catch (IOException e) {
                        String template = NLS.bind((String)Messages.AbstractConfigurationEditorPage_error_save, (Object)((IPeerNode)input).getName(), (Object)Messages.AbstractConfigurationEditorPage_error_possibleCause);
                        StatusHandlerUtil.handleStatus((IStatus)StatusHelper.getStatus((Throwable)e), (Object)input, (String)template, null, (String)IContextHelpIds.MESSAGE_SAVE_FAILED, (Object)((Object)AbstractConfigurationEditorPage.this), null);
                    }
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            Protocol.invokeAndWait((Runnable)runnable);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((IPeerNode)input).fireChangeEvent("properties", null, (Object)((IPeerNode)input).getProperties());
                }
            });
            IPathMapService service = (IPathMapService)ServiceManager.getInstance().getService(input, IPathMapService.class);
            if (service != null) {
                service.generateSourcePathMappings(input);
            }
        }
    }

    @Override
    protected IContributionItem doCreateLinkContribution(final IToolBarManager tbManager) {
        return new ControlContribution("SetAsDefaultContextLink"){
            IEventListener eventListener;
            {
                super($anonymous0);
                this.eventListener = null;
            }

            public void dispose() {
                super.dispose();
                if (this.eventListener == null) {
                    EventManager.getInstance().removeEventListener(this.eventListener);
                }
            }

            protected Control createControl(Composite parent) {
                final ImageHyperlink hyperlink = new ImageHyperlink(parent, 0);
                hyperlink.setText("Set as default connection");
                hyperlink.setUnderlined(true);
                hyperlink.setForeground(AbstractConfigurationEditorPage.this.getManagedForm().getToolkit().getHyperlinkGroup().getForeground());
                IPeerNode defaultNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
                this.setVisible(defaultNode == null || defaultNode != AbstractConfigurationEditorPage.this.getEditorInputNode());
                hyperlink.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkActivated(HyperlinkEvent e) {
                        if (AbstractConfigurationEditorPage.this.getEditorInputNode() instanceof IPeerNode) {
                            ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).setDefaultContext((IPeerNode)AbstractConfigurationEditorPage.this.getEditorInputNode());
                        }
                    }

                    public void linkEntered(HyperlinkEvent e) {
                        hyperlink.setForeground(AbstractConfigurationEditorPage.this.getManagedForm().getToolkit().getHyperlinkGroup().getActiveForeground());
                    }

                    public void linkExited(HyperlinkEvent e) {
                        hyperlink.setForeground(AbstractConfigurationEditorPage.this.getManagedForm().getToolkit().getHyperlinkGroup().getForeground());
                    }
                });
                this.eventListener = new IEventListener(){

                    public void eventFired(EventObject event) {
                        ChangeEvent changeEvent;
                        if (event instanceof ChangeEvent && (changeEvent = (ChangeEvent)event).getSource() instanceof IDefaultContextService) {
                            IPeerNode defaultNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
                            this.setVisible(defaultNode == null || AbstractConfigurationEditorPage.this.getEditorInputNode() == null || defaultNode != AbstractConfigurationEditorPage.this.getEditorInputNode());
                            ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    tbManager.update(true);
                                }
                            });
                        }
                    }
                };
                EventManager.getInstance().addEventListener(this.eventListener, ChangeEvent.class);
                return hyperlink;
            }
        };
    }
}

