/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;

public final class UnaryIntegerParser
implements ICommonTreeParser {
    public static final UnaryIntegerParser INSTANCE = new UnaryIntegerParser();

    private UnaryIntegerParser() {
    }

    @Override
    public Long parse(CommonTree unaryInteger, ICommonTreeParser.ICommonTreeParserParameter notUsed) throws ParseException {
        long intval;
        List children = unaryInteger.getChildren();
        CommonTree value = (CommonTree)children.get(0);
        String strval = value.getText();
        try {
            intval = Long.decode(strval);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid integer format: " + strval, e);
        }
        if (children.size() % 2 == 0) {
            return -intval;
        }
        return intval;
    }
}

