/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.memories.MaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;

public final class UnaryMaskedTupleMemory<Timestamp extends Comparable<Timestamp>>
extends MaskedTupleMemory<Timestamp> {
    protected IMultiLookup<Object, Tuple> columnToTuples;
    protected final int keyPosition;

    public UnaryMaskedTupleMemory(TupleMask mask, CollectionsFactory.MemoryType bucketType, Object owner) {
        super(mask, owner);
        if (1 != mask.getSize()) {
            throw new IllegalArgumentException(mask.toString());
        }
        this.columnToTuples = CollectionsFactory.createMultiLookup(Object.class, bucketType, Object.class);
        this.keyPosition = mask.indices[0];
    }

    @Override
    public void clear() {
        this.columnToTuples.clear();
    }

    @Override
    public int getKeysetSize() {
        return this.columnToTuples.countKeys();
    }

    @Override
    public int getTotalSize() {
        int i = 0;
        for (Object key : this.columnToTuples.distinctKeys()) {
            i += this.columnToTuples.lookup(key).size();
        }
        return i;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.columnToTuples.distinctValues().iterator();
    }

    @Override
    public Iterable<Tuple> getSignatures() {
        return () -> {
            final Iterator<Object> wrapped = this.columnToTuples.distinctKeys().iterator();
            return new Iterator<Tuple>(){

                @Override
                public boolean hasNext() {
                    return wrapped.hasNext();
                }

                @Override
                public Tuple next() {
                    Object key = wrapped.next();
                    return Tuples.staticArityFlatTupleOf(key);
                }
            };
        };
    }

    @Override
    public Collection<Tuple> get(ITuple signature) {
        Object key = signature.get(0);
        IMemoryView<Tuple> bucket = this.columnToTuples.lookup(key);
        return bucket == null ? null : bucket.distinctValues();
    }

    @Override
    public Map<Tuple, Timestamp> getWithTimestamp(ITuple signature) {
        throw new UnsupportedOperationException("Timeless memories do not support timestamp-based lookup!");
    }

    @Override
    public boolean remove(Tuple tuple, Tuple signature) {
        return this.removeInternal(tuple, tuple.get(this.keyPosition));
    }

    @Override
    public boolean remove(Tuple tuple) {
        return this.removeInternal(tuple, tuple.get(this.keyPosition));
    }

    @Override
    public boolean add(Tuple tuple, Tuple signature) {
        return this.addInternal(tuple, tuple.get(this.keyPosition));
    }

    @Override
    public boolean add(Tuple tuple) {
        return this.addInternal(tuple, tuple.get(this.keyPosition));
    }

    protected boolean addInternal(Tuple tuple, Object key) {
        try {
            return this.columnToTuples.addPair(key, tuple) == IMultiLookup.ChangeGranularity.KEY;
        }
        catch (IllegalStateException ex) {
            throw this.raiseDuplicateInsertion(tuple);
        }
    }

    protected boolean removeInternal(Tuple tuple, Object key) {
        try {
            return this.columnToTuples.removePair(key, tuple) == IMultiLookup.ChangeGranularity.KEY;
        }
        catch (IllegalStateException ex) {
            throw this.raiseDuplicateDeletion(tuple);
        }
    }
}

