/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.is.core;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.cdt.cmake.is.core.CommandEntry;
import org.eclipse.cdt.cmake.is.core.IParserPreferences;
import org.eclipse.cdt.cmake.is.core.IParserPreferencesAccess;
import org.eclipse.cdt.cmake.is.core.Messages;
import org.eclipse.cdt.cmake.is.core.ParseRequest;
import org.eclipse.cdt.cmake.is.core.internal.ParserDetection;
import org.eclipse.cdt.cmake.is.core.internal.StringUtil;
import org.eclipse.cdt.cmake.is.core.internal.builtins.CompilerBuiltinsDetector;
import org.eclipse.cdt.cmake.is.core.participant.IRawIndexerInfo;
import org.eclipse.cdt.cmake.is.core.participant.IToolCommandlineParser;
import org.eclipse.cdt.cmake.is.core.participant.IToolDetectionParticipant;
import org.eclipse.cdt.cmake.is.core.participant.builtins.IBuiltinsDetectionBehavior;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class CompileCommandsJsonParser {
    private static final boolean DEBUG_TIME = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.cmake.is.core/debug/performance"));
    private static final boolean DEBUG_ENTRIES = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.cmake.is.core/debug/detected.entries"));
    private static final QualifiedName TIMESTAMP_COMPILE_COMMANDS_PROPERTY = new QualifiedName(null, "timestamp:compile_commands.json");
    private static final String WORKBENCH_WILL_NOT_KNOW_ALL_MSG = Messages.CompileCommandsJsonParser_MSG_WORKBENCH_WILL_NOT_KNOW;
    private static final String MARKER_ID = "org.eclipse.cdt.cmake.is.core.CompileCommandsJsonParserMarker";
    private ParseRequest parseRequest;
    private final IParserPreferencesAccess prefsAccess;
    private ParserDetection.DetectorWithMethod lastDetector;
    private Set<String> knownUnsupportedTools = new HashSet<String>();
    private Map<String, IRawIndexerInfo> fileResults;
    private Map<String, CompilerBuiltinsDetector> builtinDetectorsToRun;
    private Map<String, String> fileToBuiltinDetectorLinks;

    public CompileCommandsJsonParser(ParseRequest parseRequest) {
        this.parseRequest = Objects.requireNonNull(parseRequest, "parseRequest");
        this.prefsAccess = (IParserPreferencesAccess)EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext()).get(IParserPreferencesAccess.class);
    }

    private boolean processJsonFile(IProgressMonitor monitor) throws CoreException {
        IFile jsonFile = this.parseRequest.getFile();
        IProject project = jsonFile.getProject();
        project.deleteMarkers(MARKER_ID, false, 2);
        java.nio.file.Path jsonDiskFile = java.nio.file.Path.of(jsonFile.getLocationURI());
        if (!Files.exists(jsonDiskFile, new LinkOption[0])) {
            String msg = String.format(Messages.CompileCommandsJsonParser_errmsg_file_not_found, jsonDiskFile, WORKBENCH_WILL_NOT_KNOW_ALL_MSG);
            CompileCommandsJsonParser.createMarker((IResource)project, msg);
            return false;
        }
        long tsJsonModified = 0L;
        try {
            tsJsonModified = Files.getLastModifiedTime(jsonDiskFile, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return false;
        }
        IContainer buildRootFolder = jsonFile.getParent();
        Long sessionLastModified = (Long)buildRootFolder.getSessionProperty(TIMESTAMP_COMPILE_COMMANDS_PROPERTY);
        if (sessionLastModified == null || sessionLastModified < tsJsonModified) {
            monitor.setTaskName(Messages.CompileCommandsJsonParser_msg_processing);
            try {
                Throwable throwable = null;
                Object var10_14 = null;
                try (FileReader in = new FileReader(jsonDiskFile.toFile());){
                    CommandEntry[] sourceFileInfos;
                    Gson gson = new Gson();
                    CommandEntry[] commandEntryArray = sourceFileInfos = (CommandEntry[])gson.fromJson((Reader)in, CommandEntry[].class);
                    int n = sourceFileInfos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CommandEntry sourceFileInfo = commandEntryArray[n2];
                        this.processCommandEntry(sourceFileInfo, jsonFile);
                        ++n2;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (JsonIOException | JsonSyntaxException ex) {
                String msg = String.format(Messages.CompileCommandsJsonParser_errmsg_not_json, jsonDiskFile, WORKBENCH_WILL_NOT_KNOW_ALL_MSG);
                CompileCommandsJsonParser.createMarker((IResource)jsonFile, msg);
                return false;
            }
            catch (IOException ex) {
                String msg = String.format(Messages.CompileCommandsJsonParser_errmsg_read_error, jsonDiskFile, WORKBENCH_WILL_NOT_KNOW_ALL_MSG);
                CompileCommandsJsonParser.createMarker((IResource)jsonFile, msg);
                return false;
            }
            this.detectBuiltins(monitor);
            buildRootFolder.setSessionProperty(TIMESTAMP_COMPILE_COMMANDS_PROPERTY, (Object)tsJsonModified);
            return true;
        }
        return false;
    }

    private void processCommandEntry(CommandEntry sourceFileInfo, IFile jsonFile) throws CoreException {
        String file = sourceFileInfo.getFile();
        String cmdLine = sourceFileInfo.getCommand();
        if (file != null && !file.isEmpty() && cmdLine != null && !cmdLine.isEmpty()) {
            ParserDetection.ParserDetectionResult pdr = this.fastDetermineDetector(cmdLine);
            if (pdr != null) {
                IToolCommandlineParser parser = pdr.getDetectorWithMethod().getToolDetectionParticipant().getParser();
                String cwdStr = sourceFileInfo.getDirectory();
                IPath cwd = cwdStr != null ? Path.fromOSString((String)cwdStr) : new Path("");
                IToolCommandlineParser.IResult result = parser.processArgs(cwd, StringUtil.trimLeadingWS(pdr.getReducedCommandLine()));
                this.rememberFileResult(file, result);
                Optional<IBuiltinsDetectionBehavior> builtinDetection = parser.getIBuiltinsDetectionBehavior();
                if (builtinDetection.isPresent()) {
                    this.rememberBuiltinsDetection(file, builtinDetection.get(), pdr.getCommandLine().getCommand(), result.getBuiltinDetectionArgs());
                }
            } else {
                int idx = cmdLine.indexOf(32);
                String unkownMarker = String.valueOf(idx != -1 ? cmdLine.substring(0, idx) : cmdLine) + FilenameUtils.getExtension((String)file);
                if (this.knownUnsupportedTools.contains(unkownMarker)) {
                    return;
                }
                this.knownUnsupportedTools.add(unkownMarker);
                String msg = String.format(Messages.CompileCommandsJsonParser_errmsg_no_parser_for_commandline, cmdLine, WORKBENCH_WILL_NOT_KNOW_ALL_MSG);
                CompileCommandsJsonParser.createMarker((IResource)jsonFile, msg);
            }
            return;
        }
        String msg = String.format(Messages.CompileCommandsJsonParser_errmsg_unexpected_json, jsonFile, WORKBENCH_WILL_NOT_KNOW_ALL_MSG);
        CompileCommandsJsonParser.createMarker((IResource)jsonFile, msg);
    }

    private void detectBuiltins(IProgressMonitor monitor) throws CoreException {
        if (this.builtinDetectorsToRun.isEmpty()) {
            return;
        }
        monitor.setTaskName(Messages.CompileCommandsJsonParser_msg_detecting_builtins);
        IFile jsonFile = this.parseRequest.getFile();
        IContainer buildRootFolder = jsonFile.getParent();
        java.nio.file.Path buildDir = java.nio.file.Path.of(buildRootFolder.getLocationURI());
        HashMap<String, IRawIndexerInfo> builtinDetectorsResults = new HashMap<String, IRawIndexerInfo>();
        for (Map.Entry<String, CompilerBuiltinsDetector> entry : this.builtinDetectorsToRun.entrySet()) {
            IRawIndexerInfo result = entry.getValue().detectBuiltins(jsonFile.getProject(), buildDir, this.parseRequest.getLauncher(), this.parseRequest.getConsole(), monitor);
            builtinDetectorsResults.put(entry.getKey(), result);
        }
        this.builtinDetectorsToRun.clear();
        HashMap strPool = new HashMap();
        Function<String, String> stringPooler = v -> {
            String old = strPool.putIfAbsent(v, v);
            return old == null ? v : old;
        };
        for (Map.Entry<String, String> link : this.fileToBuiltinDetectorLinks.entrySet()) {
            String sourceFileName = link.getKey();
            IRawIndexerInfo fileResult = this.fileResults.get(sourceFileName);
            IRawIndexerInfo builtinDetectorsResult = (IRawIndexerInfo)builtinDetectorsResults.get(link.getValue());
            this.mergeResultsForFile(stringPooler, sourceFileName, fileResult, builtinDetectorsResult);
        }
    }

    private void mergeResultsForFile(Function<String, String> stringPooler, String sourceFileName, IRawIndexerInfo fileResult, IRawIndexerInfo builtinDetectorsResult) {
        HashMap<String, String> builtinDefines = new HashMap<String, String>(builtinDetectorsResult.getDefines());
        for (String name : fileResult.getUndefines()) {
            String value = (String)builtinDefines.remove(name);
            if (value == null || !DEBUG_ENTRIES) continue;
            System.out.printf("      Removed define: %s=%s%n", name, value);
        }
        Map<String, String> effectiveDefines = Stream.concat(builtinDefines.entrySet().stream(), fileResult.getDefines().entrySet().stream()).collect(Collectors.toMap(stringPooler.compose(Map.Entry::getKey), stringPooler.compose(Map.Entry::getValue)));
        List<String> includePaths = Stream.concat(fileResult.getIncludePaths().stream(), builtinDetectorsResult.getIncludePaths().stream()).map(stringPooler).collect(Collectors.toList());
        List<String> systemIncludePaths = Stream.concat(fileResult.getSystemIncludePaths().stream(), builtinDetectorsResult.getSystemIncludePaths().stream()).map(stringPooler).collect(Collectors.toList());
        List<String> macroFiles = fileResult.getMacroFiles();
        List<String> includeFiles = fileResult.getIncludeFiles();
        this.parseRequest.getIndexerInfoConsumer().acceptSourceFileInfo(sourceFileName, systemIncludePaths, effectiveDefines, includePaths, macroFiles, includeFiles);
    }

    private static void createMarker(IResource rc, String message) throws CoreException {
        IMarker marker = rc.createMarker(MARKER_ID);
        marker.setAttribute("severity", 1);
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("location", (Object)CompileCommandsJsonParser.class.getName());
    }

    private ParserDetection.ParserDetectionResult fastDetermineDetector(String line) {
        String versionPattern;
        ParserDetection.ParserDetectionResult result;
        IParserPreferences prefs = this.prefsAccess.getWorkspacePreferences();
        if (this.lastDetector != null) {
            Optional<Object> matchResult = Optional.empty();
            IToolDetectionParticipant detector = this.lastDetector.getToolDetectionParticipant();
            switch (this.lastDetector.getHow()) {
                case BASENAME: {
                    matchResult = detector.basenameMatches(line, this.lastDetector.isMatchBackslash());
                    break;
                }
                case WITH_EXTENSION: {
                    matchResult = detector.basenameWithExtensionMatches(line, this.lastDetector.isMatchBackslash());
                    break;
                }
                case WITH_VERSION: {
                    if (!prefs.getTryVersionSuffix()) break;
                    matchResult = detector.basenameWithVersionMatches(line, this.lastDetector.isMatchBackslash(), prefs.getVersionSuffixPattern());
                    break;
                }
                case WITH_VERSION_EXTENSION: {
                    if (!prefs.getTryVersionSuffix()) break;
                    matchResult = detector.basenameWithVersionAndExtensionMatches(line, this.lastDetector.isMatchBackslash(), prefs.getVersionSuffixPattern());
                    break;
                }
            }
            if (matchResult.isPresent()) {
                return new ParserDetection.ParserDetectionResult(this.lastDetector, (IToolDetectionParticipant.MatchResult)matchResult.get());
            }
            this.lastDetector = null;
        }
        if ((result = ParserDetection.determineDetector(line, versionPattern = prefs.getTryVersionSuffix() ? prefs.getVersionSuffixPattern() : null, File.separatorChar == '\\')) != null) {
            this.lastDetector = result.getDetectorWithMethod();
        }
        return result;
    }

    public boolean parse(IProgressMonitor monitor) throws CoreException {
        boolean bl;
        block4: {
            long start = 0L;
            this.fileResults = new HashMap<String, IRawIndexerInfo>();
            this.builtinDetectorsToRun = new HashMap<String, CompilerBuiltinsDetector>();
            this.fileToBuiltinDetectorLinks = new HashMap<String, String>();
            try {
                if (DEBUG_TIME) {
                    System.out.printf("Parsing file '%s' ...%n", this.parseRequest.getFile().getLocationURI().getPath());
                    start = System.currentTimeMillis();
                }
                bl = this.processJsonFile(monitor);
                this.parseRequest.getIndexerInfoConsumer().shutdown();
                if (!DEBUG_TIME) break block4;
            }
            catch (Throwable throwable) {
                this.parseRequest.getIndexerInfoConsumer().shutdown();
                if (DEBUG_TIME) {
                    long end = System.currentTimeMillis();
                    System.out.printf("Parsed file '%s' in %dms%n", this.parseRequest.getFile().getLocationURI().getPath(), end - start);
                }
                this.builtinDetectorsToRun = null;
                this.fileResults = null;
                this.fileToBuiltinDetectorLinks = null;
                throw throwable;
            }
            long end = System.currentTimeMillis();
            System.out.printf("Parsed file '%s' in %dms%n", this.parseRequest.getFile().getLocationURI().getPath(), end - start);
        }
        this.builtinDetectorsToRun = null;
        this.fileResults = null;
        this.fileToBuiltinDetectorLinks = null;
        return bl;
    }

    private static String makeBuiltinsDetectorKey(String compilerCommand, List<String> builtinDetectionArgs, String sourceFileExtension) {
        switch (sourceFileExtension) {
            case "C": 
            case "cc": 
            case "cp": 
            case "CPP": 
            case "c++": 
            case "cpp": 
            case "cxx": {
                sourceFileExtension = "cpp";
            }
        }
        return String.valueOf(compilerCommand) + "#" + sourceFileExtension + "#" + String.join((CharSequence)" ", builtinDetectionArgs);
    }

    private void rememberFileResult(String sourceFileName, IRawIndexerInfo result) {
        this.fileResults.put(sourceFileName, result);
    }

    private void rememberBuiltinsDetection(String sourceFileName, IBuiltinsDetectionBehavior builtinsDetectionBehavior, String compilerCommand, List<String> builtinDetectionArgs) {
        String extension = FilenameUtils.getExtension((String)sourceFileName);
        String key = CompileCommandsJsonParser.makeBuiltinsDetectorKey(compilerCommand, builtinDetectionArgs, extension);
        if (!this.builtinDetectorsToRun.containsKey(key)) {
            CompilerBuiltinsDetector detector = new CompilerBuiltinsDetector(builtinsDetectionBehavior, compilerCommand, builtinDetectionArgs, extension);
            this.builtinDetectorsToRun.put(key, detector);
        }
        this.fileToBuiltinDetectorLinks.put(sourceFileName, key);
    }
}

