/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.util.ListComparator;
import org.eclipse.cdt.internal.core.BuildRunnerHelper;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildDescription;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStateManager;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IConfigurationBuildState;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IProjectBuildState;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.StepBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.PropertyManager;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator2;
import org.eclipse.cdt.newmake.core.IMakeBuilderInfo;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class CommonBuilder
extends ACBuilder {
    public static final String BUILDER_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".genmakebuilder";
    private static final String ERROR_HEADER = "GeneratedmakefileBuilder error [";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String TRACE_FOOTER = "]: ";
    private static final String TRACE_HEADER = "GeneratedmakefileBuilder trace [";
    public static boolean VERBOSE = false;
    private static final int PROGRESS_MONITOR_SCALE = 100;
    private static final int TICKS_STREAM_PROGRESS_MONITOR = 100;
    private static final int TICKS_EXECUTE_COMMAND = 100;
    private static final int TICKS_REFRESH_PROJECT = 100;
    private static final int TICKS_DELETE_OUTPUTS = 100;
    private static CfgBuildSet fBuildSet = new CfgBuildSet();
    private boolean fBuildErrOccured;
    private Set<String> builtRefConfigIds = new HashSet<String>();

    public static void outputTrace(String resourceName, String message) {
        if (VERBOSE) {
            System.out.println(TRACE_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    public static void outputError(String resourceName, String message) {
        if (VERBOSE) {
            System.err.println(ERROR_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    protected boolean isCdtProjectCreated(IProject project) {
        ICProjectDescription des = CoreModel.getDefault().getProjectDescription(project, false);
        return des != null && !des.isCdtProjectCreating();
    }

    protected IProject[] build(int kind, Map argsMap, IProgressMonitor monitor) throws CoreException {
        Map args = argsMap;
        fBuildSet.start(this);
        this.builtRefConfigIds.clear();
        IProject project = this.getProject();
        if (!this.isCdtProjectCreated(project)) {
            return project.getReferencedProjects();
        }
        if (VERBOSE) {
            CommonBuilder.outputTrace(project.getName(), ">>build requested, type = " + kind);
        }
        IProject[] projects = null;
        if (CommonBuilder.needAllConfigBuild()) {
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            IConfiguration[] cfgs = info.getManagedProject().getConfigurations();
            IConfiguration defCfg = info.getDefaultConfiguration();
            IConfiguration[] iConfigurationArray = cfgs;
            int n = cfgs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration cfg = iConfigurationArray[n2];
                info.setDefaultConfiguration(cfg);
                IBuilder[] builders = ManagedBuilderCorePlugin.createBuilders(project, args);
                projects = this.build(kind, project, builders, true, monitor, new MyBoolean(false));
                ++n2;
            }
            info.setDefaultConfiguration(defCfg);
        } else {
            IBuilder[] builders = ManagedBuilderCorePlugin.createBuilders(project, args);
            projects = this.build(kind, project, builders, true, monitor, new MyBoolean(false));
        }
        if (VERBOSE) {
            CommonBuilder.outputTrace(project.getName(), "<<done build requested, type = " + kind);
        }
        return projects;
    }

    protected IProject[] build(int kind, IProject project, IBuilder[] builders, boolean isForeground, IProgressMonitor monitor) throws CoreException {
        return this.build(kind, project, builders, isForeground, monitor, new MyBoolean(false));
    }

    private IProject[] build(int kind, IProject project, IBuilder[] builders, boolean isForeground, IProgressMonitor monitor, MyBoolean isBuild) throws CoreException {
        if (!this.isCdtProjectCreated(project)) {
            return project.getReferencedProjects();
        }
        int num = builders.length;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration activeCfg = info.getDefaultConfiguration();
        IProject[] refProjects = project.getReferencedProjects();
        if (num != 0) {
            Set<IProject> set;
            MultiStatus status = this.checkBuilders(builders, activeCfg);
            if (status.getSeverity() != 0) {
                throw new CoreException((IStatus)status);
            }
            IConfiguration[] rcfgs = this.getReferencedConfigs(builders);
            monitor.beginTask("", num + rcfgs.length);
            if (rcfgs.length != 0 && (set = this.buildReferencedConfigs(rcfgs, (IProgressMonitor)new SubProgressMonitor(monitor, 1), isBuild)).size() != 0) {
                set.addAll(Arrays.asList(refProjects));
                refProjects = set.toArray(new IProject[set.size()]);
            }
            int i = 0;
            while (i < num) {
                if (kind == 10 || kind == 9) {
                    if (CommonBuilder.buildConfigResourceChanges()) {
                        IResourceDelta delta = this.getDelta(project);
                        if (delta != null && delta.getAffectedChildren().length > 0) {
                            isBuild.setValue(true);
                            this.build(kind, new CfgBuildInfo(builders[i], isForeground), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else if (isBuild.getValue()) {
                            this.build(kind, new CfgBuildInfo(builders[i], isForeground), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    } else {
                        this.build(kind, new CfgBuildInfo(builders[i], isForeground), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                } else {
                    this.build(kind, new CfgBuildInfo(builders[i], isForeground), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++i;
            }
        }
        if (isForeground) {
            this.updateOtherConfigs(info, builders, kind);
        }
        monitor.done();
        return refProjects;
    }

    private Set<IProject> buildReferencedConfigs(IConfiguration[] cfgs, IProgressMonitor monitor, MyBoolean refConfigChanged) {
        Set<IProject> projSet = this.getProjectsSet(cfgs);
        cfgs = this.filterConfigsToBuild(cfgs);
        MyBoolean nextConfigChanged = new MyBoolean(false);
        if (cfgs.length != 0) {
            monitor.beginTask(ManagedMakeMessages.getResourceString("CommonBuilder.22"), cfgs.length);
            IConfiguration[] iConfigurationArray = cfgs;
            int n = cfgs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration cfg = iConfigurationArray[n2];
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                if (this.builtRefConfigIds.contains(cfg.getId())) {
                    subMonitor.done();
                } else {
                    block12: {
                        nextConfigChanged.setValue(false);
                        try {
                            try {
                                IBuilder builder = cfg.getEditableBuilder();
                                if (VERBOSE) {
                                    CommonBuilder.outputTrace(cfg.getOwner().getProject().getName(), ">>>>building reference cfg " + cfg.getName());
                                }
                                IProject[] projs = this.build(10, cfg.getOwner().getProject(), new IBuilder[]{builder}, false, (IProgressMonitor)subMonitor, nextConfigChanged);
                                if (VERBOSE) {
                                    CommonBuilder.outputTrace(cfg.getOwner().getProject().getName(), "<<<<done building reference cfg " + cfg.getName());
                                }
                                projSet.addAll(Arrays.asList(projs));
                            }
                            catch (CoreException e) {
                                ManagedBuilderCorePlugin.log(e);
                                this.builtRefConfigIds.add(cfg.getId());
                                subMonitor.done();
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            this.builtRefConfigIds.add(cfg.getId());
                            subMonitor.done();
                            throw throwable;
                        }
                        this.builtRefConfigIds.add(cfg.getId());
                        subMonitor.done();
                    }
                    refConfigChanged.setValue(refConfigChanged.getValue() || nextConfigChanged.getValue());
                }
                ++n2;
            }
        } else {
            monitor.done();
        }
        return projSet;
    }

    private IConfiguration[] filterConfigsToBuild(IConfiguration[] cfgs) {
        ArrayList<IConfiguration> cfgList = new ArrayList<IConfiguration>(cfgs.length);
        IConfiguration[] iConfigurationArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration cfg = iConfigurationArray[n2];
            IProject project = cfg.getOwner().getProject();
            fBuildSet.getCfgIdSet(project, true).add(cfg.getId());
            if (!this.builtRefConfigIds.contains(cfg.getId())) {
                if (VERBOSE) {
                    CommonBuilder.outputTrace(cfg.getOwner().getProject().getName(), "set: adding cfg " + cfg.getName() + " ( id=" + cfg.getId() + ")");
                    CommonBuilder.outputTrace(cfg.getOwner().getProject().getName(), "filtering regs: adding cfg " + cfg.getName() + " ( id=" + cfg.getId() + ")");
                }
                cfgList.add(cfg);
            } else if (VERBOSE) {
                CommonBuilder.outputTrace(cfg.getOwner().getProject().getName(), "filtering regs: excluding cfg " + cfg.getName() + " ( id=" + cfg.getId() + ")");
            }
            ++n2;
        }
        return cfgList.toArray(new IConfiguration[cfgList.size()]);
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
    }

    private IConfiguration[] getReferencedConfigs(IBuilder[] builders) {
        HashSet<IConfiguration> set = new HashSet<IConfiguration>();
        IBuilder[] iBuilderArray = builders;
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration[] refs;
            IBuilder builder = iBuilderArray[n2];
            IConfiguration cfg = builder.getParent().getParent();
            IConfiguration[] iConfigurationArray = refs = ManagedBuildManager.getReferencedConfigurations(cfg);
            int n3 = refs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfiguration ref = iConfigurationArray[n4];
                set.add(ref);
                ++n4;
            }
            ++n2;
        }
        return set.toArray(new Configuration[set.size()]);
    }

    private Set<IProject> getProjectsSet(IConfiguration[] cfgs) {
        if (cfgs.length == 0) {
            return new HashSet<IProject>(0);
        }
        HashSet<IProject> set = new HashSet<IProject>();
        IConfiguration[] iConfigurationArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration cfg = iConfigurationArray[n2];
            set.add(cfg.getOwner().getProject());
            ++n2;
        }
        return set;
    }

    protected MultiStatus checkBuilders(IBuilder[] builders, IConfiguration activeCfg) {
        MultiStatus status = null;
        IBuilder[] iBuilderArray = builders;
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IBuilder builder = iBuilderArray[n2];
            boolean supportsCustomization = builder.supportsCustomizedBuild();
            boolean isManagedBuildOn = builder.isManagedBuildOn();
            if (isManagedBuildOn && !supportsCustomization) {
                if (builder.isCustomBuilder()) {
                    if (status == null) {
                        status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, "", null);
                    }
                    status.add((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ManagedMakeMessages.getResourceString("CommonBuilder.1"), null));
                } else if (builder.getParent().getParent() != activeCfg) {
                    if (status == null) {
                        status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, "", null);
                    }
                    status.add((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ManagedMakeMessages.getResourceString("CommonBuilder.2"), null));
                }
            }
            ++n2;
        }
        if (status == null) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, "", null);
        }
        return status;
    }

    private void updateOtherConfigs(IManagedBuildInfo info, IBuilder[] builders, int buildKind) {
        IConfiguration[] allCfgs = info.getManagedProject().getConfigurations();
        new OtherConfigVerifier(builders, allCfgs).updateOtherConfigs(buildKind == 6 ? null : this.getDelta(info.getManagedProject().getOwner().getProject()));
    }

    protected void build(int kind, CfgBuildInfo bInfo, IProgressMonitor monitor) throws CoreException {
        if (VERBOSE) {
            CommonBuilder.outputTrace(bInfo.getProject().getName(), "building cfg " + bInfo.getConfiguration().getName() + " with builder " + bInfo.getBuilder().getName());
        }
        IBuilder builder = bInfo.getBuilder();
        BuildStatus status = new BuildStatus(builder);
        if (!this.shouldBuild(kind, builder)) {
            return;
        }
        if (status.isBuild()) {
            IConfiguration cfg = bInfo.getConfiguration();
            if (!builder.isCustomBuilder()) {
                Set<String> set = fBuildSet.getCfgIdSet(bInfo.getProject(), true);
                if (VERBOSE) {
                    CommonBuilder.outputTrace(bInfo.getProject().getName(), "set: adding cfg " + cfg.getName() + " ( id=" + cfg.getId() + ")");
                }
                set.add(cfg.getId());
            }
            if (status.isManagedBuildOn()) {
                status = this.performPrebuildGeneration(kind, bInfo, status, monitor);
            }
            if (status.isBuild()) {
                try {
                    this.setCurrentProject(bInfo.getProject());
                    boolean isClean = builder.getBuildRunner().invokeBuild(kind, bInfo.getProject(), bInfo.getConfiguration(), builder, bInfo.getConsole(), (IMarkerGenerator)this, (IncrementalProjectBuilder)this, monitor);
                    if (isClean) {
                        this.forgetLastBuiltState();
                        cfg.setRebuildState(true);
                    } else {
                        if (status.isManagedBuildOn()) {
                            this.performPostbuildGeneration(kind, bInfo, status, monitor);
                        }
                        cfg.setRebuildState(false);
                    }
                }
                catch (CoreException e) {
                    cfg.setRebuildState(true);
                    throw e;
                }
                PropertyManager.getInstance().serialize(cfg);
            } else if (status.getConsoleMessagesList().size() != 0) {
                this.emitMessage(bInfo, this.concatMessages(status.getConsoleMessagesList()));
            }
        }
        this.checkCancel(monitor);
    }

    private String concatMessages(List<String> msgs) {
        int size = msgs.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return msgs.get(0);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(msgs.get(0));
        int i = 1;
        while (i < size) {
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(msgs.get(i));
            ++i;
        }
        return buf.toString();
    }

    private String createNoSourceMessage(int buildType, IStatus status, CfgBuildInfo bInfo) throws CoreException {
        StringBuilder buf = new StringBuilder();
        String[] consoleHeader = new String[3];
        String configName = bInfo.getConfiguration().getName();
        String projName = bInfo.getProject().getName();
        if (buildType == 6 || buildType == 10) {
            consoleHeader[0] = ManagedMakeMessages.getResourceString("ManagedMakeBuider.type.incremental");
        } else {
            consoleHeader[0] = "";
            CommonBuilder.outputError(projName, "The given build type is not supported in this context");
        }
        consoleHeader[1] = configName;
        consoleHeader[2] = projName;
        buf.append(System.getProperty("line.separator", "\n"));
        buf.append(ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.console.header", consoleHeader));
        buf.append(System.getProperty("line.separator", "\n"));
        buf.append(System.getProperty("line.separator", "\n"));
        buf.append(status.getMessage());
        buf.append(System.getProperty("line.separator", "\n"));
        return buf.toString();
    }

    private void emitMessage(CfgBuildInfo info, String msg) throws CoreException {
        try {
            IConsole console = info.getConsole();
            ConsoleOutputStream consoleOutStream = console.getOutputStream();
            consoleOutStream.write(msg.getBytes());
            consoleOutStream.flush();
            consoleOutStream.close();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (IOException io) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), io.getLocalizedMessage(), (Throwable)io));
        }
    }

    protected BuildStatus performPostbuildGeneration(int kind, CfgBuildInfo bInfo, BuildStatus buildStatus, IProgressMonitor monitor) throws CoreException {
        IBuilder builder = bInfo.getBuilder();
        if (builder.isInternalBuilder()) {
            return buildStatus;
        }
        if (buildStatus.isRebuild()) {
            buildStatus.getMakeGen().regenerateDependencies(false);
        } else {
            buildStatus.getMakeGen().generateDependencies();
        }
        return buildStatus;
    }

    protected BuildStatus performPrebuildGeneration(int kind, CfgBuildInfo bInfo, BuildStatus buildStatus, IProgressMonitor monitor) throws CoreException {
        IBuilder builder = bInfo.getBuilder();
        if (builder.isInternalBuilder()) {
            return buildStatus;
        }
        buildStatus = this.performCleanning(kind, bInfo, buildStatus, monitor);
        IManagedBuilderMakefileGenerator generator = builder.getBuildFileGenerator();
        if (generator != null) {
            this.initializeGenerator(generator, kind, bInfo, monitor);
            buildStatus.setMakeGen(generator);
            MultiStatus result = this.performMakefileGeneration(bInfo, generator, buildStatus, monitor);
            if (result.getCode() == 2 || result.getCode() == 1) {
                IStatus[] kids = result.getChildren();
                int index = 0;
                while (index < kids.length) {
                    IStatus status = kids[index];
                    if (status.getCode() == 1) {
                        buildStatus.getConsoleMessagesList().add(this.createNoSourceMessage(kind, status, bInfo));
                        buildStatus.cancelBuild();
                    }
                    ++index;
                }
            } else if (result.getCode() == 4) {
                StringBuilder buf = new StringBuilder();
                buf.append(ManagedMakeMessages.getString("CommonBuilder.23")).append(NEWLINE);
                String message = result.getMessage();
                if (message != null && message.length() != 0) {
                    buf.append(message).append(NEWLINE);
                }
                buf.append(ManagedMakeMessages.getString("CommonBuilder.24")).append(NEWLINE);
                message = buf.toString();
                buildStatus.getConsoleMessagesList().add(message);
                buildStatus.cancelBuild();
            }
            this.checkCancel(monitor);
        } else {
            buildStatus.cancelBuild();
        }
        return buildStatus;
    }

    protected BuildStatus performCleanning(int kind, CfgBuildInfo bInfo, BuildStatus status, IProgressMonitor monitor) throws CoreException {
        boolean makefileRegenerationNeeded;
        block9: {
            IConfiguration cfg = bInfo.getConfiguration();
            IProject curProject = bInfo.getProject();
            makefileRegenerationNeeded = false;
            if (cfg.needsFullRebuild()) {
                CommonBuilder.outputTrace(curProject.getName(), "config rebuild state is set to true, making a full rebuild");
                this.clean(bInfo, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                makefileRegenerationNeeded = true;
            } else {
                IResourceDelta delta;
                makefileRegenerationNeeded = cfg.needsRebuild();
                IBuildDescription des = null;
                IResourceDelta iResourceDelta = delta = kind == 6 ? null : this.getDelta(curProject);
                if (delta == null) {
                    makefileRegenerationNeeded = true;
                }
                if (cfg.needsRebuild() || delta != null) {
                    try {
                        int flags = 14;
                        if (delta != null) {
                            flags |= 1;
                        }
                        CommonBuilder.outputTrace(curProject.getName(), "using a build description..");
                        des = BuildDescriptionManager.createBuildDescription(cfg, this.getDelta(curProject), flags);
                        BuildDescriptionManager.cleanGeneratedRebuildResources(des);
                    }
                    catch (Throwable e) {
                        CommonBuilder.outputError(curProject.getName(), "error occured while build description calculation: " + e.getLocalizedMessage());
                        if (cfg.needsRebuild()) {
                            this.clean((IProgressMonitor)new SubProgressMonitor(monitor, -1));
                            makefileRegenerationNeeded = true;
                        }
                        if (delta == null || makefileRegenerationNeeded) break block9;
                        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(cfg, bInfo.getBuildInfo().getManagedProject().getConfigurations());
                        delta.accept((IResourceDeltaVisitor)visitor);
                        if (!visitor.shouldBuildFull()) break block9;
                        this.clean((IProgressMonitor)new SubProgressMonitor(monitor, -1));
                        makefileRegenerationNeeded = true;
                    }
                }
            }
        }
        if (makefileRegenerationNeeded) {
            status.setRebuild();
        }
        return status;
    }

    protected MultiStatus performMakefileGeneration(CfgBuildInfo bInfo, IManagedBuilderMakefileGenerator generator, BuildStatus buildStatus, IProgressMonitor monitor) throws CoreException {
        IProject curProject = bInfo.getProject();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.checkCancel(monitor);
        String statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.update.makefiles", curProject.getName());
        monitor.subTask(statusMsg);
        MultiStatus result = buildStatus.isRebuild() ? generator.regenerateMakefiles() : generator.generateMakefiles(this.getDelta(curProject));
        return result;
    }

    protected void initializeGenerator(IManagedBuilderMakefileGenerator generator, int kind, CfgBuildInfo bInfo, IProgressMonitor monitor) {
        if (generator instanceof IManagedBuilderMakefileGenerator2) {
            IManagedBuilderMakefileGenerator2 gen2 = (IManagedBuilderMakefileGenerator2)generator;
            gen2.initialize(kind, bInfo.getConfiguration(), bInfo.getBuilder(), monitor);
        } else {
            generator.initialize(bInfo.getProject(), bInfo.getBuildInfo(), monitor);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IBuilder[] builders;
        IProject curProject = this.getProject();
        if (!this.isCdtProjectCreated(curProject)) {
            return;
        }
        IBuilder[] iBuilderArray = builders = ManagedBuilderCorePlugin.createBuilders(curProject, null);
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IBuilder builder = iBuilderArray[n2];
            CfgBuildInfo bInfo = new CfgBuildInfo(builder, true);
            this.clean(bInfo, monitor);
            ++n2;
        }
    }

    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        super.addMarker(file, lineNumber, errorDesc, severity, errorVar);
        if (severity == 4) {
            this.fBuildErrOccured = true;
        }
    }

    public void addMarker(ProblemMarkerInfo problemMarkerInfo) {
        super.addMarker(problemMarkerInfo);
        if (problemMarkerInfo.severity == 4) {
            this.fBuildErrOccured = true;
        }
    }

    protected void clean(CfgBuildInfo bInfo, IProgressMonitor monitor) throws CoreException {
        if (this.shouldBuild(15, bInfo.getBuilder())) {
            BuildStateManager bsMngr = BuildStateManager.getInstance();
            IProject project = bInfo.getProject();
            IConfiguration cfg = bInfo.getConfiguration();
            IProjectBuildState pbs = bsMngr.getProjectBuildState(project);
            IConfigurationBuildState cbs = pbs.getConfigurationBuildState(cfg.getId(), false);
            if (cbs != null) {
                pbs.removeConfigurationBuildState(cfg.getId());
                bsMngr.setProjectBuildState(project, pbs);
            }
            if (!cfg.getEditableBuilder().isManagedBuildOn()) {
                this.performExternalClean(bInfo, false, monitor);
            } else {
                IResource rc;
                boolean programmatically = true;
                IPath path = ManagedBuildManager.getBuildFullPath(cfg, bInfo.getBuilder());
                IResource iResource = rc = path != null ? ResourcesPlugin.getWorkspace().getRoot().findMember(path) : null;
                if (path == null || rc != null && rc.getType() != 1) {
                    if (!cfg.getEditableBuilder().isInternalBuilder()) {
                        this.fBuildErrOccured = false;
                        try {
                            this.performExternalClean(bInfo, false, monitor);
                        }
                        catch (CoreException e) {
                            this.fBuildErrOccured = true;
                        }
                        if (!this.fBuildErrOccured) {
                            programmatically = false;
                        }
                    }
                    if (programmatically) {
                        try {
                            this.cleanWithInternalBuilder(bInfo, monitor);
                        }
                        catch (CoreException e) {
                            this.cleanProgrammatically(bInfo, monitor);
                        }
                    }
                }
            }
        }
    }

    protected void performExternalClean(final CfgBuildInfo bInfo, boolean separateJob, IProgressMonitor monitor) throws CoreException {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        final ISchedulingRule rule = ruleFactory.modifyRule((IResource)bInfo.getProject());
        if (separateJob) {
            Job backgroundJob = new Job("CDT Common Builder"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                CommonBuilder.this.setCurrentProject(bInfo.getProject());
                                bInfo.fBuilder.getBuildRunner().invokeBuild(15, bInfo.getProject(), bInfo.getConfiguration(), bInfo.getBuilder(), bInfo.getConsole(), (IMarkerGenerator)CommonBuilder.this, (IncrementalProjectBuilder)CommonBuilder.this, monitor);
                            }
                        }, rule, 1, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    IStatus returnStatus = Status.OK_STATUS;
                    return returnStatus;
                }
            };
            backgroundJob.setRule(rule);
            backgroundJob.schedule();
        } else {
            this.setCurrentProject(bInfo.getProject());
            bInfo.fBuilder.getBuildRunner().invokeBuild(15, bInfo.getProject(), bInfo.getConfiguration(), bInfo.getBuilder(), bInfo.getConsole(), (IMarkerGenerator)this, (IncrementalProjectBuilder)this, monitor);
        }
    }

    protected boolean shouldCleanProgrammatically(CfgBuildInfo bInfo) {
        return bInfo.getBuilder().isManagedBuildOn();
    }

    protected void cleanWithInternalBuilder(CfgBuildInfo bInfo, IProgressMonitor monitor) throws CoreException {
        IProject project = bInfo.getProject();
        CommonBuilder.outputTrace(project.getName(), "Clean build with Internal Builder requested");
        IConfiguration configuration = bInfo.getConfiguration();
        int flags = 8;
        BuildDescription des = (BuildDescription)BuildDescriptionManager.createBuildDescription(configuration, null, null, flags);
        IBuildStep cleanStep = des.getCleanStep();
        StepBuilder sBuilder = new StepBuilder(cleanStep, null, null);
        BuildRunnerHelper buildRunnerHelper = new BuildRunnerHelper(project);
        try {
            try {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("", 300);
                IConsole console = bInfo.getConsole();
                IBuilder builder = bInfo.getBuilder();
                String[] errorParsers = builder.getErrorParsers();
                URI workingDirectoryURI = ManagedBuildManager.getBuildLocationURI(configuration, builder);
                ErrorParserManager epm = new ErrorParserManager(project, workingDirectoryURI, (IMarkerGenerator)this, errorParsers);
                buildRunnerHelper.prepareStreams(epm, null, console, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                OutputStream stdout = buildRunnerHelper.getOutputStream();
                OutputStream stderr = buildRunnerHelper.getErrorStream();
                String cfgName = configuration.getName();
                String toolchainName = configuration.getToolChain().getName();
                boolean isConfigurationSupported = configuration.isSupported();
                buildRunnerHelper.greeting(15, cfgName, toolchainName, isConfigurationSupported);
                int status = sBuilder.build(stdout, stderr, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                buildRunnerHelper.close();
                buildRunnerHelper.goodbye();
                if (status != -1) {
                    buildRunnerHelper.refreshProject(cfgName, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
                if (status == -2) {
                    Status st = new Status(1, "org.eclipse.cdt.managedbuilder.core", "Failed to execute delete command");
                    throw new CoreException((IStatus)st);
                }
            }
            catch (Exception e) {
                String msg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.error.build", new String[]{project.getName(), configuration.getName()});
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", msg, (Throwable)e));
            }
        }
        finally {
            try {
                buildRunnerHelper.close();
            }
            catch (IOException e) {
                ManagedBuilderCorePlugin.log(e);
            }
            monitor.done();
        }
    }

    protected void cleanProgrammatically(CfgBuildInfo bInfo, IProgressMonitor monitor) throws CoreException {
        IProject project = bInfo.getProject();
        CommonBuilder.outputTrace(project.getName(), "Clean build requested");
        IBuilder builder = bInfo.getBuilder();
        IConfiguration configuration = bInfo.getConfiguration();
        IPath buildPath = ManagedBuildManager.getBuildFullPath(configuration, builder);
        if (buildPath == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), ManagedMakeMessages.getResourceString("CommonBuilder.0")));
        }
        IPath projectFullPath = project.getFullPath();
        if (!projectFullPath.isPrefixOf(buildPath)) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), ManagedMakeMessages.getResourceString("CommonBuilder.16")));
        }
        IWorkspace workspace = CCorePlugin.getWorkspace();
        IResource rc = workspace.getRoot().findMember(buildPath);
        if (rc != null) {
            if (rc.getType() != 2) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), ManagedMakeMessages.getResourceString("CommonBuilder.12")));
            }
            IFolder buildDir = (IFolder)rc;
            if (!buildDir.isAccessible()) {
                CommonBuilder.outputError(buildDir.getName(), "Could not delete the build directory");
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), ManagedMakeMessages.getResourceString("CommonBuilder.13")));
            }
            BuildRunnerHelper buildRunnerHelper = new BuildRunnerHelper(project);
            try {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("", 200);
                    String status = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.clean.deleting.output", buildDir.getName());
                    monitor.subTask(status);
                    IConsole console = bInfo.getConsole();
                    String[] errorParsers = builder.getErrorParsers();
                    URI workingDirectoryURI = ManagedBuildManager.getBuildLocationURI(configuration, builder);
                    ErrorParserManager epm = new ErrorParserManager(project, workingDirectoryURI, (IMarkerGenerator)this, errorParsers);
                    buildRunnerHelper.prepareStreams(epm, null, console, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    String cfgName = configuration.getName();
                    String toolchainName = configuration.getToolChain().getName();
                    boolean isConfigurationSupported = configuration.isSupported();
                    buildRunnerHelper.greeting(15, cfgName, toolchainName, isConfigurationSupported);
                    workspace.delete(new IResource[]{buildDir}, true, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    buildRunnerHelper.close();
                    buildRunnerHelper.goodbye();
                }
                catch (Exception e) {
                    String msg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.error.build", new String[]{project.getName(), configuration.getName()});
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", msg, (Throwable)e));
                }
            }
            finally {
                try {
                    buildRunnerHelper.close();
                }
                catch (IOException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
                monitor.done();
            }
        }
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected boolean shouldBuild(int kind, IMakeBuilderInfo info) {
        switch (kind) {
            case 9: {
                return info.isAutoBuildEnable();
            }
            case 6: 
            case 10: {
                return info.isFullBuildEnabled() | info.isIncrementalBuildEnabled();
            }
            case 15: {
                return info.isCleanBuildEnabled();
            }
        }
        return true;
    }

    public ISchedulingRule getRule(int trigger, Map args) {
        IWorkspaceRoot WR_rule = ResourcesPlugin.getWorkspace().getRoot();
        if (CommonBuilder.needAllConfigBuild() || !this.isCdtProjectCreated(this.getProject())) {
            return WR_rule;
        }
        IBuilder[] builders = ManagedBuilderCorePlugin.createBuilders(this.getProject(), args);
        if (this.getReferencedConfigs(builders).length > 0) {
            return WR_rule;
        }
        IBuilder[] iBuilderArray = builders;
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IBuilder builder = iBuilderArray[n2];
            if (builder.isManagedBuildOn()) {
                return WR_rule;
            }
            ++n2;
        }
        return null;
    }

    protected class BuildStatus {
        private final boolean fManagedBuildOn;
        private boolean fRebuild;
        private boolean fBuild = true;
        private final List<String> fConsoleMessages = new ArrayList<String>();
        private IManagedBuilderMakefileGenerator fMakeGen;

        public BuildStatus(IBuilder builder) {
            this.fManagedBuildOn = builder.isManagedBuildOn();
        }

        public void setRebuild() {
            this.fRebuild = true;
        }

        public boolean isRebuild() {
            return this.fRebuild;
        }

        public boolean isManagedBuildOn() {
            return this.fManagedBuildOn;
        }

        public boolean isBuild() {
            return this.fBuild;
        }

        public void cancelBuild() {
            this.fBuild = false;
        }

        public List<String> getConsoleMessagesList() {
            return this.fConsoleMessages;
        }

        public IManagedBuilderMakefileGenerator getMakeGen() {
            return this.fMakeGen;
        }

        public void setMakeGen(IManagedBuilderMakefileGenerator makeGen) {
            this.fMakeGen = makeGen;
        }
    }

    private static class CfgBuildInfo {
        private final IProject fProject;
        private final IManagedBuildInfo fBuildInfo;
        private final IConfiguration fCfg;
        private final IBuilder fBuilder;
        private IConsole fConsole;

        CfgBuildInfo(IBuilder builder, boolean isForegound) {
            this.fBuilder = builder;
            this.fCfg = builder.getParent().getParent();
            this.fProject = this.fCfg.getOwner().getProject();
            this.fBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.fProject);
        }

        public IProject getProject() {
            return this.fProject;
        }

        public IConsole getConsole() {
            if (this.fConsole == null) {
                this.fConsole = CCorePlugin.getDefault().getConsole();
                this.fConsole.start(this.fProject);
            }
            return this.fConsole;
        }

        public IBuilder getBuilder() {
            return this.fBuilder;
        }

        public IConfiguration getConfiguration() {
            return this.fCfg;
        }

        public IManagedBuildInfo getBuildInfo() {
            return this.fBuildInfo;
        }
    }

    private static class CfgBuildSet {
        Map<IProject, Set<String>> fMap = new HashMap<IProject, Set<String>>();

        private CfgBuildSet() {
        }

        public Set<String> getCfgIdSet(IProject project, boolean create) {
            Set<String> set = this.fMap.get(project);
            if (set == null && create) {
                set = new HashSet<String>();
                this.fMap.put(project, set);
            }
            return set;
        }

        public void start(CommonBuilder bld) {
            this.checkClean(bld);
        }

        private boolean checkClean(CommonBuilder bld) {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject wproject = iProjectArray[n2];
                if (bld.hasBeenBuilt(wproject)) {
                    if (VERBOSE) {
                        CommonBuilder.outputTrace(null, "checking clean: the project " + wproject.getName() + " was built, no clean needed");
                    }
                    return false;
                }
                ++n2;
            }
            if (VERBOSE) {
                CommonBuilder.outputTrace(null, "checking clean: no projects were built.. cleanning");
            }
            this.fMap.clear();
            return true;
        }
    }

    private class MyBoolean {
        private boolean value;

        public MyBoolean(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }
    }

    private static class OtherConfigVerifier
    implements IResourceDeltaVisitor {
        IPath[] buildFullPaths;
        Configuration[] otherConfigs;
        int resourceChangeState;
        private static final IPath[] ignoreList = new IPath[]{new Path(".cdtproject"), new Path(".cproject"), new Path(".cdtbuild"), new Path(".settings")};

        OtherConfigVerifier(IBuilder[] builders, IConfiguration[] allCfgs) {
            HashSet<IConfiguration> buildCfgSet = new HashSet<IConfiguration>();
            IBuilder[] iBuilderArray = builders;
            int n = builders.length;
            int n2 = 0;
            while (n2 < n) {
                IBuilder builder = iBuilderArray[n2];
                buildCfgSet.add(builder.getParent().getParent());
                ++n2;
            }
            List othersList = ListComparator.getAdded((Object[])allCfgs, (Object[])buildCfgSet.toArray());
            this.otherConfigs = othersList != null ? othersList.toArray(new Configuration[othersList.size()]) : new Configuration[0];
            ArrayList<IPath> list = new ArrayList<IPath>(builders.length);
            IBuilder[] iBuilderArray2 = builders;
            int n3 = builders.length;
            int n4 = 0;
            while (n4 < n3) {
                IBuilder builder = iBuilderArray2[n4];
                IPath path = ManagedBuildManager.getBuildFullPath(builder.getParent().getParent(), builder);
                if (path != null) {
                    list.add(path);
                }
                ++n4;
            }
            this.buildFullPaths = list.toArray(new IPath[list.size()]);
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource rc = delta.getResource();
            if (rc.getType() == 1) {
                if (this.isResourceValuable(rc)) {
                    this.resourceChangeState |= delta.getKind();
                }
                return false;
            }
            if (!this.isResourceValuable(rc)) {
                return false;
            }
            IPath[] iPathArray = this.buildFullPaths;
            int n = this.buildFullPaths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath buildFullPath = iPathArray[n2];
                if (buildFullPath.isPrefixOf(rc.getFullPath())) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public void updateOtherConfigs(IResourceDelta delta) {
            if (delta == null) {
                this.resourceChangeState = -1;
            } else {
                try {
                    delta.accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    this.resourceChangeState = -1;
                }
            }
            this.setResourceChangeStateForOtherConfigs();
        }

        private void setResourceChangeStateForOtherConfigs() {
            Configuration[] configurationArray = this.otherConfigs;
            int n = this.otherConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                Configuration otherConfig = configurationArray[n2];
                otherConfig.addResourceChangeState(this.resourceChangeState);
                ++n2;
            }
        }

        private boolean isResourceValuable(IResource rc) {
            IPath path = rc.getProjectRelativePath();
            IPath[] iPathArray = ignoreList;
            int n = ignoreList.length;
            int n2 = 0;
            while (n2 < n) {
                IPath ignoredPath = iPathArray[n2];
                if (ignoredPath.equals((Object)path)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private String buildGoalName;
        private final IProject project;
        private final IPath[] buildPaths;
        private boolean incrBuildNeeded = false;
        private boolean fullBuildNeeded = false;
        private final List<String> reservedNames;

        public ResourceDeltaVisitor(IConfiguration cfg, IConfiguration[] allConfigs) {
            this.project = cfg.getOwner().getProject();
            this.buildPaths = new IPath[allConfigs.length];
            int i = 0;
            while (i < this.buildPaths.length) {
                this.buildPaths[i] = ManagedBuildManager.getBuildFullPath(allConfigs[i], allConfigs[i].getBuilder());
                ++i;
            }
            String ext = cfg.getArtifactExtension();
            try {
                ext = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(ext, "", " ", 3, cfg);
            }
            catch (BuildMacroException buildMacroException) {
                // empty catch block
            }
            String name = cfg.getArtifactName();
            try {
                String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(name, "", " ", 3, cfg);
                resolved = resolved.trim();
                if (resolved.length() > 0) {
                    name = resolved;
                }
            }
            catch (BuildMacroException buildMacroException) {
                // empty catch block
            }
            this.buildGoalName = ext.length() > 0 ? String.valueOf(cfg.getOutputPrefix(ext)) + name + "." + ext : name;
            this.reservedNames = Arrays.asList(".cdtbuild", ".cdtproject", ".project");
        }

        private boolean isGeneratedResource(IResource resource) {
            IPath path = resource.getFullPath();
            IPath[] iPathArray = this.buildPaths;
            int n = this.buildPaths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath buildPath = iPathArray[n2];
                if (buildPath != null && buildPath.isPrefixOf(path)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean isProjectFile(IResource resource) {
            return this.reservedNames.contains(resource.getName());
        }

        public boolean shouldBuildIncr() {
            return this.incrBuildNeeded;
        }

        public boolean shouldBuildFull() {
            return this.fullBuildNeeded;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource != null && resource.getProject() == this.project) {
                switch (resource.getType()) {
                    case 1: {
                        String name = resource.getName();
                        if (name.equals(this.buildGoalName) || !resource.isDerived() && !this.isProjectFile(resource) && !this.isGeneratedResource(resource)) {
                            this.incrBuildNeeded = true;
                            if (delta.getKind() == 2) {
                                this.fullBuildNeeded = true;
                                break;
                            }
                        }
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

