/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;

public class CatalinaPropertiesUtil {
    private CatalinaPropertiesUtil() {
    }

    public static void addGlobalClasspath(File file, String loader, String[] elements) throws IOException {
        String propertyName = String.valueOf(loader) + ".loader";
        BufferedReader br = null;
        StringBuffer buffer = new StringBuffer();
        boolean added = false;
        try {
            br = new BufferedReader(new FileReader(file));
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith(propertyName)) {
                    added = true;
                    line = CatalinaPropertiesUtil.addElements(line, elements);
                }
                buffer.append(line);
                buffer.append("\n");
                line = br.readLine();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        if (!added) {
            buffer.append(propertyName);
            buffer.append("=");
            int i = 0;
            while (i < elements.length) {
                buffer.append(elements[i]);
                ++i;
            }
            buffer.append("\n");
        }
        String propertyFile = buffer.toString();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file));
            bw.write(propertyFile);
        }
        finally {
            if (br != null) {
                bw.close();
            }
        }
    }

    private static String addElements(String line, String[] elements) {
        String[] propAndValue = line.split("=");
        String loaderProperty = "";
        if (propAndValue.length > 1) {
            loaderProperty = propAndValue[1];
        }
        LinkedHashSet<String> classpath = new LinkedHashSet<String>();
        StringTokenizer st = new StringTokenizer(loaderProperty, ",");
        while (st.hasMoreTokens()) {
            classpath.add(st.nextToken());
        }
        int i = 0;
        while (i < elements.length) {
            classpath.add(elements[i]);
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(propAndValue[0]);
        sb.append("=");
        Iterator it = classpath.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }
}

