/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.merged;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.architecture.commands.IModelConversionCommand;
import org.eclipse.papyrus.infra.architecture.commands.IModelCreationCommand;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;

public abstract class MergedArchitectureContext
extends MergedADElement {
    public MergedArchitectureContext(MergedArchitectureDomain domain) {
        super(domain);
    }

    public String getExtensionPrefix() {
        for (ADElement element : this.elements) {
            ArchitectureContext context = (ArchitectureContext)element;
            if (context.getExtensionPrefix() == null) continue;
            return context.getExtensionPrefix();
        }
        return null;
    }

    public Class<? extends IModelCreationCommand> getCreationCommandClass() throws ClassNotFoundException {
        for (ADElement element : this.elements) {
            ArchitectureContext context = (ArchitectureContext)element;
            if (context.getCreationCommandClass() == null) continue;
            return ClassLoaderHelper.loadClass((String)context.getCreationCommandClass(), IModelCreationCommand.class, (URI)EcoreUtil.getURI((EObject)context));
        }
        return null;
    }

    public Class<? extends IModelConversionCommand> getConversionCommandClass() throws ClassNotFoundException {
        for (ADElement element : this.elements) {
            ArchitectureContext context = (ArchitectureContext)element;
            if (context.getConversionCommandClass() == null) continue;
            return ClassLoaderHelper.loadClass((String)context.getConversionCommandClass(), IModelConversionCommand.class, (URI)EcoreUtil.getURI((EObject)context));
        }
        return null;
    }

    public String getCreationCommandClassName() {
        for (ADElement element : this.elements) {
            ArchitectureContext context = (ArchitectureContext)element;
            if (context.getCreationCommandClass() == null) continue;
            return context.getCreationCommandClass();
        }
        return null;
    }

    public String getConversionCommandClassName() {
        for (ADElement element : this.elements) {
            ArchitectureContext context = (ArchitectureContext)element;
            if (context.getConversionCommandClass() == null) continue;
            return context.getConversionCommandClass();
        }
        return null;
    }

    public MergedArchitectureDomain getDomain() {
        return (MergedArchitectureDomain)this.getParent();
    }

    public Collection<ElementTypeSetConfiguration> getElementTypes() {
        LinkedHashSet configurations = new LinkedHashSet();
        for (ADElement element : this.elements) {
            ArchitectureContext context = (ArchitectureContext)element;
            configurations.addAll(context.getElementTypes());
        }
        return Collections.unmodifiableCollection(configurations);
    }

    public Collection<MergedArchitectureViewpoint> getViewpoints() {
        HashMap<String, MergedArchitectureViewpoint> viewpoints = new HashMap<String, MergedArchitectureViewpoint>();
        for (ADElement element : this.elements) {
            ArchitectureContext context = (ArchitectureContext)element;
            for (ArchitectureViewpoint viewpoint : context.getViewpoints()) {
                MergedArchitectureViewpoint merged = (MergedArchitectureViewpoint)viewpoints.get(viewpoint.getName());
                if (merged == null) {
                    merged = new MergedArchitectureViewpoint(this);
                    viewpoints.put(viewpoint.getName(), merged);
                }
                merged.merge((ADElement)viewpoint);
            }
        }
        return Collections.unmodifiableCollection(viewpoints.values());
    }

    public Collection<MergedArchitectureViewpoint> getDefaultViewpoints() {
        HashMap<String, MergedArchitectureViewpoint> viewpoints = new HashMap<String, MergedArchitectureViewpoint>();
        for (ADElement element : this.elements) {
            ArchitectureContext context = (ArchitectureContext)element;
            for (ArchitectureViewpoint viewpoint : context.getDefaultViewpoints()) {
                MergedArchitectureViewpoint merged = (MergedArchitectureViewpoint)viewpoints.get(viewpoint.getName());
                if (merged == null) {
                    merged = new MergedArchitectureViewpoint(this);
                    viewpoints.put(viewpoint.getName(), merged);
                }
                merged.merge((ADElement)viewpoint);
            }
        }
        return Collections.unmodifiableCollection(viewpoints.values());
    }
}

