/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.UMLPackage;

public class InteractionOperandDragDropEditPolicy
extends DragDropEditPolicy {
    public Command getCommand(Request request) {
        return super.getCommand(request);
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        List editParts = request.getEditParts();
        if (editParts.size() == 1 && editParts.get(0) instanceof InteractionOperandEditPart) {
            InteractionOperandEditPart partToMove = (InteractionOperandEditPart)((Object)editParts.get(0));
            InteractionOperand operandToReorder = this.getOperand(partToMove);
            EditPart fragmentCptPart = this.getHost().getParent();
            CombinedFragment fragment = this.getCombinedFragment();
            if (fragment == null || !(fragmentCptPart instanceof IGraphicalEditPart)) {
                return UnexecutableCommand.INSTANCE;
            }
            IGraphicalEditPart fragmentGEP = (IGraphicalEditPart)fragmentCptPart;
            CompositeCommand command = new CompositeCommand("Reorder operands");
            ArrayList<InteractionOperand> operands = new ArrayList<InteractionOperand>((Collection<InteractionOperand>)fragment.getOperands());
            if (!operands.contains(operandToReorder)) {
                return UnexecutableCommand.INSTANCE;
            }
            int newIndex = operands.indexOf(this.getHostOperand());
            operands.remove(operandToReorder);
            operands.add(newIndex, operandToReorder);
            SetRequest semanticReorder = new SetRequest((EObject)fragment, (EStructuralFeature)UMLPackage.Literals.COMBINED_FRAGMENT__OPERAND, operands);
            command.add((IUndoableOperation)new SetValueCommand(semanticReorder));
            ArrayList<View> operandViews = new ArrayList<View>((Collection<View>)fragmentGEP.getNotationView().getChildren());
            View operandViewToReorder = partToMove.getNotationView();
            operandViews.remove(operandViewToReorder);
            operandViews.add(newIndex, operandViewToReorder);
            SetRequest graphicalReorder = new SetRequest((EObject)fragmentGEP.getNotationView(), (EStructuralFeature)NotationPackage.Literals.VIEW__PERSISTED_CHILDREN, operandViews);
            command.add((IUndoableOperation)new SetValueCommand(graphicalReorder));
            int y = 0;
            CompositeCommand updateBounds = new CompositeCommand("Update operands bounds");
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            for (View view : operandViews) {
                Node node;
                LayoutConstraint layoutConstraint;
                if (!(view instanceof Node) || !((layoutConstraint = (node = (Node)view).getLayoutConstraint()) instanceof Bounds)) continue;
                Bounds currentBounds = (Bounds)layoutConstraint;
                Point newPos = new Point(0, y);
                updateBounds.add((IUndoableOperation)new SetLocationCommand(editingDomain, "Update bounds", (IAdaptable)new EObjectAdapter((EObject)node), newPos));
                y += currentBounds.getHeight();
            }
            command.add((IUndoableOperation)updateBounds);
            return new ICommandProxy((ICommand)command);
        }
        return null;
    }

    private InteractionOperand getOperand(InteractionOperandEditPart editPart) {
        EObject element = editPart.getNotationView().getElement();
        return element instanceof InteractionOperand ? (InteractionOperand)element : null;
    }

    private CombinedFragment getCombinedFragment() {
        InteractionOperand operand = this.getHostOperand();
        Element parent = operand == null ? null : operand.getOwner();
        return parent instanceof CombinedFragment ? (CombinedFragment)parent : null;
    }

    private InteractionOperand getHostOperand() {
        EObject hostSemantic = this.getHostObject();
        return hostSemantic instanceof InteractionOperand ? (InteractionOperand)hostSemantic : null;
    }
}

