/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.util.regex.Pattern;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;

class PreLexerLine {
    static final int COMMENT = 0;
    static final int CONTINUATION = 1;
    static final int STMT = 2;
    static final int CPPDIRECTIVE = 3;
    final int linePos;
    final int offset;
    final int type;
    private final String lineText;
    private static final Pattern DO_STMT_PATTERN = Pattern.compile("^[ \\t0-9]*do[ \\t]*[0-9]+.*", 2);
    private static final Pattern TYPE_DECL_STMT_PATTERN = Pattern.compile("^[ \\t0-9]*(integer|real|double|complex|logical|character).*", 2);
    private static final Pattern LABELED_ASGT_TO_H = Pattern.compile("^[ \\t0-9]+h.*=.*", 2);
    private Boolean hollerithsOK = null;

    PreLexerLine(String _lineText, int linePos, int offset) {
        this.linePos = linePos;
        this.offset = offset;
        this.lineText = _lineText;
        String trimmedText = this.lineText.trim();
        this.type = trimmedText.length() == 0 ? 0 : (this.lineText.charAt(0) == 'C' || this.lineText.charAt(0) == 'c' || this.lineText.charAt(0) == '*' || this.lineText.charAt(0) == '$' ? 0 : (trimmedText.startsWith("!") ? 0 : (trimmedText.startsWith("#") ? 3 : (this.lineText.length() > FortranPreferences.FIXED_FORM_COMMENT_COLUMN.getValue() && this.lineText.substring(0, FortranPreferences.FIXED_FORM_COMMENT_COLUMN.getValue()).trim().length() == 0 ? 0 : (this.lineText.indexOf(9) >= 0 && this.lineText.indexOf(9) <= 5 ? 2 : (this.lineText.length() >= 6 && this.lineText.charAt(5) != '0' && this.lineText.charAt(5) != ' ' ? 1 : 2))))));
    }

    public boolean hollerithsOK() {
        if (this.hollerithsOK == null) {
            this.hollerithsOK = !DO_STMT_PATTERN.matcher(this.lineText).matches() && !TYPE_DECL_STMT_PATTERN.matcher(this.lineText).matches() && !LABELED_ASGT_TO_H.matcher(this.lineText).matches();
        }
        return this.hollerithsOK;
    }

    public int length() {
        return this.lineText.length();
    }

    public char charAt(int pos) {
        return this.lineText.charAt(pos);
    }

    public String getText() {
        return this.lineText;
    }

    public String toString() {
        return "Line " + this.linePos + ": " + this.lineText;
    }
}

