/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.debug.core.messages.Messages;

public class DebugJobStorage {
    private static Map<String, DebugJobStorage> storages = new HashMap<String, DebugJobStorage>();
    private final String name;
    private final Map<String, Storage> jobMap = new HashMap<String, Storage>();

    public DebugJobStorage(String name) {
        if (DebugJobStorage.containsKey(name)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.DebugJobStorage_0, (Object)name));
        }
        this.name = name;
        DebugJobStorage.addDebugStorage(this.name, this);
    }

    public void closeDebugJobStorage() {
        Storage[] storages;
        Storage[] storageArray = storages = this.jobMap.values().toArray(new Storage[0]);
        int n = storages.length;
        int n2 = 0;
        while (n2 < n) {
            Storage st = storageArray[n2];
            st.clean();
            ++n2;
        }
        this.jobMap.clear();
        DebugJobStorage.removeDebugStorage(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage getJobStorage(String job_id) {
        Map<String, Storage> map = this.jobMap;
        synchronized (map) {
            if (!this.jobMap.containsKey(job_id)) {
                this.jobMap.put(job_id, new Storage());
            }
            return this.jobMap.get(job_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobStorage(String job_id) {
        Map<String, Storage> map = this.jobMap;
        synchronized (map) {
            Storage storage = this.jobMap.remove(job_id);
            if (storage != null) {
                storage.clean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> getJobValueCollection() {
        Map<String, Storage> map = this.jobMap;
        synchronized (map) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Storage st : this.jobMap.values()) {
                values.addAll(st.getValueCollection());
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> getValueCollection(String job_id) {
        Map<String, Storage> map = this.jobMap;
        synchronized (map) {
            return this.getJobStorage(job_id).getValueCollection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(String job_id, String key) {
        Map<String, Storage> map = this.jobMap;
        synchronized (map) {
            return this.getJobStorage(job_id).getStore(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(String job_id, String key, Object value) {
        Map<String, Storage> map = this.jobMap;
        synchronized (map) {
            this.getJobStorage(job_id).addStore(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeValue(String job_id, String key) {
        Map<String, Storage> map = this.jobMap;
        synchronized (map) {
            return this.getJobStorage(job_id).removeStore(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsKey(String name) {
        Map<String, DebugJobStorage> map = storages;
        synchronized (map) {
            return storages.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DebugJobStorage getDebugStorage(String name) {
        Map<String, DebugJobStorage> map = storages;
        synchronized (map) {
            return storages.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugStorage(String name, DebugJobStorage storage) {
        Map<String, DebugJobStorage> map = storages;
        synchronized (map) {
            storages.put(name, storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DebugJobStorage[] getDebugStorages() {
        Map<String, DebugJobStorage> map = storages;
        synchronized (map) {
            return storages.values().toArray(new DebugJobStorage[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugStorage(String name) {
        Map<String, DebugJobStorage> map = storages;
        synchronized (map) {
            DebugJobStorage storage = storages.remove(name);
            if (storage != null) {
                storage.closeDebugJobStorage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugStorages() {
        Map<String, DebugJobStorage> map = storages;
        synchronized (map) {
            DebugJobStorage[] dStoreages;
            DebugJobStorage[] debugJobStorageArray = dStoreages = storages.values().toArray(new DebugJobStorage[0]);
            int n = dStoreages.length;
            int n2 = 0;
            while (n2 < n) {
                DebugJobStorage dStoreage = debugJobStorageArray[n2];
                dStoreage.closeDebugJobStorage();
                ++n2;
            }
            storages.clear();
        }
    }

    class Storage {
        Map<String, Object> aMap = new HashMap<String, Object>();

        Storage() {
        }

        void clean() {
            this.aMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean containsStore(String key) {
            Map<String, Object> map = this.aMap;
            synchronized (map) {
                return this.aMap.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addStore(String key, Object value) {
            Map<String, Object> map = this.aMap;
            synchronized (map) {
                this.aMap.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object removeStore(String key) {
            Map<String, Object> map = this.aMap;
            synchronized (map) {
                return this.aMap.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getStore(String key) {
            Map<String, Object> map = this.aMap;
            synchronized (map) {
                return this.aMap.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection<Object> getValueCollection() {
            Map<String, Object> map = this.aMap;
            synchronized (map) {
                return this.aMap.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[] getKeys() {
            Map<String, Object> map = this.aMap;
            synchronized (map) {
                return this.aMap.keySet().toArray(new String[0]);
            }
        }
    }
}

