/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonPlugin
extends AbstractUIPlugin {
    private static CommonPlugin plugin;
    private ResourceBundle resourceBundle;
    private static boolean eclipseTraceOn;
    private static boolean haveReadTraceStatus;
    public static final String PLUGIN_ID = "org.eclipse.ptp.pldt.common";

    static {
        eclipseTraceOn = false;
        haveReadTraceStatus = false;
    }

    public static boolean getTraceOn() {
        if (!haveReadTraceStatus) {
            String traceFilter = Platform.getDebugOption((String)"org.eclipse.ptp.pldt.common/debug/pldtTrace");
            if (traceFilter != null) {
                System.out.println("CommonPlugin.getTraceOn(): pldtTrace trace filtering is on; traceFilter= " + traceFilter);
                eclipseTraceOn = true;
            }
            haveReadTraceStatus = true;
        }
        return eclipseTraceOn;
    }

    public CommonPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault("showAnalysisConfirmation", true);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static CommonPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.ptp.pldt.common.CommonPluginResources");
            }
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CommonPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static void log(int type, String msg) {
        String pluginID = CommonPlugin.getDefault().getBundle().getSymbolicName();
        Throwable exc = null;
        Status status = new Status(type, pluginID, type, msg, exc);
        CommonPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String msg) {
        CommonPlugin.log(1, msg);
    }

    public List<String> getIncludeDirs(String includeID) {
        String stringList = this.getPreferenceStore().getString(includeID);
        StringTokenizer st = new StringTokenizer(stringList, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<String> dirs = new ArrayList<String>();
        while (st.hasMoreElements()) {
            dirs.add(st.nextToken());
        }
        return dirs;
    }
}

