/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.edge.SlidableAnchor;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.RectilinearEdgeUtil;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class RepairGMFbendpointsMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("12.1.0.201708031200");
    protected static final String FEATURE_NAME_LABEL = "name";
    protected Map<DRepresentation, String> representationToNameMap = new HashMap<DRepresentation, String>();

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            boolean isModified = false;
            StringBuilder sb = new StringBuilder(Messages.RepairGMFbendpointsMigrationParticipant_title);
            for (DView dView : dAnalysis.getOwnedViews()) {
                for (DDiagram dDiagram : Iterables.filter((Iterable)new DViewQuery(dView).getLoadedRepresentations(), DDiagram.class)) {
                    if (!"DSemanticDiagramSpec".equals(dDiagram.getClass().getSimpleName())) continue;
                    List<Edge> edgeList = this.getEdgeList(dDiagram);
                    boolean isEdgeModified = false;
                    for (Edge edge : edgeList) {
                        isEdgeModified = this.checkAndRepairBendpointsOfEdge(edge);
                    }
                    if (!isEdgeModified) continue;
                    isModified = true;
                    sb.append(MessageFormat.format(Messages.RepairGMFbendpointsMigrationParticipant_edgesModified, this.representationToNameMap.get(dDiagram)));
                }
            }
            if (isModified) {
                DiagramPlugin.getDefault().logInfo(sb.toString());
            }
        }
    }

    private boolean checkAndRepairBendpointsOfEdge(Edge edge) {
        boolean isEdgeModified = false;
        View source = edge.getSource();
        IdentityAnchor srcAnchor = (IdentityAnchor)edge.getSourceAnchor();
        View target = edge.getTarget();
        IdentityAnchor tgtAnchor = (IdentityAnchor)edge.getTargetAnchor();
        if (source != null && target != null) {
            List pointList = ((RelativeBendpoints)edge.getBendpoints()).getPoints();
            if (srcAnchor != null && tgtAnchor != null && pointList.size() == 2) {
                Point srcRef = this.getAnchorPosition(srcAnchor, source);
                Point tgtRef = this.getAnchorPosition(tgtAnchor, target);
                RelativeBendpoint firstPoint = (RelativeBendpoint)pointList.get(0);
                PrecisionPoint srcPoint = new PrecisionPoint(firstPoint.getSourceX() + srcRef.x, firstPoint.getSourceY() + srcRef.y);
                RelativeBendpoint lastPoint = (RelativeBendpoint)pointList.get(pointList.size() - 1);
                PrecisionPoint tgtPoint = new PrecisionPoint(lastPoint.getTargetX() + tgtRef.x, lastPoint.getTargetY() + tgtRef.y);
                Rectangle srcBounds = (Rectangle)GMFHelper.getAbsoluteBounds(source).get();
                Rectangle tgtBounds = (Rectangle)GMFHelper.getAbsoluteBounds(target).get();
                EdgeQuery edgeQuery = new EdgeQuery(edge);
                Routing routingStyle = edgeQuery.getRoutingStyle();
                if (Routing.RECTILINEAR_LITERAL.equals(routingStyle)) {
                    if (srcPoint.x != tgtPoint.x && srcPoint.y != tgtPoint.y) {
                        isEdgeModified = this.repairBendpointsOfEdge(edge, srcBounds, srcRef, tgtBounds, tgtRef);
                    }
                } else if (!this.isPointOnBounds(srcPoint, srcBounds) || !this.isPointOnBounds(tgtPoint, tgtBounds)) {
                    isEdgeModified = this.repairBendpointsOfEdge(edge, srcBounds, srcRef, tgtBounds, tgtRef);
                }
            }
        }
        return isEdgeModified;
    }

    private boolean repairBendpointsOfEdge(Edge edge, Rectangle srcBounds, Point srcRef, Rectangle tgtBounds, Point tgtRef) {
        boolean isEdgeModified = false;
        PointList newPointList = new PointList();
        Optional srcConnectionBendpoint = GraphicalHelper.getIntersection((Point)srcRef, (Point)tgtRef, (Rectangle)srcBounds, (boolean)true);
        Optional tgtConnectionBendpoint = GraphicalHelper.getIntersection((Point)srcRef, (Point)tgtRef, (Rectangle)tgtBounds, (boolean)false);
        if (srcConnectionBendpoint.isPresent() && tgtConnectionBendpoint.isPresent()) {
            isEdgeModified = true;
            EdgeQuery edgeQuery = new EdgeQuery(edge);
            Routing routingStyle = edgeQuery.getRoutingStyle();
            if (Routing.RECTILINEAR_LITERAL.equals(routingStyle) && srcBounds != null && srcBounds.equals((Object)tgtBounds)) {
                newPointList = RectilinearEdgeUtil.computeRectilinearBendpointsSameSourceAndTarget(srcBounds, srcBounds.getRight(), 16);
            } else if (Routing.RECTILINEAR_LITERAL.equals(routingStyle)) {
                newPointList = RectilinearEdgeUtil.computeRectilinearBendpoints(srcBounds, tgtBounds, (Point)srcConnectionBendpoint.get(), (Point)tgtConnectionBendpoint.get());
            } else {
                newPointList.addPoint((Point)srcConnectionBendpoint.get());
                newPointList.addPoint((Point)tgtConnectionBendpoint.get());
            }
            newPointList = RectilinearEdgeUtil.normalizeToStraightLineTolerance(newPointList, 2);
            this.setNewBendPoints(edge, srcRef, tgtRef, newPointList);
        }
        return isEdgeModified;
    }

    private void setNewBendPoints(Edge edge, Point srcRef, Point tgtRef, PointList newPointList) {
        ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
        int numOfPoints = newPointList.size();
        int i = 0;
        while (i < numOfPoints) {
            Dimension s = newPointList.getPoint(i).getDifference(srcRef);
            Dimension t = newPointList.getPoint(i).getDifference(tgtRef);
            newBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
            i = (short)(i + 1);
        }
        RelativeBendpoints points = (RelativeBendpoints)edge.getBendpoints();
        points.setPoints(newBendpoints);
    }

    private Point getAnchorPosition(IdentityAnchor anchor, View view) {
        String id = anchor.getId();
        PrecisionPoint relativeReference = SlidableAnchor.parseTerminalString(id);
        SlidableAnchor slidableAnchor = new SlidableAnchor(view, relativeReference);
        return slidableAnchor.getReferencePoint();
    }

    private boolean isPointOnBounds(PrecisionPoint point, Rectangle bounds) {
        boolean isInsideBounds;
        boolean isAlignWithBounds = point.x == bounds.x || point.x == bounds.x + bounds.width || point.y == bounds.y || point.y == bounds.y + bounds.height();
        boolean bl = isInsideBounds = point.y >= bounds.y && point.y <= bounds.y + bounds.height() && point.x >= bounds.x && point.x <= bounds.x + bounds.width;
        return isInsideBounds && isAlignWithBounds;
    }

    protected List<Edge> getEdgeList(DDiagram representation) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        TreeIterator eAllContents = representation.eAllContents();
        while (eAllContents.hasNext()) {
            EObject element = (EObject)eAllContents.next();
            if (!(element instanceof Edge)) continue;
            edges.add((Edge)element);
            eAllContents.prune();
        }
        return edges;
    }

    protected void handleFeature(EObject owner, EStructuralFeature unkownFeature, Object valueOfUnknownFeature) {
        if (owner instanceof DRepresentation && FEATURE_NAME_LABEL.equals(unkownFeature.getName())) {
            this.representationToNameMap.put((DRepresentation)owner, (String)valueOfUnknownFeature);
        }
    }
}

