/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.operations;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.DocumentedElement;

public final class DDiagramSpecOperations {
    private DDiagramSpecOperations() {
    }

    public static DView basicGetView(DDiagram diagram) {
        EObject cur = diagram.eContainer();
        DView result = null;
        while (cur != null && result == null) {
            if (cur instanceof DView) {
                result = (DView)cur;
            }
            cur = cur.eContainer();
        }
        return result;
    }

    public static EList<DNode> getNodesFromMapping(DDiagram vp, NodeMapping mapping) {
        BasicEList result = new BasicEList();
        for (DNode node : vp.getNodes()) {
            if (node.getActualMapping() != mapping) continue;
            result.add((Object)node);
        }
        return result;
    }

    public static EList<DEdge> getEdgesFromMapping(DDiagram vp, EdgeMapping mapping) {
        BasicEList result = new BasicEList();
        DocumentedElement mappingToCompare = mapping;
        if (mapping instanceof EdgeMappingImportWrapper) {
            mappingToCompare = ((EdgeMappingImportWrapper)mapping).getWrappedEdgeMappingImport();
        }
        for (DEdge edge : vp.getEdges()) {
            boolean importedOrImport = false;
            IEdgeMapping edgeMapping = edge.getActualMapping();
            if (edgeMapping instanceof EdgeMappingImportWrapper) {
                edgeMapping = ((EdgeMappingImportWrapper)edgeMapping).getWrappedEdgeMappingImport();
            }
            if (mappingToCompare instanceof EdgeMappingImport) {
                importedOrImport = LayerHelper.isImported(edgeMapping, (EdgeMappingImport)mappingToCompare);
            }
            if (!importedOrImport && edgeMapping instanceof EdgeMappingImport) {
                importedOrImport = LayerHelper.isImported(mappingToCompare, (EdgeMappingImport)edgeMapping);
            }
            if (edgeMapping != mappingToCompare && !importedOrImport) continue;
            result.add((Object)edge);
        }
        return result;
    }

    public static EList<DDiagramElementContainer> getContainersFromMapping(DDiagram vp, ContainerMapping mapping) {
        BasicEList result = new BasicEList();
        for (DDiagramElementContainer container : vp.getContainers()) {
            if (container.getActualMapping() != mapping) continue;
            result.add((Object)container);
        }
        return result;
    }
}

