/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.ui.business.api.template.RepresentationTemplateEdit;
import org.eclipse.sirius.ui.business.api.template.RepresentationTemplateEditManager;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationTemplate;

public class RepresentationTemplateEditManagerImpl
implements RepresentationTemplateEditManager {
    private List<RepresentationTemplateEdit> edits;

    @Override
    public Collection<? extends Object> provideNewChildDescriptors() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (RepresentationTemplateEdit edit : this.edits) {
            result.add(edit.getNewChildDescriptor());
        }
        return result;
    }

    public static RepresentationTemplateEditManager init() {
        RepresentationTemplateEditManagerImpl manager = new RepresentationTemplateEditManagerImpl();
        if (SiriusPlugin.IS_ECLIPSE_RUNNING) {
            List edits = EclipseUtil.getExtensionPlugins(RepresentationTemplateEdit.class, (String)"org.eclipse.sirius.ui.representationTemplateEdit", (String)"class");
            manager.setTemplateEdits(edits);
        }
        return manager;
    }

    @Override
    public EObject getSourceElement(EObject produced) {
        for (RepresentationTemplateEdit edit : this.edits) {
            EObject found = edit.getSourceElement(produced);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public void update(RepresentationTemplate template) {
        for (RepresentationTemplateEdit edit : this.edits) {
            edit.update(template);
        }
    }

    @Override
    public boolean isGenerated(EObject vsmObject) {
        for (RepresentationTemplateEdit edit : this.edits) {
            if (!edit.isGenerated(vsmObject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOverriden(EObject eObj, EStructuralFeature feature) {
        for (RepresentationTemplateEdit edit : this.edits) {
            if (!edit.isOverriden(eObj, feature)) continue;
            return true;
        }
        return false;
    }

    private void setTemplateEdits(List<RepresentationTemplateEdit> contributedEdits) {
        this.edits = contributedEdits;
    }
}

