/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;

public class CVSEntryLineTag
extends CVSTag {
    private static final String ENTRY_LINE_DATE_TAG_FORMAT = "yyyy.MM.dd.HH.mm.ss";
    private static SimpleDateFormat entryLineDateTagFormatter = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss", Locale.US);

    private static String getNameInInternalFormat(CVSTag tag) {
        String s;
        if (tag.getType() == 3 && (s = CVSEntryLineTag.ensureEntryLineFormat(tag.getName())) != null) {
            return s;
        }
        return tag.getName();
    }

    private static synchronized String ensureEntryLineFormat(String text) {
        if (text.length() == ENTRY_LINE_DATE_TAG_FORMAT.length()) {
            return text;
        }
        Date date = CVSEntryLineTag.tagNameToDate(text);
        if (date == null) {
            return text;
        }
        entryLineDateTagFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return entryLineDateTagFormatter.format(date);
    }

    public static synchronized Date entryLineToDate(String text) {
        try {
            entryLineDateTagFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            return entryLineDateTagFormatter.parse(text);
        }
        catch (ParseException e) {
            CVSProviderPlugin.log((IStatus)new CVSStatus(4, 4, "Tag name " + text + " is not of the expected format " + ENTRY_LINE_DATE_TAG_FORMAT, e));
            return null;
        }
    }

    public CVSEntryLineTag(CVSTag tag) {
        super(CVSEntryLineTag.getNameInInternalFormat(tag), tag.getType());
    }

    public CVSEntryLineTag(String entryLineTag) {
        switch (entryLineTag.charAt(0)) {
            case 'T': {
                this.type = 1;
                break;
            }
            case 'N': {
                this.type = 2;
                break;
            }
            case 'D': {
                this.type = 3;
                break;
            }
            default: {
                this.type = 0;
            }
        }
        this.name = entryLineTag.substring(1);
    }

    @Override
    public String getName() {
        Date date;
        if (this.getType() == 3 && (date = this.asDate()) != null) {
            return CVSEntryLineTag.dateToTagName(date);
        }
        return this.name;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public String toEntryLineFormat(boolean useSamePrefixForBranchAndTag) {
        if (this.type == 1 || this.type == 2 && useSamePrefixForBranchAndTag) {
            return "T" + this.name;
        }
        if (this.type == 2) {
            return "N" + this.name;
        }
        if (this.type == 3) {
            return "D" + this.name;
        }
        return "";
    }

    public String toString() {
        return this.toEntryLineFormat(false);
    }

    @Override
    public Date asDate() {
        return CVSEntryLineTag.entryLineToDate(this.name);
    }
}

