/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintCategory;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintInfo;
import org.eclipse.viatra.query.runtime.localsearch.planner.util.OperationCostComparator;
import org.eclipse.viatra.query.runtime.matchers.algorithms.OrderedIterableMerge;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;

public class PlanState {
    private final PBody pBody;
    private final List<PConstraintInfo> operationsList;
    private final Set<PVariable> boundVariables;
    private final Collection<PVariable> deltaVariables;
    private final Set<PConstraint> enforcedConstraints;
    private double cummulativeProduct;
    private double cost;
    private static Comparator<PConstraintInfo> infoComparator = new OperationCostComparator();
    private List<PConstraintInfo> presentExtends;

    public PlanState(PBody pBody, Set<PVariable> boundVariables) {
        this(pBody, new ArrayList<PConstraintInfo>(), boundVariables, boundVariables, 0.0, 1.0);
    }

    public PlanState cloneWithApplied(PConstraintInfo op) {
        ArrayList<PConstraintInfo> newOperationsList = new ArrayList<PConstraintInfo>(this.pBody.getConstraints().size());
        newOperationsList.addAll(this.getOperations());
        newOperationsList.add(op);
        Collection deltaVariables = op.getFreeVariables();
        HashSet<PVariable> allBoundVariables = new HashSet<PVariable>(this.getBoundVariables().size() + deltaVariables.size());
        allBoundVariables.addAll(this.getBoundVariables());
        allBoundVariables.addAll(deltaVariables);
        PlanState newState = new PlanState(this.getAssociatedPBody(), newOperationsList, allBoundVariables, deltaVariables, this.cost, this.cummulativeProduct);
        newState.accountNewOperation(op);
        return newState;
    }

    private PlanState(PBody pBody, List<PConstraintInfo> operationsList, Set<PVariable> boundVariables, Collection<PVariable> deltaVariables, double cost, double cummulativeProduct) {
        this.pBody = pBody;
        this.operationsList = operationsList;
        this.boundVariables = boundVariables;
        this.enforcedConstraints = new HashSet<PConstraint>();
        this.deltaVariables = deltaVariables;
        this.cost = cost;
        this.cummulativeProduct = cummulativeProduct;
    }

    private void accountNewOperation(PConstraintInfo constraintInfo) {
        this.enforcedConstraints.add(constraintInfo.getConstraint());
        this.accountCost(constraintInfo);
    }

    private void accountCost(PConstraintInfo constraintInfo) {
        double constraintCost;
        double branchFactor = constraintCost = constraintInfo.getCost();
        if (constraintCost > 0.0) {
            this.cost += this.cummulativeProduct * constraintCost;
            this.cummulativeProduct *= branchFactor;
        }
    }

    public Set<PConstraint> getEnforcedConstraints() {
        return this.enforcedConstraints;
    }

    public void updateExtends(Iterable<PConstraintInfo> allPotentialExtendInfos) {
        this.presentExtends = new ArrayList<PConstraintInfo>();
        for (PConstraintInfo op : allPotentialExtendInfos) {
            this.updateExtendInternal(op);
        }
    }

    public void updateExtendsBasedOnDelta(Iterable<PConstraintInfo> previousPresentExtends, Map<PVariable, ? extends Collection<PConstraintInfo>> extendOpsByBoundVariables) {
        this.presentExtends = new ArrayList<PConstraintInfo>();
        if (this.operationsList.isEmpty()) {
            throw new IllegalStateException("Not applicable as starting step");
        }
        for (PConstraintInfo extend : previousPresentExtends) {
            this.updateExtendInternal(extend);
        }
        HashSet<PConstraintInfo> affectedExtends = new HashSet<PConstraintInfo>();
        for (PVariable variable : this.deltaVariables) {
            Collection<PConstraintInfo> extendsForVariable = extendOpsByBoundVariables.get(variable);
            if (extendsForVariable == null) continue;
            affectedExtends.addAll(extendsForVariable);
        }
        for (PConstraintInfo extend : affectedExtends) {
            this.updateExtendInternal(extend);
        }
    }

    private void updateExtendInternal(PConstraintInfo op) {
        if (!this.enforcedConstraints.contains(op.getConstraint())) {
            this.categorizeExtend(op);
        }
    }

    public void applyChecks(List<PConstraintInfo> allPotentialCheckInfos) {
        this.applyChecksInternal(allPotentialCheckInfos);
    }

    public void applyChecksBasedOnDelta(Map<PVariable, List<PConstraintInfo>> checkOpsByVariables) {
        if (this.operationsList.isEmpty()) {
            throw new IllegalStateException("Not applicable as starting step");
        }
        Iterable<PConstraintInfo> affectedChecks = Collections.emptyList();
        for (PVariable variable : this.deltaVariables) {
            List<PConstraintInfo> checksForVariable = checkOpsByVariables.get(variable);
            if (checksForVariable == null) continue;
            affectedChecks = OrderedIterableMerge.mergeUniques(affectedChecks, checksForVariable, infoComparator);
        }
        this.applyChecksInternal(affectedChecks);
    }

    private void applyChecksInternal(Iterable<PConstraintInfo> checks) {
        for (PConstraintInfo checkInfo : checks) {
            if (!this.boundVariables.containsAll(checkInfo.getBoundVariables()) || this.enforcedConstraints.contains(checkInfo.getConstraint())) continue;
            this.operationsList.add(checkInfo);
            this.accountNewOperation(checkInfo);
        }
    }

    private void categorizeExtend(PConstraintInfo constraintInfo) {
        PConstraintCategory category = constraintInfo.getCategory(this.pBody, this.boundVariables);
        if (category == PConstraintCategory.PRESENT) {
            this.presentExtends.add(constraintInfo);
        }
    }

    public PBody getAssociatedPBody() {
        return this.pBody;
    }

    public List<PConstraintInfo> getOperations() {
        return this.operationsList;
    }

    public Set<PVariable> getBoundVariables() {
        return this.boundVariables;
    }

    public double getCost() {
        return this.cost;
    }

    public double getCummulativeProduct() {
        return this.cummulativeProduct;
    }

    public List<PConstraintInfo> getPresentExtends() {
        return this.presentExtends;
    }

    public Collection<PVariable> getDeltaVariables() {
        return this.deltaVariables;
    }
}

