/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.output;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.FileHandleImpl;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xpand2.output.VetoException;
import org.eclipse.xpand2.output.VetoStrategy;
import org.eclipse.xpand2.output.VetoStrategy2;

public class Outlet {
    private boolean append = false;
    private boolean overwrite = true;
    private String path = null;
    private String name = null;
    private String fileEncoding;
    public List<PostProcessor> postprocessors = new ArrayList<PostProcessor>();
    public List<VetoStrategy> vetoStrategies = new ArrayList<VetoStrategy>();
    private int filesCreated = 0;
    private int filesWrittenAndClosed = 0;

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public FileHandle createFileHandle(String filePath) throws VetoException {
        File f = new File(this.path, filePath);
        FileHandleImpl fileHandle = new FileHandleImpl(this, f);
        for (VetoStrategy vetoStrategy : this.vetoStrategies) {
            if (!(vetoStrategy instanceof VetoStrategy2) || !((VetoStrategy2)vetoStrategy).hasVetoBeforeOpen(fileHandle)) continue;
            throw new VetoException(filePath);
        }
        this.incFilesCreated();
        return fileHandle;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public void addPostprocessor(PostProcessor b) {
        this.postprocessors.add(b);
    }

    public void addVetoStrategy(VetoStrategy b) {
        this.vetoStrategies.add(b);
    }

    public void beforeWriteAndClose(FileHandle impl) {
        for (PostProcessor b : this.postprocessors) {
            b.beforeWriteAndClose(impl);
        }
    }

    public void afterClose(FileHandle impl) {
        this.incFilesWrittenAndClosed();
        for (PostProcessor b : this.postprocessors) {
            b.afterClose(impl);
        }
    }

    public int getFilesCreated() {
        return this.filesCreated;
    }

    protected final void incFilesCreated() {
        ++this.filesCreated;
    }

    public int getFilesWrittenAndClosed() {
        return this.filesWrittenAndClosed;
    }

    protected final void incFilesWrittenAndClosed() {
        ++this.filesWrittenAndClosed;
    }

    public Outlet(String path) {
        this.path = path;
    }

    public Outlet() {
    }

    public Outlet(boolean append, String encoding, String name, boolean overwrite, String path) {
        this.append = append;
        this.fileEncoding = encoding;
        this.name = name;
        this.overwrite = overwrite;
        this.path = path;
    }

    public boolean shouldWrite(FileHandle fileHandle) {
        for (VetoStrategy vs : this.vetoStrategies) {
            if (!vs.hasVeto(fileHandle)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(String.valueOf(this.name) + ":");
        }
        sb.append(this.path);
        if (this.isAppend() || !this.isOverwrite()) {
            sb.append("(").append("overwrite=").append(this.overwrite).append(",append=").append(this.append).append(",fileEncoding=").append(this.fileEncoding).append(")");
        }
        return sb.toString();
    }
}

