/*
 * generated by Xtext 2.17.0
 */
package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowShape;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowType;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowtypePackage;
import org.eclipse.gef.dot.internal.language.arrowtype.DeprecatedArrowShape;
import org.eclipse.gef.dot.internal.language.services.DotArrowTypeGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class DotArrowTypeSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DotArrowTypeGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == ArrowtypePackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case ArrowtypePackage.ARROW_SHAPE:
				sequence_ArrowShape(context, (ArrowShape) semanticObject); 
				return; 
			case ArrowtypePackage.ARROW_TYPE:
				sequence_ArrowType(context, (ArrowType) semanticObject); 
				return; 
			case ArrowtypePackage.DEPRECATED_ARROW_SHAPE:
				sequence_DeprecatedArrowShape(context, (DeprecatedArrowShape) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     AbstractArrowShape returns ArrowShape
	 *     ArrowShape returns ArrowShape
	 *
	 * Constraint:
	 *     (open?='o'? (side='l' | side='r')? shape=PrimitiveShape)
	 */
	protected void sequence_ArrowShape(ISerializationContext context, ArrowShape semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ArrowType returns ArrowType
	 *
	 * Constraint:
	 *     (arrowShapes+=AbstractArrowShape (arrowShapes+=AbstractArrowShape (arrowShapes+=AbstractArrowShape arrowShapes+=AbstractArrowShape?)?)?)?
	 */
	protected void sequence_ArrowType(ISerializationContext context, ArrowType semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AbstractArrowShape returns DeprecatedArrowShape
	 *     DeprecatedArrowShape returns DeprecatedArrowShape
	 *
	 * Constraint:
	 *     shape=DeprecatedShape
	 */
	protected void sequence_DeprecatedArrowShape(ISerializationContext context, DeprecatedArrowShape semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, ArrowtypePackage.Literals.DEPRECATED_ARROW_SHAPE__SHAPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ArrowtypePackage.Literals.DEPRECATED_ARROW_SHAPE__SHAPE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDeprecatedArrowShapeAccess().getShapeDeprecatedShapeEnumRuleCall_0(), semanticObject.getShape());
		feeder.finish();
	}
	
	
}
