/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RemoteArchetypeCatalogDialog
extends TitleAreaDialog {
    private static final int VERIFY_ID = 1025;
    private static final String DIALOG_SETTINGS = RemoteArchetypeCatalogDialog.class.getName();
    private static final String KEY_LOCATIONS = "catalogUrl";
    private static final int MAX_HISTORY = 15;
    private final String title;
    private final String message;
    Combo catalogUrlCombo;
    private Text catalogDescriptionText;
    private IDialogSettings dialogSettings;
    private ArchetypeCatalogFactory archetypeCatalogFactory;
    Button verifyButton;

    protected RemoteArchetypeCatalogDialog(Shell shell, ArchetypeCatalogFactory factory) {
        super(shell);
        this.archetypeCatalogFactory = factory;
        this.title = Messages.RemoteArchetypeCatalogDialog_title;
        this.message = Messages.RemoteArchetypeCatalogDialog_message;
        this.setShellStyle(2144);
        this.setHelpAvailable(false);
        IDialogSettings pluginSettings = M2EUIPluginActivator.getDefault().getDialogSettings();
        this.dialogSettings = pluginSettings.getSection(DIALOG_SETTINGS);
        if (this.dialogSettings == null) {
            this.dialogSettings = new DialogSettings(DIALOG_SETTINGS);
            pluginSettings.addSection(this.dialogSettings);
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(this.title);
        this.setMessage(this.message);
        this.update();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite1 = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(composite1, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 7;
        gridLayout.marginWidth = 12;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label catalogLocationLabel = new Label(composite, 0);
        catalogLocationLabel.setText(Messages.RemoteArchetypeCatalogDialog_lblCatalog);
        this.catalogUrlCombo = new Combo(composite, 0);
        GridData gd_catalogLocationCombo = new GridData(4, 0x1000000, true, false);
        gd_catalogLocationCombo.widthHint = 250;
        this.catalogUrlCombo.setLayoutData((Object)gd_catalogLocationCombo);
        this.catalogUrlCombo.setItems(this.getSavedValues(KEY_LOCATIONS));
        Label catalogDescriptionLabel = new Label(composite, 0);
        catalogDescriptionLabel.setText(Messages.RemoteArchetypeCatalogDialog_lblDesc);
        this.catalogDescriptionText = new Text(composite, 2048);
        this.catalogDescriptionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.archetypeCatalogFactory != null) {
            this.catalogUrlCombo.setText(this.archetypeCatalogFactory.getId());
            this.catalogDescriptionText.setText(this.archetypeCatalogFactory.getDescription());
        }
        ModifyListener modifyListener = e -> this.update();
        this.catalogUrlCombo.addModifyListener(modifyListener);
        this.catalogDescriptionText.addModifyListener(modifyListener);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        composite.setFont(parent.getFont());
        if (this.isHelpAvailable()) {
            this.createHelpControl(composite);
        }
        this.verifyButton = this.createButton(composite, 1025, Messages.RemoteArchetypeCatalogDialog_btnVerify, false);
        this.verifyButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.verifyButton.setEnabled(false);
            String url = this.catalogUrlCombo.getText();
            final ArchetypeCatalogFactory.RemoteCatalogFactory factory = new ArchetypeCatalogFactory.RemoteCatalogFactory(url, null, true);
            new Job(Messages.RemoteArchetypeCatalogDialog_job_download){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    ArchetypeCatalog catalog = null;
                    try {
                        catalog = factory.getArchetypeCatalog();
                    }
                    catch (Throwable throwable) {
                        IStatus s = status;
                        List archetypes = catalog == null ? Collections.emptyList() : catalog.getArchetypes();
                        Shell shell = RemoteArchetypeCatalogDialog.this.getShell();
                        if (shell == null) {
                            return status;
                        }
                        shell.getDisplay().asyncExec(() -> {
                            if (RemoteArchetypeCatalogDialog.this.verifyButton.isDisposed()) {
                                return;
                            }
                            RemoteArchetypeCatalogDialog.this.verifyButton.setEnabled(true);
                            if (!s.isOK()) {
                                RemoteArchetypeCatalogDialog.this.setErrorMessage(NLS.bind((String)Messages.RemoteArchetypeCatalogDialog_error_read, (Object)s.getMessage()));
                                RemoteArchetypeCatalogDialog.this.getButton(0).setEnabled(false);
                            } else if (archetypes.size() == 0) {
                                RemoteArchetypeCatalogDialog.this.setMessage(Messages.RemoteArchetypeCatalogDialog_error_empty, 2);
                            } else {
                                RemoteArchetypeCatalogDialog.this.setMessage(NLS.bind((String)Messages.RemoteArchetypeCatalogDialog_message_found, (Object)archetypes.size()), 1);
                            }
                        });
                        throw throwable;
                    }
                    IStatus s = status;
                    List archetypes = catalog == null ? Collections.emptyList() : catalog.getArchetypes();
                    Shell shell = RemoteArchetypeCatalogDialog.this.getShell();
                    if (shell == null) {
                        return status;
                    }
                    shell.getDisplay().asyncExec(() -> {
                        if (RemoteArchetypeCatalogDialog.this.verifyButton.isDisposed()) {
                            return;
                        }
                        RemoteArchetypeCatalogDialog.this.verifyButton.setEnabled(true);
                        if (!s.isOK()) {
                            RemoteArchetypeCatalogDialog.this.setErrorMessage(NLS.bind((String)Messages.RemoteArchetypeCatalogDialog_error_read, (Object)s.getMessage()));
                            RemoteArchetypeCatalogDialog.this.getButton(0).setEnabled(false);
                        } else if (archetypes.size() == 0) {
                            RemoteArchetypeCatalogDialog.this.setMessage(Messages.RemoteArchetypeCatalogDialog_error_empty, 2);
                        } else {
                            RemoteArchetypeCatalogDialog.this.setMessage(NLS.bind((String)Messages.RemoteArchetypeCatalogDialog_message_found, (Object)archetypes.size()), 1);
                        }
                    });
                    return Status.OK_STATUS;
                }
            }.schedule();
        }));
        Label filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(768));
        ++layout.numColumns;
        super.createButtonsForButtonBar(composite);
        return composite;
    }

    protected Button getButton(int id) {
        return super.getButton(id);
    }

    private String[] getSavedValues(String key) {
        String[] array = this.dialogSettings.getArray(key);
        return array == null ? new String[]{} : array;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        String description = this.catalogDescriptionText.getText().trim();
        String location = this.catalogUrlCombo.getText().trim();
        this.archetypeCatalogFactory = new ArchetypeCatalogFactory.RemoteCatalogFactory(location, description, true);
        this.saveValue(KEY_LOCATIONS, location);
        super.okPressed();
    }

    public ArchetypeCatalogFactory getArchetypeCatalogFactory() {
        return this.archetypeCatalogFactory;
    }

    private void saveValue(String key, String value) {
        List dirs = new ArrayList<String>();
        dirs.addAll(Arrays.asList(this.getSavedValues(key)));
        dirs.remove(value);
        dirs.add(0, value);
        if (dirs.size() > 15) {
            dirs = dirs.subList(0, 15);
        }
        this.dialogSettings.put(key, dirs.toArray(new String[dirs.size()]));
    }

    void update() {
        boolean isValid = this.isValid();
        this.getButton(0).setEnabled(isValid);
        this.getButton(1025).setEnabled(isValid);
    }

    private boolean isValid() {
        this.setErrorMessage(null);
        this.setMessage(null, 2);
        String url = this.catalogUrlCombo.getText().trim();
        boolean isValid = false;
        if (url.isEmpty()) {
            this.setErrorMessage(Messages.RemoteArchetypeCatalogDialog_error_required);
        } else if (!this.isWellFormedUrl(url)) {
            this.setErrorMessage(NLS.bind((String)Messages.RemoteArchetypeCatalogDialog_error_invalidUrl, (Object)url));
        } else {
            isValid = true;
        }
        this.verifyButton.setEnabled(isValid);
        return isValid;
    }

    public boolean isWellFormedUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

