/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import org.apache.lucene.document.Field;
import org.apache.maven.index.Field;
import org.apache.maven.index.IndexerFieldVersion;

public class IndexerField {
    private final Field ontology;
    private final IndexerFieldVersion version;
    private final String key;
    private final Field.Store storeMethod;
    private final Field.Index indexMethod;
    private final Field.TermVector termVector;

    public IndexerField(Field ontology, IndexerFieldVersion version, String key, String description, Field.Store storeMethod, Field.Index indexMethod) {
        this(ontology, version, key, description, storeMethod, indexMethod, null);
    }

    public IndexerField(Field ontology, IndexerFieldVersion version, String key, String description, Field.Store storeMethod, Field.Index indexMethod, Field.TermVector termVector) {
        this.ontology = ontology;
        this.version = version;
        this.key = key;
        this.storeMethod = storeMethod;
        this.indexMethod = indexMethod;
        this.termVector = termVector;
        ontology.addIndexerField(this);
    }

    public Field getOntology() {
        return this.ontology;
    }

    public IndexerFieldVersion getVersion() {
        return this.version;
    }

    public String getKey() {
        return this.key;
    }

    public Field.Store getStoreMethod() {
        return this.storeMethod;
    }

    public Field.Index getIndexMethod() {
        return this.indexMethod;
    }

    public Field.TermVector getTermVector() {
        return this.termVector;
    }

    public boolean isIndexed() {
        return !Field.Index.NO.equals((Object)this.indexMethod);
    }

    public boolean isKeyword() {
        return this.isIndexed() && !Field.Index.ANALYZED.equals((Object)this.indexMethod);
    }

    public boolean isStored() {
        return !Field.Store.NO.equals((Object)this.storeMethod);
    }

    public org.apache.lucene.document.Field toField(String value) {
        org.apache.lucene.document.Field result = this.getTermVector() != null ? new org.apache.lucene.document.Field(this.getKey(), value, this.getStoreMethod(), this.getIndexMethod(), this.getTermVector()) : new org.apache.lucene.document.Field(this.getKey(), value, this.getStoreMethod(), this.getIndexMethod());
        return result;
    }
}

