/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.operations;

import com.google.gerrit.common.data.ReviewerResult;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbstractRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.RemoveReviewerRequest;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.internal.gerrit.ui.operations.GerritOperationDialog;
import org.eclipse.mylyn.internal.gerrit.ui.operations.Messages;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RemoveReviewerDialog
extends GerritOperationDialog {
    private final IUser userToRemove;

    public RemoveReviewerDialog(Shell parentShell, ITask task, IUser user) {
        super(parentShell, task);
        this.userToRemove = user;
    }

    public GerritOperation<ReviewerResult> createOperation() {
        RemoveReviewerRequest request = new RemoveReviewerRequest(this.getTask().getTaskId(), this.userToRemove.getId());
        return GerritUiPlugin.getDefault().getOperationFactory().createOperation(this.task, (AbstractRequest)request);
    }

    protected Control createPageControls(Composite parent) {
        this.setTitle(Messages.RemoveReviewerDialog_Remove_Reviewer);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText(NLS.bind((String)Messages.RemoveReviewerDialog_Are_You_Sure_You_Want_To_Remove, (Object)this.userToRemove.getDisplayName()));
        return parent;
    }

    @Override
    protected boolean processOperationResult(GerritOperation<?> operation) {
        ReviewerResult reviewerResult;
        Object result = operation.getOperationResult();
        if (result instanceof ReviewerResult && (reviewerResult = (ReviewerResult)result).getErrors() != null && reviewerResult.getErrors().size() > 0) {
            this.setErrorMessage(reviewerResult.getErrors().toString());
            return false;
        }
        return super.processOperationResult(operation);
    }
}

