/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.quickfixes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.oomph.version.ui.quickfixes.AbstractResolution;
import org.eclipse.oomph.version.ui.quickfixes.Messages;
import org.eclipse.osgi.util.NLS;

public class PropertiesResolution
extends AbstractResolution {
    private String propertyKey;
    private String propertyValue;

    public PropertiesResolution(IMarker marker, String label, String propertyKey, String propertyValue) {
        super(marker, label, "icons/correction_configure.gif");
        this.propertyKey = propertyKey;
        this.propertyValue = propertyValue;
    }

    protected boolean isApplicable(IMarker marker) {
        return "unreferenced.element".equals(Markers.getProblemType((IMarker)marker));
    }

    public String getDescription() {
        IProject project = this.getMarker().getResource().getProject();
        VersionBuilderArguments arguments = new VersionBuilderArguments(project);
        IFile propertiesFile = VersionUtil.getFile((IPath)new Path(arguments.getReleasePath()), (String)"properties");
        return NLS.bind((String)Messages.PropertiesResolution_description_addValueToKeyOfPropertiesFile, (Object[])new Object[]{this.propertyValue, this.propertyKey, propertiesFile.getFullPath()});
    }

    protected void apply(IMarker marker) throws Exception {
        IProject project = marker.getResource().getProject();
        VersionBuilderArguments arguments = new VersionBuilderArguments(project);
        IFile propertiesFile = VersionUtil.getFile((IPath)new Path(arguments.getReleasePath()), (String)"properties");
        if (propertiesFile.exists()) {
            Properties properties = new Properties();
            InputStream contents = null;
            try {
                contents = propertiesFile.getContents();
                properties = new Properties();
                properties.load(contents);
                String oldValue = properties.getProperty(this.propertyKey, "");
                properties.setProperty(this.propertyKey, (String.valueOf(oldValue) + " " + this.propertyValue.replace("\\", "\\\\").replace(" ", "\\ ")).trim());
            }
            finally {
                IOUtil.closeSilent((Closeable)contents);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            properties.store(out, "");
            contents = new ByteArrayInputStream(out.toByteArray());
            propertiesFile.setContents(contents, true, true, null);
        }
    }

    public static class IgnoredReferences
    extends PropertiesResolution {
        public IgnoredReferences(IMarker marker) {
            super(marker, Messages.PropertiesResolution_ignoredReferences_label, "ignored.references", Markers.getQuickFixReference((IMarker)marker));
        }
    }

    public static class RootProjects
    extends PropertiesResolution {
        public RootProjects(IMarker marker) {
            super(marker, Messages.PropertiesResolution_rootProjects_label, "root.projects", marker.getResource().getProject().getName());
        }
    }
}

