/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.conditions.mining;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.Condition;
import org.eclipse.passage.lic.internal.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.api.io.StreamCodec;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.SumOfCollections;
import org.eclipse.passage.lic.internal.base.conditions.BaseConditionOrigin;
import org.eclipse.passage.lic.internal.base.conditions.BaseConditionPack;
import org.eclipse.passage.lic.internal.base.conditions.mining.ArmedMiningTool;
import org.eclipse.passage.lic.internal.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.code.NoRelevantConditions;
import org.eclipse.passage.lic.internal.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

final class PersonalLicenseMiningTool
extends ArmedMiningTool {
    public PersonalLicenseMiningTool(KeyKeeper key, StreamCodec codec, ConditionTransport transport, ConditionMiningTarget miner) {
        super(key, codec, transport, miner);
    }

    public ServiceInvocationResult<Collection<ConditionPack>> mine(Collection<Path> sources) {
        return sources.stream().map(path -> this.mine((Path)path)).reduce(new BaseServiceInvocationResult.Sum(new SumOfCollections())).orElse(new BaseServiceInvocationResult(Collections.emptyList()));
    }

    private ServiceInvocationResult<Collection<ConditionPack>> mine(Path source) {
        try {
            ConditionTransport.Data data = this.from(this.decoded(source));
            return new BaseServiceInvocationResult<Collection<ConditionPack>>(this.diagnostic(data.conditions(), source), Collections.singleton(new BaseConditionPack(new BaseConditionOrigin(this.miner, this.source(source), data.signature()), data.conditions())));
        }
        catch (IOException | LicensingException e) {
            return new BaseServiceInvocationResult<Trouble>(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format(BaseMessages.getString("MiningTool.error_mining_file"), source.normalize().toAbsolutePath()), (Exception)e));
        }
    }

    private ConditionTransport.Data from(byte[] decoded) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayInputStream input = new ByteArrayInputStream(decoded);){
            return this.transport.read((InputStream)input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Diagnostic diagnostic(Collection<Condition> conditions, Path source) {
        if (conditions.isEmpty()) {
            return new BaseDiagnostic(Collections.emptyList(), Collections.singletonList(new Trouble((TroubleCode)new NoRelevantConditions(), source.toAbsolutePath().toString())));
        }
        return new BaseDiagnostic();
    }
}

