/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import org.eclipse.photran.internal.core.preprocessor.c.ILexerLog;
import org.eclipse.photran.internal.core.preprocessor.c.Lexer;
import org.eclipse.photran.internal.core.preprocessor.c.MacroDefinitionParser;
import org.eclipse.photran.internal.core.preprocessor.c.MacroExpander;
import org.eclipse.photran.internal.core.preprocessor.c.OffsetLimitReachedException;
import org.eclipse.photran.internal.core.preprocessor.c.PreprocessorMacro;
import org.eclipse.photran.internal.core.preprocessor.c.Token;
import org.eclipse.photran.internal.core.preprocessor.c.TokenList;

class ObjectStyleMacro
extends PreprocessorMacro {
    private final char[] fExpansion;
    final int fExpansionOffset;
    final int fEndOffset;
    private TokenList fExpansionTokens;

    public ObjectStyleMacro(char[] name, char[] expansion) {
        this(name, 0, expansion.length, null, expansion);
    }

    public ObjectStyleMacro(char[] name, int expansionOffset, int endOffset, TokenList expansion, char[] source) {
        super(name);
        this.fExpansionOffset = expansionOffset;
        this.fEndOffset = endOffset;
        this.fExpansion = source;
        this.fExpansionTokens = expansion;
        if (expansion != null) {
            this.setSource(expansion.first());
        }
    }

    public int getExpansionOffset() {
        return this.fExpansionOffset;
    }

    public int getExpansionEndOffset() {
        return this.fEndOffset;
    }

    private void setSource(Token t) {
        int shift = -this.fExpansionOffset;
        while (t != null) {
            t.fSource = this;
            t.shiftOffset(shift);
            t = (Token)t.getNext();
        }
    }

    public char[] getExpansion() {
        return MacroDefinitionParser.getExpansion(this.fExpansion, this.fExpansionOffset, this.fEndOffset);
    }

    public char[] getExpansionImage() {
        int length = this.fEndOffset - this.fExpansionOffset;
        if (length == this.fExpansion.length) {
            return this.fExpansion;
        }
        char[] result = new char[length];
        System.arraycopy(this.fExpansion, this.fExpansionOffset, result, 0, length);
        return result;
    }

    @Override
    public TokenList getTokens(MacroDefinitionParser mdp, Lexer.LexerOptions lexOptions, MacroExpander expander) {
        if (this.fExpansionTokens == null) {
            this.fExpansionTokens = new TokenList();
            Lexer lex = new Lexer(this.fExpansion, this.fExpansionOffset, this.fEndOffset, lexOptions, ILexerLog.NULL, this);
            try {
                lex.nextToken();
                mdp.parseExpansion(lex, ILexerLog.NULL, this.getNameCharArray(), this.getParameterPlaceholderList(), this.fExpansionTokens);
            }
            catch (OffsetLimitReachedException offsetLimitReachedException) {
                // empty catch block
            }
        }
        return this.fExpansionTokens;
    }

    public final boolean isDynamic() {
        return false;
    }
}

