/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiViewerControl;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartData;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartModel;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.signal.ChartSelectionUpdateSignal;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.ui.dialog.ChartMakerDialog;
import org.eclipse.tracecompass.tmf.chart.core.model.IDataChartProvider;
import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public final class LamiReportViewTabPage
extends TmfComponent {
    private final LamiResultTable fResultTable;
    private final LamiViewerControl fTableViewerControl;
    private final List<LamiViewerControl> fCustomGraphViewerControls = new ArrayList<LamiViewerControl>();
    private final Composite fControl;
    private Set<Object> fSelection;

    public LamiReportViewTabPage(Composite parent, LamiResultTable table) {
        super(table.getTableClass().getTableTitle());
        LamiViewerControl tableViewerControl;
        this.fResultTable = table;
        this.fControl = parent;
        this.fSelection = LamiReportViewTabPage.getEntriesIntersectingTimerange(this.fResultTable, TmfTraceManager.getInstance().getCurrentTraceContext().getSelectionRange());
        this.fTableViewerControl = tableViewerControl = new LamiViewerControl(this.fControl, this);
        this.fTableViewerControl.getToggleAction().run();
        ChartSelectionUpdateSignal chartSignal = new ChartSelectionUpdateSignal((Object)this, (IDataChartProvider)this.fResultTable, this.fSelection);
        TmfSignalManager.dispatchSignal((TmfSignal)chartSignal);
        this.fControl.addDisposeListener(e -> {
            this.fTableViewerControl.dispose();
            this.clearAllCustomViewers();
            super.dispose();
        });
    }

    public void dispose() {
        this.fControl.dispose();
    }

    public void createNewCustomChart() {
        Shell shell = this.getControl().getShell();
        if (shell == null) {
            return;
        }
        ChartMakerDialog dialog = new ChartMakerDialog(shell, (IDataChartProvider)this.fResultTable);
        if (dialog.open() != 0) {
            return;
        }
        ChartData data = dialog.getDataSeries();
        ChartModel model = dialog.getChartModel();
        if (data == null || model == null) {
            return;
        }
        LamiViewerControl viewerControl = new LamiViewerControl(this.fControl, data, model);
        this.fCustomGraphViewerControls.add(viewerControl);
        viewerControl.getToggleAction().run();
        ChartSelectionUpdateSignal signal = new ChartSelectionUpdateSignal((Object)this, (IDataChartProvider)this.fResultTable, this.fSelection);
        TmfSignalManager.dispatchSignal((TmfSignal)signal);
    }

    public void clearAllCustomViewers() {
        this.fCustomGraphViewerControls.forEach(LamiViewerControl::dispose);
        this.fCustomGraphViewerControls.clear();
    }

    public void toggleTableViewer() {
        this.fTableViewerControl.getToggleAction().run();
    }

    public LamiViewerControl getTableViewerControl() {
        return this.fTableViewerControl;
    }

    public List<LamiViewerControl> getCustomGraphViewerControls() {
        return Collections.unmodifiableList(this.fCustomGraphViewerControls);
    }

    public Composite getControl() {
        return this.fControl;
    }

    public LamiResultTable getResultTable() {
        return this.fResultTable;
    }

    @TmfSignalHandler
    public void updateSelection(ChartSelectionUpdateSignal signal) {
        Set entries;
        if (signal.getSource() == this) {
            return;
        }
        if (this.fResultTable.hashCode() != signal.getDataProvider().hashCode()) {
            return;
        }
        this.fSelection = entries = signal.getSelectedObject();
        if (entries.size() == 1) {
            LamiTableEntry entry = (LamiTableEntry)Iterables.getOnlyElement((Iterable)entries);
            LamiTimeRange timeRange = entry.getCorrespondingTimeRange();
            if (timeRange == null) {
                return;
            }
            Long tsBeginValueNumber = timeRange.getBegin().getValue();
            Long tsEndValueNumber = timeRange.getEnd().getValue();
            if (tsBeginValueNumber == null || tsEndValueNumber == null) {
                return;
            }
            ITmfTimestamp start = TmfTimestamp.fromNanos((long)tsBeginValueNumber);
            ITmfTimestamp end = TmfTimestamp.fromNanos((long)tsEndValueNumber);
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, start, end));
        }
    }

    @TmfSignalHandler
    public void externalUpdateSelectionCustomCharts(TmfSelectionRangeUpdatedSignal signal) {
        if (signal.getSource() == this) {
            return;
        }
        TmfTimeRange range = new TmfTimeRange(signal.getBeginTime(), signal.getEndTime());
        Set<Object> selection = LamiReportViewTabPage.getEntriesIntersectingTimerange(this.fResultTable, range);
        ChartSelectionUpdateSignal updateSignal = new ChartSelectionUpdateSignal((Object)this, (IDataChartProvider)this.fResultTable, selection);
        TmfSignalManager.dispatchSignal((TmfSignal)updateSignal);
    }

    private static Set<Object> getEntriesIntersectingTimerange(LamiResultTable table, TmfTimeRange range) {
        HashSet<Object> entries = new HashSet<Object>();
        for (LamiTableEntry entry : table.getEntries()) {
            ITmfTimestamp end;
            LamiTimeRange lamiTimeRange = entry.getCorrespondingTimeRange();
            if (lamiTimeRange == null) {
                return entries;
            }
            Long tsBeginValueNumber = lamiTimeRange.getBegin().getValue();
            Long tsEndValueNumber = lamiTimeRange.getEnd().getValue();
            if (tsBeginValueNumber == null || tsEndValueNumber == null) {
                return entries;
            }
            ITmfTimestamp start = TmfTimestamp.fromNanos((long)tsBeginValueNumber);
            TmfTimeRange tempTimeRange = new TmfTimeRange(start, end = TmfTimestamp.fromNanos((long)tsEndValueNumber));
            if (tempTimeRange.getIntersection(range) == null) continue;
            entries.add(entry);
        }
        return entries;
    }
}

