/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.actions.EditLaunchConfigurationAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.unittest.internal.UnitTestPlugin;
import org.eclipse.unittest.internal.model.ITestRunSessionListener;
import org.eclipse.unittest.internal.model.ITestSessionListener;
import org.eclipse.unittest.internal.model.ProgressState;
import org.eclipse.unittest.internal.model.TestCaseElement;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.internal.model.UnitTestModel;
import org.eclipse.unittest.internal.ui.BasicElementLabels;
import org.eclipse.unittest.internal.ui.CounterPanel;
import org.eclipse.unittest.internal.ui.FailureTraceUIBlock;
import org.eclipse.unittest.internal.ui.Images;
import org.eclipse.unittest.internal.ui.Messages;
import org.eclipse.unittest.internal.ui.ProgressIcons;
import org.eclipse.unittest.internal.ui.ScrollLockAction;
import org.eclipse.unittest.internal.ui.ShowNextFailureAction;
import org.eclipse.unittest.internal.ui.ShowPreviousFailureAction;
import org.eclipse.unittest.internal.ui.TestViewer;
import org.eclipse.unittest.internal.ui.UnitTestCopyAction;
import org.eclipse.unittest.internal.ui.UnitTestProgressBar;
import org.eclipse.unittest.internal.ui.UnitTestUIPreferencesConstants;
import org.eclipse.unittest.internal.ui.history.History;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.model.ITestSuiteElement;
import org.eclipse.unittest.ui.ITestViewSupport;

public class TestRunnerViewPart
extends ViewPart {
    public static final String NAME = "org.eclipse.unittest.ui.ResultView";
    private static final String RERUN_LAST_COMMAND = "org.eclipse.unittest.ui.UnitTestShortcut.rerunLast";
    private static final String RERUN_FAILED_CASES_COMMAND = "org.eclipse.unittest.ui.UnitTestShortcut.rerunFailedCases";
    static final int REFRESH_INTERVAL = 200;
    protected boolean fAutoScroll = true;
    private int fOrientation = 2;
    private int fCurrentOrientation;
    private TestResultsLayout fLayout = TestResultsLayout.HIERARCHICAL;
    private UnitTestProgressBar fProgressBar;
    private ProgressIcons fProgressImages;
    protected Image fViewImage;
    private CounterPanel fCounterPanel;
    protected boolean fShowOnErrorOnly = false;
    protected Clipboard fClipboard;
    protected volatile String fInfoMessage;
    private FailureTraceUIBlock fFailureTrace;
    private TestViewer fTestViewer;
    private boolean fIsDisposed = false;
    private Action fNextAction;
    private Action fPreviousAction;
    private StopAction fStopAction;
    private UnitTestCopyAction fCopyAction;
    private Action fPasteAction;
    private Action fRerunLastTestAction;
    private IHandlerActivation fRerunLastActivation;
    private Action fRerunFailedCasesAction;
    private IHandlerActivation fRerunFailedFirstActivation;
    private EditLaunchConfigurationAction fEditLaunchConfigAction;
    private Action fFailuresOnlyFilterAction;
    private Action fIgnoredOnlyFilterAction;
    private ScrollLockAction fScrollLockAction;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private ShowTestHierarchyAction fShowTestHierarchyAction;
    private ShowTimeAction fShowTimeAction;
    private ActivateOnErrorAction fActivateOnErrorAction;
    private IMenuListener fViewMenuListener;
    private TestRunSession fTestRunSession;
    private TestSessionListener fTestSessionListener;
    private TestRunSessionListener fTestRunSessionListener;
    final Image fStackViewIcon;
    final Image fTestRunOKIcon;
    final Image fTestRunFailIcon;
    final Image fTestRunOKDirtyIcon;
    final Image fTestRunFailDirtyIcon;
    final Image fTestIcon;
    final Image fTestOkIcon;
    final Image fTestErrorIcon;
    final Image fTestFailIcon;
    final Image fTestAssumptionFailureIcon;
    final Image fTestRunningIcon;
    final Image fTestIgnoredIcon;
    final ImageDescriptor fSuiteIconDescriptor = Images.getImageDescriptor("obj16/tsuite.png");
    final ImageDescriptor fSuiteOkIconDescriptor = Images.getImageDescriptor("obj16/tsuiteok.png");
    final ImageDescriptor fSuiteErrorIconDescriptor = Images.getImageDescriptor("obj16/tsuiteerror.png");
    final ImageDescriptor fSuiteFailIconDescriptor = Images.getImageDescriptor("obj16/tsuitefail.png");
    final ImageDescriptor fSuiteRunningIconDescriptor = Images.getImageDescriptor("obj16/tsuiterun.png");
    final Image fSuiteIcon;
    final Image fSuiteOkIcon;
    final Image fSuiteErrorIcon;
    final Image fSuiteFailIcon;
    final Image fSuiteRunningIcon;
    final List<Image> fImagesToDispose;
    static final String TAG_PAGE = "page";
    static final String TAG_RATIO = "ratio";
    static final String TAG_TRACEFILTER = "tracefilter";
    static final String TAG_ORIENTATION = "orientation";
    static final String TAG_SCROLL = "scroll";
    static final String TAG_LAYOUT = "layout";
    static final String TAG_FAILURES_ONLY = "failuresOnly";
    static final String TAG_IGNORED_ONLY = "ignoredOnly";
    static final String TAG_SHOW_TIME = "time";
    static final String PREF_LAST_PATH = "lastImportExportPath";
    static final String PREF_LAST_URL = "lastImportURL";
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_AUTOMATIC = 2;
    private IMemento fMemento;
    Image fOriginalViewImage;
    private SashForm fSashForm;
    private Composite fCounterComposite;
    private Composite fParent;
    private UpdateUIJob fUpdateJob;
    private UnitTestIsRunningJob fUnitTestIsRunningJob;
    private ILock fUnitTestIsRunningLock;
    public static final Object FAMILY_UNITTEST_RUN = new Object();
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (TestRunnerViewPart.this.getSite().getId().equals(ref.getId())) {
                TestRunnerViewPart.this.fPartIsVisible = true;
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (TestRunnerViewPart.this.getSite().getId().equals(ref.getId())) {
                TestRunnerViewPart.this.fPartIsVisible = false;
            }
        }
    };
    protected boolean fPartIsVisible = false;

    public TestRunnerViewPart() {
        this.fImagesToDispose = new ArrayList<Image>();
        this.fStackViewIcon = this.createManagedImage("eview16/stackframe.png");
        this.fTestRunOKIcon = this.createManagedImage("eview16/unitsucc.png");
        this.fTestRunFailIcon = this.createManagedImage("eview16/uniterr.png");
        this.fTestRunOKDirtyIcon = this.createManagedImage("eview16/unitsuccq.png");
        this.fTestRunFailDirtyIcon = this.createManagedImage("eview16/uniterrq.png");
        this.fTestIcon = this.createManagedImage("obj16/test.png");
        this.fTestOkIcon = this.createManagedImage("obj16/testok.png");
        this.fTestErrorIcon = this.createManagedImage("obj16/testerr.png");
        this.fTestFailIcon = this.createManagedImage("obj16/testfail.png");
        this.fTestRunningIcon = this.createManagedImage("obj16/testrun.png");
        this.fTestIgnoredIcon = this.createManagedImage("obj16/testignored.png");
        this.fTestAssumptionFailureIcon = this.createManagedImage("obj16/testassumptionfailed.png");
        this.fSuiteIcon = this.createManagedImage(this.fSuiteIconDescriptor);
        this.fSuiteOkIcon = this.createManagedImage(this.fSuiteOkIconDescriptor);
        this.fSuiteErrorIcon = this.createManagedImage(this.fSuiteErrorIconDescriptor);
        this.fSuiteFailIcon = this.createManagedImage(this.fSuiteFailIconDescriptor);
        this.fSuiteRunningIcon = this.createManagedImage(this.fSuiteRunningIconDescriptor);
    }

    private Image createManagedImage(String path) {
        return this.createManagedImage(Images.getImageDescriptor(path));
    }

    private Image createManagedImage(ImageDescriptor descriptor) {
        Image image = descriptor.createImage();
        if (image == null) {
            image = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        this.fImagesToDispose.add(image);
        return image;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
        IWorkbenchSiteProgressService progressService = this.getProgressService();
        if (progressService != null) {
            progressService.showBusyForFamily(FAMILY_UNITTEST_RUN);
        }
    }

    private IWorkbenchSiteProgressService getProgressService() {
        Object siteService = this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    public void saveState(IMemento memento) {
        if (this.fSashForm == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        memento.putString(TAG_SCROLL, this.fScrollLockAction.isChecked() ? "true" : "false");
        int[] weigths = this.fSashForm.getWeights();
        int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
        memento.putInteger(TAG_RATIO, ratio);
        memento.putInteger(TAG_ORIENTATION, this.fOrientation);
        memento.putString(TAG_FAILURES_ONLY, this.fFailuresOnlyFilterAction.isChecked() ? "true" : "false");
        memento.putString(TAG_IGNORED_ONLY, this.fIgnoredOnlyFilterAction.isChecked() ? "true" : "false");
        memento.putString(TAG_LAYOUT, this.fLayout.name());
        memento.putString(TAG_SHOW_TIME, this.fShowTimeAction.isChecked() ? "true" : "false");
    }

    private void restoreLayoutState(IMemento memento) {
        String layoutString;
        Integer orientation;
        Integer ratio = memento.getInteger(TAG_RATIO);
        if (ratio != null) {
            this.fSashForm.setWeights(new int[]{ratio, 1000 - ratio});
        }
        if ((orientation = memento.getInteger(TAG_ORIENTATION)) != null) {
            this.fOrientation = orientation;
        }
        this.computeOrientation();
        String scrollLock = memento.getString(TAG_SCROLL);
        if (scrollLock != null) {
            this.fScrollLockAction.setChecked(scrollLock.equals("true"));
            this.setAutoScroll(!this.fScrollLockAction.isChecked());
        }
        TestResultsLayout layout = (layoutString = memento.getString(TAG_LAYOUT)) == null ? TestResultsLayout.HIERARCHICAL : TestResultsLayout.valueOf(layoutString);
        String failuresOnly = memento.getString(TAG_FAILURES_ONLY);
        boolean showFailuresOnly = false;
        if (failuresOnly != null) {
            showFailuresOnly = failuresOnly.equals("true");
        }
        String ignoredOnly = memento.getString(TAG_IGNORED_ONLY);
        boolean showIgnoredOnly = false;
        if (ignoredOnly != null) {
            showIgnoredOnly = ignoredOnly.equals("true");
        }
        String time = memento.getString(TAG_SHOW_TIME);
        boolean showTime = true;
        if (time != null) {
            showTime = time.equals("true");
        }
        this.setFilterAndLayout(showFailuresOnly, showIgnoredOnly, layout);
        this.setShowExecutionTime(showTime);
    }

    public void stopTest() {
        if (this.fTestRunSession != null) {
            if (this.fTestRunSession.isRunning()) {
                this.setContentDescription(Messages.TestRunnerViewPart_message_stopping);
            }
            this.fTestRunSession.abortTestRun();
        }
    }

    private void startUpdateJobs() {
        this.postSyncProcessChanges();
        if (this.fUpdateJob != null) {
            return;
        }
        this.fUnitTestIsRunningJob = new UnitTestIsRunningJob(Messages.TestRunnerViewPart_wrapperJobName);
        this.fUnitTestIsRunningLock = Job.getJobManager().newLock();
        this.fUnitTestIsRunningLock.acquire();
        this.getProgressService().schedule((Job)this.fUnitTestIsRunningJob);
        this.fUpdateJob = new UpdateUIJob(Messages.TestRunnerViewPart_jobName);
        this.fUpdateJob.schedule(200L);
    }

    private void stopUpdateJobs() {
        if (this.fUpdateJob != null) {
            this.fUpdateJob.stop();
            this.fUpdateJob = null;
        }
        if (this.fUnitTestIsRunningJob != null && this.fUnitTestIsRunningLock != null) {
            this.fUnitTestIsRunningLock.release();
            this.fUnitTestIsRunningJob = null;
        }
        this.postSyncProcessChanges();
    }

    private void processChangesInUI() {
        if (this.fSashForm.isDisposed()) {
            return;
        }
        this.doShowInfoMessage();
        this.refreshCounters();
        if (!this.fPartIsVisible) {
            this.updateViewTitleProgress();
        } else {
            this.updateViewIcon();
        }
        this.updateNextPreviousActions();
        this.fTestViewer.processChangesInUI();
    }

    private void updateNextPreviousActions() {
        boolean hasErrorsOrFailures = !this.fIgnoredOnlyFilterAction.isChecked() && this.hasErrorsOrFailures();
        this.fNextAction.setEnabled(hasErrorsOrFailures);
        this.fPreviousAction.setEnabled(hasErrorsOrFailures);
    }

    private String rerunLaunchMode() {
        return this.fTestRunSession != null && this.fTestRunSession.getLaunch() != null ? this.fTestRunSession.getLaunch().getLaunchMode() : "run";
    }

    private void rerunFailedTestCases() {
        if (this.lastLaunchStillRunning() && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.TestRunnerViewPart_terminate_title, (String)Messages.TestRunnerViewPart_terminate_message) && this.fTestRunSession != null) {
            this.fTestRunSession.abortTestRun();
        }
        ArrayList<ITestElement> allFailedTestCases = new ArrayList<ITestElement>();
        this.collectFailedTestCases(this.fTestRunSession, allFailedTestCases);
        ILaunchConfiguration tmp = this.fTestRunSession.getTestViewSupport().getRerunLaunchConfiguration(allFailedTestCases);
        if (tmp != null) {
            DebugUITools.launch((ILaunchConfiguration)tmp, (String)this.rerunLaunchMode());
        }
    }

    private void collectFailedTestCases(TestElement testElement, List<ITestElement> allFailedTestCases) {
        if (testElement == null) {
            return;
        }
        ITestElement.Result result = testElement.getTestResult(true);
        if (result != ITestElement.Result.ERROR && result != ITestElement.Result.FAILURE) {
            return;
        }
        if (testElement instanceof TestCaseElement) {
            allFailedTestCases.add(testElement);
        } else if (testElement instanceof ITestSuiteElement) {
            ((ITestSuiteElement)((Object)testElement)).getChildren().forEach(child -> this.collectFailedTestCases((TestElement)child, allFailedTestCases));
        }
    }

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public void selectNextFailure() {
        this.fTestViewer.selectFailure(true);
    }

    public void selectPreviousFailure() {
        this.fTestViewer.selectFailure(false);
    }

    protected void selectFirstFailure() {
        this.fTestViewer.selectFirstFailure();
    }

    private boolean hasErrorsOrFailures() {
        return this.getErrorsPlusFailures() > 0;
    }

    private int getErrorsPlusFailures() {
        if (this.fTestRunSession == null) {
            return 0;
        }
        return this.fTestRunSession.getCurrentErrorCount() + this.fTestRunSession.getCurrentFailureCount();
    }

    private void handleStopped() {
        this.postSyncRunnable(() -> {
            if (this.isDisposed()) {
                return;
            }
            this.resetViewIcon();
            this.fStopAction.setEnabled(false);
            this.updateRerunFailedFirstAction();
        });
        this.stopUpdateJobs();
        this.showMessageIfNoTests();
    }

    private void showMessageIfNoTests() {
        if (this.fTestRunSession != null && this.fTestRunSession.getFinalTestCaseCount() != null && this.fTestRunSession.getFinalTestCaseCount() == 0) {
            Display.getDefault().asyncExec(() -> {
                String msg = MessageFormat.format(Messages.TestRunnerViewPart_error_no_tests_found, this.getDisplayName());
                MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.TestRunnerViewPart__error_cannotrun, (String)msg);
            });
        }
    }

    private void resetViewIcon() {
        this.fViewImage = this.fOriginalViewImage;
        this.firePropertyChange(1);
    }

    private void updateViewIcon() {
        this.fViewImage = this.fTestRunSession == null || this.fTestRunSession.isStopped() || this.fTestRunSession.isRunning() || this.fTestRunSession.countStartedTestCases() == 0 ? this.fOriginalViewImage : (this.hasErrorsOrFailures() ? this.fTestRunFailIcon : this.fTestRunOKIcon);
        this.firePropertyChange(1);
    }

    private void updateViewTitleProgress() {
        if (this.fTestRunSession != null) {
            if (this.fTestRunSession.isRunning()) {
                Image progress = this.fProgressImages.getImage(this.fTestRunSession.countStartedTestCases(), this.fTestRunSession.getFinalTestCaseCount(), this.fTestRunSession.getCurrentErrorCount() > 0 || this.fTestRunSession.getCurrentFailureCount() > 0);
                if (progress != this.fViewImage) {
                    this.fViewImage = progress;
                    this.firePropertyChange(1);
                }
            } else {
                this.updateViewIcon();
            }
        } else {
            this.resetViewIcon();
        }
    }

    public TestRunSession setActiveTestRunSession(TestRunSession testRunSession) {
        if (this.fTestRunSession == testRunSession) {
            return null;
        }
        this.deregisterTestSessionListener();
        TestRunSession deactivatedSession = this.fTestRunSession;
        this.fTestRunSession = testRunSession;
        this.fTestViewer.registerActiveSession(testRunSession);
        History.INSTANCE.watch(testRunSession);
        if (this.fSashForm.isDisposed()) {
            this.stopUpdateJobs();
            return deactivatedSession;
        }
        if (testRunSession == null) {
            this.setTitleToolTip(null);
            this.resetViewIcon();
            this.clearStatus();
            this.fFailureTrace.clear();
            this.registerInfoMessage(" ");
            this.stopUpdateJobs();
            this.fStopAction.setEnabled(false);
            this.fRerunFailedCasesAction.setEnabled(false);
            this.fRerunLastTestAction.setEnabled(false);
        } else {
            if (this.fTestRunSession.isStarting() || this.fTestRunSession.isRunning()) {
                this.fTestSessionListener = new TestSessionListener();
                this.fTestRunSession.addTestSessionListener(this.fTestSessionListener);
            }
            if (!this.fTestRunSession.isStarting() && !this.fShowOnErrorOnly) {
                this.showTestResultsView();
            }
            this.setTitleToolTip();
            this.clearStatus();
            this.fFailureTrace.clear();
            this.registerInfoMessage(BasicElementLabels.getJavaElementName(this.fTestRunSession.getTestRunName()));
            this.updateRerunFailedFirstAction();
            this.fRerunLastTestAction.setEnabled(this.fTestRunSession.getLaunch() != null);
            this.fEditLaunchConfigAction.setEnabled(this.fTestRunSession.getLaunch() != null);
            this.fStopAction.setEnabled(this.fTestRunSession.isRunning());
            if (this.fTestRunSession.isRunning()) {
                this.startUpdateJobs();
            } else {
                this.stopUpdateJobs();
            }
        }
        this.getSite().getShell().getDisplay().asyncExec(this::processChangesInUI);
        return deactivatedSession;
    }

    private void deregisterTestSessionListener() {
        if (this.fTestRunSession != null && this.fTestSessionListener != null) {
            this.fTestRunSession.removeTestSessionListener(this.fTestSessionListener);
            this.fTestSessionListener = null;
        }
    }

    private void updateRerunFailedFirstAction() {
        boolean state = this.hasErrorsOrFailures() && this.fTestRunSession.getLaunch().getLaunchConfiguration() != null;
        this.fRerunFailedCasesAction.setEnabled(state);
    }

    public String getDisplayName() {
        ITestViewSupport testViewSupport = this.fTestRunSession.getTestViewSupport();
        return testViewSupport != null ? testViewSupport.getDisplayName() : null;
    }

    private void setTitleToolTip() {
        String displayStr = this.getDisplayName();
        String testRunLabel = BasicElementLabels.getJavaElementName(this.fTestRunSession.getTestRunName());
        if (displayStr != null) {
            this.setTitleToolTip(MessageFormat.format(Messages.TestRunnerViewPart_titleToolTip, testRunLabel, displayStr));
        } else {
            this.setTitleToolTip(testRunLabel);
        }
    }

    public synchronized void dispose() {
        this.fIsDisposed = true;
        if (this.fTestRunSessionListener != null) {
            UnitTestModel.getInstance().removeTestRunSessionListener(this.fTestRunSessionListener);
        }
        IHandlerService handlerService = (IHandlerService)this.getSite().getWorkbenchWindow().getService(IHandlerService.class);
        handlerService.deactivateHandler(this.fRerunLastActivation);
        handlerService.deactivateHandler(this.fRerunFailedFirstActivation);
        this.setActiveTestRunSession(null);
        if (this.fProgressImages != null) {
            this.fProgressImages.dispose();
        }
        this.getViewSite().getPage().removePartListener(this.fPartListener);
        this.disposeImages();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
        if (this.fViewMenuListener != null) {
            this.getViewSite().getActionBars().getMenuManager().removeMenuListener(this.fViewMenuListener);
        }
        if (this.fFailureTrace != null) {
            this.fFailureTrace.dispose();
        }
    }

    private void disposeImages() {
        for (Image imageToDispose : this.fImagesToDispose) {
            imageToDispose.dispose();
        }
    }

    private void postSyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(r);
        }
    }

    private void refreshCounters() {
        boolean stopped;
        boolean hasErrorsOrFailures;
        int assumptionFailureCount;
        int failureCount;
        int errorCount;
        Integer totalCount;
        int ignoredCount;
        int startedCount;
        if (this.fTestRunSession != null) {
            startedCount = this.fTestRunSession.countStartedTestCases();
            ignoredCount = this.fTestRunSession.getCurrentIgnoredCount();
            totalCount = this.fTestRunSession.getFinalTestCaseCount();
            errorCount = this.fTestRunSession.getCurrentErrorCount();
            failureCount = this.fTestRunSession.getCurrentFailureCount();
            assumptionFailureCount = this.fTestRunSession.getCurrentAssumptionFailureCount();
            hasErrorsOrFailures = errorCount + failureCount > 0;
            stopped = this.fTestRunSession.isStopped();
        } else {
            startedCount = 0;
            ignoredCount = 0;
            totalCount = null;
            errorCount = 0;
            failureCount = 0;
            assumptionFailureCount = 0;
            hasErrorsOrFailures = false;
            stopped = false;
        }
        this.fCounterPanel.setTotal(totalCount);
        this.fCounterPanel.setRunValue(startedCount, ignoredCount, assumptionFailureCount);
        this.fCounterPanel.setErrorValue(errorCount);
        this.fCounterPanel.setFailureValue(failureCount);
        int ticksDone = startedCount == 0 ? 0 : (totalCount != null && startedCount == totalCount && this.fTestRunSession.getProgressState() == ProgressState.COMPLETED ? totalCount : startedCount - 1);
        this.fProgressBar.reset(hasErrorsOrFailures, stopped, ticksDone, totalCount != null ? totalCount : ticksDone + 1);
    }

    protected void postShowTestResultsView() {
        this.postSyncRunnable(() -> {
            if (this.isDisposed()) {
                return;
            }
            this.showTestResultsView();
        });
    }

    public void showTestResultsView() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        TestRunnerViewPart testRunner = null;
        if (page != null) {
            try {
                testRunner = (TestRunnerViewPart)page.findView(NAME);
                if (testRunner == null) {
                    IWorkbenchPart activePart = page.getActivePart();
                    testRunner = (TestRunnerViewPart)page.showView(NAME, null, 2);
                    page.activate(activePart);
                } else {
                    page.bringToTop((IWorkbenchPart)testRunner);
                }
            }
            catch (PartInitException pie) {
                UnitTestPlugin.log(pie);
            }
        }
    }

    protected void doShowInfoMessage() {
        if (this.fInfoMessage != null) {
            this.setContentDescription(this.fInfoMessage);
            this.fInfoMessage = null;
        }
    }

    public void registerInfoMessage(String message) {
        this.fInfoMessage = message;
    }

    private SashForm createSashForm(Composite parent) {
        this.fSashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)this.fSashForm, 0);
        Composite empty = new Composite((Composite)top, 0);
        empty.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(1, 1);
            }

            protected void layout(Composite composite, boolean flushCache) {
            }
        });
        top.setTopLeft((Control)empty);
        this.fTestViewer = new TestViewer((Composite)top, this.fClipboard, this);
        top.setContent(this.fTestViewer.getTestViewerControl());
        ViewForm bottom = new ViewForm((Composite)this.fSashForm, 0);
        CLabel label = new CLabel((Composite)bottom, 0);
        label.setText(Messages.TestRunnerViewPart_label_failure);
        label.setImage(this.fStackViewIcon);
        bottom.setTopLeft((Control)label);
        ToolBar failureToolBar = new ToolBar((Composite)bottom, 0x800040);
        bottom.setTopCenter((Control)failureToolBar);
        this.fFailureTrace = new FailureTraceUIBlock((Composite)bottom, this.fClipboard, this, failureToolBar);
        bottom.setContent((Control)this.fFailureTrace.getComposite());
        this.fSashForm.setWeights(new int[]{50, 50});
        return this.fSashForm;
    }

    private void clearStatus() {
        this.getStatusLine().setMessage(null);
        this.getStatusLine().setErrorMessage(null);
    }

    public void setFocus() {
        if (this.fTestViewer != null) {
            this.fTestViewer.getTestViewerControl().setFocus();
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.addResizeListener(parent);
        this.fClipboard = new Clipboard(parent.getDisplay());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.configureToolBar();
        this.fCounterComposite = this.createProgressCountPanel(parent);
        this.fCounterComposite.setLayoutData((Object)new GridData(768));
        SashForm sashForm = this.createSashForm(parent);
        sashForm.setLayoutData((Object)new GridData(1808));
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fCopyAction = new UnitTestCopyAction(this.fFailureTrace, this.fClipboard);
        this.fCopyAction.setActionDefinitionId(ActionFactory.COPY.getCommandId());
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        this.fPasteAction = new UnitTesttPasteAction(parent.getShell(), this.fClipboard);
        this.fPasteAction.setActionDefinitionId(ActionFactory.PASTE.getCommandId());
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fPasteAction);
        this.initPageSwitcher();
        this.addDropAdapter(parent);
        this.fOriginalViewImage = this.getTitleImage();
        this.fProgressImages = new ProgressIcons(this.fOriginalViewImage);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.unittest.ui.results_view_context");
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.setFilterAndLayout(false, false, TestResultsLayout.HIERARCHICAL);
        this.setShowExecutionTime(true);
        if (this.fMemento != null) {
            this.restoreLayoutState(this.fMemento);
        }
        this.fMemento = null;
        this.fTestRunSessionListener = new TestRunSessionListener();
        UnitTestModel.getInstance().addTestRunSessionListener(this.fTestRunSessionListener);
        UnitTestModel.getInstance().addTestRunSessionListener(History.INSTANCE);
        List<TestRunSession> testRunSessions = UnitTestModel.getInstance().getTestRunSessions();
        if (!testRunSessions.isEmpty()) {
            this.fTestRunSessionListener.sessionAdded(testRunSessions.get(0));
        }
    }

    private void addDropAdapter(Composite parent) {
        DropTarget dropTarget = new DropTarget((Control)parent, 23);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        class DropAdapter
        extends DropTargetAdapter {
            DropAdapter() {
            }

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
                event.feedback = 0;
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 1;
                event.feedback = 0;
            }

            public void dragOperationChanged(DropTargetEvent event) {
                event.detail = 1;
                event.feedback = 0;
            }

            public void drop(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String url = (String)event.data;
                    TestRunnerViewPart.importTestRunSession(url);
                }
            }
        }
        dropTarget.addDropListener((DropTargetListener)new DropAdapter());
    }

    private void initPageSwitcher() {
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(ControlListener.controlResizedAdapter(e -> this.computeOrientation()));
    }

    void computeOrientation() {
        if (this.fOrientation != 2) {
            this.fCurrentOrientation = this.fOrientation;
            this.setOrientation(this.fCurrentOrientation);
        } else {
            Point size = this.fParent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
    }

    private void configureToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fNextAction = new ShowNextFailureAction(this);
        this.fNextAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextAction);
        this.fPreviousAction = new ShowPreviousFailureAction(this);
        this.fPreviousAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPreviousAction);
        this.fStopAction = new StopAction();
        this.fStopAction.setEnabled(false);
        this.fRerunLastTestAction = new RerunLastAction();
        IHandlerService handlerService = (IHandlerService)this.getSite().getWorkbenchWindow().getService(IHandlerService.class);
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                TestRunnerViewPart.this.fRerunLastTestAction.run();
                return null;
            }

            public boolean isEnabled() {
                return TestRunnerViewPart.this.fRerunLastTestAction.isEnabled();
            }
        };
        this.fRerunLastActivation = handlerService.activateHandler(RERUN_LAST_COMMAND, (IHandler)handler);
        this.fRerunFailedCasesAction = new RerunFailedCasesAction();
        handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                TestRunnerViewPart.this.fRerunFailedCasesAction.run();
                return null;
            }

            public boolean isEnabled() {
                return TestRunnerViewPart.this.fRerunFailedCasesAction.isEnabled();
            }
        };
        this.fRerunFailedFirstActivation = handlerService.activateHandler(RERUN_FAILED_CASES_COMMAND, (IHandler)handler);
        this.fEditLaunchConfigAction = new EditLaunchConfigurationAction(){

            protected ILaunchConfiguration getLaunchConfiguration() {
                return TestRunnerViewPart.this.fTestRunSession != null ? TestRunnerViewPart.this.fTestRunSession.getLaunch().getLaunchConfiguration() : null;
            }

            protected String getMode() {
                return TestRunnerViewPart.this.rerunLaunchMode();
            }

            protected boolean isTerminated() {
                return true;
            }
        };
        this.fEditLaunchConfigAction.setToolTipText(Messages.TestRunnerViewPart_editLaunchConfiguration);
        this.fEditLaunchConfigAction.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_OBJS_MODIFICATION_WATCHPOINT"));
        this.fEditLaunchConfigAction.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_OBJS_MODIFICATION_WATCHPOINT_DISABLED"));
        this.fFailuresOnlyFilterAction = new FailuresOnlyFilterAction();
        this.fIgnoredOnlyFilterAction = new IgnoredOnlyFilterAction();
        this.fScrollLockAction = new ScrollLockAction(this);
        this.fScrollLockAction.setChecked(!this.fAutoScroll);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(0), new ToggleOrientationAction(1), new ToggleOrientationAction(2)};
        toolBar.add((IAction)this.fNextAction);
        toolBar.add((IAction)this.fPreviousAction);
        toolBar.add((IAction)this.fFailuresOnlyFilterAction);
        toolBar.add((IAction)this.fIgnoredOnlyFilterAction);
        toolBar.add((IAction)this.fScrollLockAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fRerunLastTestAction);
        toolBar.add((IAction)this.fRerunFailedCasesAction);
        toolBar.add((IAction)this.fStopAction);
        toolBar.add((IAction)this.fEditLaunchConfigAction);
        toolBar.add((IContributionItem)new Separator());
        CommandContributionItem historyIte = new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), "org.eclipse.unittest.ui.history", "org.eclipse.unittest.ui.history", 8));
        toolBar.add((IContributionItem)historyIte);
        this.fShowTestHierarchyAction = new ShowTestHierarchyAction();
        this.fShowTimeAction = new ShowTimeAction();
        viewMenu.add((IAction)this.fShowTestHierarchyAction);
        viewMenu.add((IAction)this.fShowTimeAction);
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(Messages.TestRunnerViewPart_layout_menu);
        ToggleOrientationAction[] toggleOrientationActionArray = this.fToggleOrientationActions;
        int n = this.fToggleOrientationActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleOrientationAction toggleOrientationAction = toggleOrientationActionArray[n2];
            layoutSubMenu.add((IAction)toggleOrientationAction);
            ++n2;
        }
        viewMenu.add((IContributionItem)layoutSubMenu);
        MenuManager sortSubmenu = new MenuManager(Messages.TestRunnerViewPart_sort);
        sortSubmenu.add((IAction)new SortAction(true));
        sortSubmenu.add((IAction)new SortAction(false));
        viewMenu.add((IContributionItem)sortSubmenu);
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.fFailuresOnlyFilterAction);
        viewMenu.add((IAction)this.fIgnoredOnlyFilterAction);
        this.fActivateOnErrorAction = new ActivateOnErrorAction();
        viewMenu.add((IAction)this.fActivateOnErrorAction);
        this.fViewMenuListener = manager -> this.fActivateOnErrorAction.update();
        viewMenu.addMenuListener(this.fViewMenuListener);
        actionBars.updateActionBars();
    }

    private IStatusLineManager getStatusLine() {
        IEditorPart activeEditorPart;
        IEditorActionBarContributor contributor;
        IViewSite site = this.getViewSite();
        IWorkbenchPage page = site.getPage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart activeViewPart = (IViewPart)activePart;
            IViewSite activeViewSite = activeViewPart.getViewSite();
            return activeViewSite.getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    protected Composite createProgressCountPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setCounterColumns(layout);
        this.fCounterPanel = new CounterPanel(composite);
        this.fCounterPanel.setLayoutData(new GridData(768));
        this.fProgressBar = new UnitTestProgressBar(composite);
        this.fProgressBar.setLayoutData(new GridData(768));
        return composite;
    }

    public void handleTestSelected(TestElement test) {
        this.showFailure(test);
        this.fCopyAction.handleTestSelected(test);
    }

    private void showFailure(TestElement test) {
        this.postSyncRunnable(() -> {
            if (!this.isDisposed()) {
                this.fFailureTrace.showFailure(test);
            }
        });
    }

    public TestRunSession getCurrentTestRunSession() {
        return this.fTestRunSession;
    }

    private boolean isDisposed() {
        return this.fIsDisposed || this.fCounterPanel.isDisposed();
    }

    private Display getDisplay() {
        return this.getViewSite().getShell().getDisplay();
    }

    public Image getTitleImage() {
        if (this.fOriginalViewImage == null) {
            this.fOriginalViewImage = super.getTitleImage();
        }
        if (this.fViewImage == null) {
            return super.getTitleImage();
        }
        return this.fViewImage;
    }

    void codeHasChanged() {
        if (this.fViewImage == this.fTestRunOKIcon) {
            this.fViewImage = this.fTestRunOKDirtyIcon;
        } else if (this.fViewImage == this.fTestRunFailIcon) {
            this.fViewImage = this.fTestRunFailDirtyIcon;
        }
        Runnable r = () -> {
            if (this.isDisposed()) {
                return;
            }
            this.firePropertyChange(1);
        };
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(r);
        }
    }

    private void postSyncProcessChanges() {
        this.postSyncRunnable(this::processChangesInUI);
    }

    public void warnOfContentChange() {
        IWorkbenchSiteProgressService service = this.getProgressService();
        if (service != null) {
            service.warnOfContentChange();
        }
    }

    public boolean lastLaunchStillRunning() {
        return this.fTestRunSession != null && !this.fTestRunSession.getLaunch().isTerminated();
    }

    private void setOrientation(int orientation) {
        if (this.fSashForm == null || this.fSashForm.isDisposed()) {
            return;
        }
        boolean horizontal = orientation == 1;
        this.fSashForm.setOrientation(horizontal ? 256 : 512);
        ToggleOrientationAction[] toggleOrientationActionArray = this.fToggleOrientationActions;
        int n = this.fToggleOrientationActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleOrientationAction toggleOrientationAction;
            toggleOrientationAction.setChecked(this.fOrientation == (toggleOrientationAction = toggleOrientationActionArray[n2]).getOrientation());
            ++n2;
        }
        this.fCurrentOrientation = orientation;
        GridLayout layout = (GridLayout)this.fCounterComposite.getLayout();
        this.setCounterColumns(layout);
        this.fParent.layout();
    }

    private void setCounterColumns(GridLayout layout) {
        layout.numColumns = this.fCurrentOrientation == 1 ? 2 : 1;
    }

    static boolean getShowOnErrorOnly() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.unittest.ui", "org.eclipse.unittest.ui.show_on_error", false, null);
    }

    static void importTestRunSession(String url) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                ITestRunSession iTestRunSession = UnitTestModel.getInstance().importTestRunSession(url, monitor);
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            CoreException ce = (CoreException)e.getCause();
            StatusManager.getManager().handle(ce.getStatus(), 3);
        }
    }

    public FailureTraceUIBlock getFailureTrace() {
        return this.fFailureTrace;
    }

    void setShowFailuresOnly(boolean failuresOnly) {
        this.setFilterAndLayout(failuresOnly, false, this.fLayout);
    }

    void setShowIgnoredOnly(boolean ignoredOnly) {
        this.setFilterAndLayout(false, ignoredOnly, this.fLayout);
    }

    private void setFilterAndLayout(boolean failuresOnly, boolean ignoredOnly, TestResultsLayout layoutMode) {
        this.fShowTestHierarchyAction.setChecked(layoutMode == TestResultsLayout.HIERARCHICAL);
        this.fLayout = layoutMode;
        this.fFailuresOnlyFilterAction.setChecked(failuresOnly);
        this.fIgnoredOnlyFilterAction.setChecked(ignoredOnly);
        this.fTestViewer.setShowFailuresOrIgnoredOnly(failuresOnly, ignoredOnly, layoutMode);
        this.updateNextPreviousActions();
    }

    private void setShowExecutionTime(boolean showTime) {
        this.fTestViewer.setShowTime(showTime);
        this.fShowTimeAction.setChecked(showTime);
    }

    private class ActivateOnErrorAction
    extends Action {
        public ActivateOnErrorAction() {
            super(Messages.TestRunnerViewPart_activate_on_failure_only, 2);
            this.update();
        }

        public void update() {
            this.setChecked(TestRunnerViewPart.getShowOnErrorOnly());
        }

        public void run() {
            boolean checked;
            TestRunnerViewPart.this.fShowOnErrorOnly = checked = this.isChecked();
            InstanceScope.INSTANCE.getNode("org.eclipse.unittest.ui").putBoolean("org.eclipse.unittest.ui.show_on_error", checked);
        }
    }

    private class FailuresOnlyFilterAction
    extends Action {
        public FailuresOnlyFilterAction() {
            super(Messages.TestRunnerViewPart_show_failures_only, 2);
            this.setToolTipText(Messages.TestRunnerViewPart_show_failures_only);
            this.setImageDescriptor(Images.getImageDescriptor("obj16/failures.png"));
        }

        public void run() {
            TestRunnerViewPart.this.setShowFailuresOnly(this.isChecked());
        }
    }

    private class IgnoredOnlyFilterAction
    extends Action {
        public IgnoredOnlyFilterAction() {
            super(Messages.TestRunnerViewPart_show_ignored_only, 2);
            this.setToolTipText(Messages.TestRunnerViewPart_show_ignored_only);
            this.setImageDescriptor(Images.getImageDescriptor("obj16/testignored.png"));
        }

        public void run() {
            TestRunnerViewPart.this.setShowIgnoredOnly(this.isChecked());
        }
    }

    private class RerunFailedCasesAction
    extends Action {
        public RerunFailedCasesAction() {
            this.setText(Messages.TestRunnerViewPart_rerunfailuresaction_label);
            this.setToolTipText(Messages.TestRunnerViewPart_rerunfailuresaction_tooltip);
            Images.setLocalImageDescriptors((IAction)this, "relaunchf.png");
            this.setEnabled(false);
            this.setActionDefinitionId(TestRunnerViewPart.RERUN_FAILED_CASES_COMMAND);
        }

        public void run() {
            TestRunnerViewPart.this.rerunFailedTestCases();
        }
    }

    private class RerunLastAction
    extends Action {
        public RerunLastAction() {
            this.setText(Messages.TestRunnerViewPart_rerunaction_label);
            this.setToolTipText(Messages.TestRunnerViewPart_rerunaction_tooltip);
            Images.setLocalImageDescriptors((IAction)this, "relaunch.png");
            this.setEnabled(false);
            this.setActionDefinitionId(TestRunnerViewPart.RERUN_LAST_COMMAND);
        }

        public void run() {
            DebugUITools.launch((ILaunchConfiguration)TestRunnerViewPart.this.fTestRunSession.getLaunch().getLaunchConfiguration(), (String)TestRunnerViewPart.this.rerunLaunchMode());
        }
    }

    private class ShowTestHierarchyAction
    extends Action {
        public ShowTestHierarchyAction() {
            super(Messages.TestRunnerViewPart_hierarchical_layout, 2);
            this.setImageDescriptor(Images.getImageDescriptor("elcl16/hierarchicalLayout.png"));
        }

        public void run() {
            TestRunnerViewPart.this.setFilterAndLayout(TestRunnerViewPart.this.fFailuresOnlyFilterAction.isChecked(), TestRunnerViewPart.this.fIgnoredOnlyFilterAction.isChecked(), this.isChecked() ? TestResultsLayout.HIERARCHICAL : TestResultsLayout.FLAT);
        }
    }

    private class ShowTimeAction
    extends Action {
        public ShowTimeAction() {
            super(Messages.TestRunnerViewPart_show_execution_time, 2);
        }

        public void run() {
            TestRunnerViewPart.this.setShowExecutionTime(this.isChecked());
        }
    }

    private class SortAction
    extends Action {
        private final boolean enableAlphabeticalSort;

        public SortAction(boolean enableAlphabeticalSort) {
            super(enableAlphabeticalSort ? Messages.TestRunnerViewPart_sortAlphabetical : Messages.TestRunnerViewPart_sortRunner, 8);
            this.enableAlphabeticalSort = enableAlphabeticalSort;
        }

        public void run() {
            TestRunnerViewPart.this.fTestViewer.setAlphabeticalSort(this.enableAlphabeticalSort);
        }

        public boolean isChecked() {
            return TestRunnerViewPart.this.fTestViewer.isAlphabeticalSort() == this.enableAlphabeticalSort;
        }
    }

    private class StopAction
    extends Action {
        public StopAction() {
            this.setText(Messages.TestRunnerViewPart_stopaction_text);
            this.setToolTipText(Messages.TestRunnerViewPart_stopaction_tooltip);
            Images.setLocalImageDescriptors((IAction)this, "stop.png");
        }

        public void run() {
            TestRunnerViewPart.this.stopTest();
            this.setEnabled(false);
        }
    }

    public static enum TestResultsLayout {
        FLAT,
        HIERARCHICAL;

    }

    private class TestRunSessionListener
    implements ITestRunSessionListener {
        private TestRunSessionListener() {
        }

        @Override
        public void sessionAdded(ITestRunSession testRunSession) {
            TestRunnerViewPart.this.getDisplay().asyncExec(() -> {
                if (UnitTestUIPreferencesConstants.getShowInAllViews() || TestRunnerViewPart.this.getSite().getWorkbenchWindow() == PlatformUI.getWorkbench().getActiveWorkbenchWindow()) {
                    if (TestRunnerViewPart.this.fInfoMessage == null) {
                        String testRunLabel = BasicElementLabels.getJavaElementName(((TestRunSession)testRunSession).getTestRunName());
                        String msg = testRunSession.getLaunch() != null ? MessageFormat.format(Messages.TestRunnerViewPart_Launching, testRunLabel) : testRunLabel;
                        TestRunnerViewPart.this.registerInfoMessage(msg);
                    }
                    TestRunnerViewPart.this.setActiveTestRunSession((TestRunSession)testRunSession);
                }
            });
        }

        @Override
        public void sessionRemoved(ITestRunSession testRunSession) {
            TestRunnerViewPart.this.getDisplay().asyncExec(() -> {
                if (testRunSession.equals(TestRunnerViewPart.this.fTestRunSession)) {
                    List<TestRunSession> testRunSessions = UnitTestModel.getInstance().getTestRunSessions();
                    if (!testRunSessions.isEmpty()) {
                        TestRunnerViewPart.this.setActiveTestRunSession(testRunSessions.get(0));
                    } else {
                        TestRunnerViewPart.this.setActiveTestRunSession(null);
                    }
                }
            });
        }
    }

    private class TestSessionListener
    implements ITestSessionListener {
        private TestSessionListener() {
        }

        @Override
        public void sessionStarted() {
            TestRunnerViewPart.this.fTestViewer.registerViewersRefresh();
            TestRunnerViewPart.this.fShowOnErrorOnly = TestRunnerViewPart.getShowOnErrorOnly();
            TestRunnerViewPart.this.startUpdateJobs();
            TestRunnerViewPart.this.fStopAction.setEnabled(true);
            TestRunnerViewPart.this.fRerunLastTestAction.setEnabled(true);
            TestRunnerViewPart.this.fEditLaunchConfigAction.setEnabled(TestRunnerViewPart.this.fTestRunSession.getLaunch() != null);
        }

        @Override
        public void sessionCompleted(Duration duration) {
            TestRunnerViewPart.this.deregisterTestSessionListener();
            TestRunnerViewPart.this.fTestViewer.registerAutoScrollTarget(null);
            String msg = MessageFormat.format(Messages.TestRunnerViewPart_message_finish, duration != null ? (double)duration.toNanos() / 1.0E9 : 0.0);
            TestRunnerViewPart.this.getDisplay().asyncExec(() -> TestRunnerViewPart.this.registerInfoMessage(msg));
            TestRunnerViewPart.this.postSyncRunnable(() -> {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.fStopAction.setEnabled(TestRunnerViewPart.this.lastLaunchStillRunning());
                TestRunnerViewPart.this.updateRerunFailedFirstAction();
                TestRunnerViewPart.this.processChangesInUI();
                if (TestRunnerViewPart.this.hasErrorsOrFailures()) {
                    TestRunnerViewPart.this.selectFirstFailure();
                }
                TestRunnerViewPart.this.warnOfContentChange();
            });
            TestRunnerViewPart.this.stopUpdateJobs();
            TestRunnerViewPart.this.showMessageIfNoTests();
        }

        @Override
        public void sessionAborted(Duration duration) {
            TestRunnerViewPart.this.deregisterTestSessionListener();
            TestRunnerViewPart.this.fTestViewer.registerAutoScrollTarget(null);
            TestRunnerViewPart.this.getDisplay().asyncExec(() -> TestRunnerViewPart.this.registerInfoMessage(Messages.TestRunnerViewPart_message_stopped));
            TestRunnerViewPart.this.handleStopped();
        }

        @Override
        public void runningBegins() {
            if (!TestRunnerViewPart.this.fShowOnErrorOnly) {
                TestRunnerViewPart.this.postShowTestResultsView();
            }
        }

        @Override
        public void testStarted(ITestCaseElement testCaseElement) {
            TestRunnerViewPart.this.fTestViewer.registerAutoScrollTarget(testCaseElement);
            TestRunnerViewPart.this.fTestViewer.registerViewerUpdate(testCaseElement);
            TestRunnerViewPart.this.registerInfoMessage(testCaseElement.getDisplayName());
        }

        @Override
        public void testFailed(ITestElement testElement, ITestElement.Result status, ITestElement.FailureTrace trace) {
            if (TestRunnerViewPart.this.isAutoScroll()) {
                TestRunnerViewPart.this.fTestViewer.registerFailedForAutoScroll(testElement);
            }
            TestRunnerViewPart.this.fTestViewer.registerViewerUpdate(testElement);
            if (TestRunnerViewPart.this.fShowOnErrorOnly && TestRunnerViewPart.this.getErrorsPlusFailures() == 1) {
                TestRunnerViewPart.this.postShowTestResultsView();
            }
        }

        @Override
        public void testEnded(ITestCaseElement testCaseElement) {
            TestRunnerViewPart.this.fTestViewer.registerViewerUpdate(testCaseElement);
        }

        @Override
        public void testAdded(ITestElement testElement) {
            TestRunnerViewPart.this.fTestViewer.registerTestAdded(testElement);
        }
    }

    private class ToggleOrientationAction
    extends Action {
        private final int fActionOrientation;

        public ToggleOrientationAction(int orientation) {
            super("", 8);
            switch (orientation) {
                case 1: {
                    this.setText(Messages.TestRunnerViewPart_toggle_horizontal_label);
                    this.setImageDescriptor(Images.getImageDescriptor("elcl16/th_horizontal.png"));
                    break;
                }
                case 0: {
                    this.setText(Messages.TestRunnerViewPart_toggle_vertical_label);
                    this.setImageDescriptor(Images.getImageDescriptor("elcl16/th_vertical.png"));
                    break;
                }
                case 2: {
                    this.setText(Messages.TestRunnerViewPart_toggle_automatic_label);
                    this.setImageDescriptor(Images.getImageDescriptor("elcl16/th_automatic.png"));
                    break;
                }
            }
            this.fActionOrientation = orientation;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.unittest.ui.results_view_toggle_call_mode_action_context");
        }

        public int getOrientation() {
            return this.fActionOrientation;
        }

        public void run() {
            if (this.isChecked()) {
                TestRunnerViewPart.this.fOrientation = this.fActionOrientation;
                TestRunnerViewPart.this.computeOrientation();
            }
        }
    }

    private class UnitTestIsRunningJob
    extends Job {
        public UnitTestIsRunningJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            TestRunnerViewPart.this.fUnitTestIsRunningLock.acquire();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_UNITTEST_RUN;
        }
    }

    private static class UnitTesttPasteAction
    extends Action {
        private final Shell fShell;
        private Clipboard fClipboard;

        public UnitTesttPasteAction(Shell shell, Clipboard clipboard) {
            super(Messages.TestRunnerViewPart_PasteAction_label);
            Assert.isNotNull((Object)clipboard);
            this.fShell = shell;
            this.fClipboard = clipboard;
        }

        public void run() {
            String urlData = (String)this.fClipboard.getContents((Transfer)URLTransfer.getInstance());
            if (urlData == null) {
                urlData = (String)this.fClipboard.getContents((Transfer)TextTransfer.getInstance());
            }
            if (urlData != null && urlData.length() > 0 && this.isValidUrl(urlData)) {
                TestRunnerViewPart.importTestRunSession(urlData);
                return;
            }
            MessageDialog.openInformation((Shell)this.fShell, (String)Messages.TestRunnerViewPart_PasteAction_cannotpaste_title, (String)Messages.TestRunnerViewPart_PasteAction_cannotpaste_message);
        }

        private boolean isValidUrl(String urlData) {
            try {
                new URL(urlData);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
            return true;
        }
    }

    private class UpdateUIJob
    extends UIJob {
        private boolean fRunning;

        public UpdateUIJob(String name) {
            super(name);
            this.fRunning = true;
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!TestRunnerViewPart.this.isDisposed()) {
                TestRunnerViewPart.this.processChangesInUI();
            }
            this.schedule(200L);
            return Status.OK_STATUS;
        }

        public void stop() {
            this.fRunning = false;
        }

        public boolean shouldSchedule() {
            return this.fRunning;
        }
    }
}

