/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CheckOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileModifiableMaskedTuple;

public class AggregatorCheck
implements ISearchOperation,
IPatternMatcherOperation {
    private final int position;
    private final AggregatorConstraint aggregator;
    private final CallInformation information;

    public AggregatorCheck(CallInformation information, AggregatorConstraint aggregator, int position) {
        this.information = information;
        this.position = position;
        this.aggregator = aggregator;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Collections.singletonList(this.position);
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "check     " + variableMapping.apply(this.position) + " = " + this.aggregator.getAggregator().getOperator().getName() + " find " + this.information.toString(variableMapping);
    }

    @Override
    public CallInformation getCallInformation() {
        return this.information;
    }

    private class Executor
    extends CheckOperationExecutor {
        private final VolatileModifiableMaskedTuple maskedTuple;
        private IQueryResultProvider matcher;

        public Executor() {
            this.maskedTuple = new VolatileModifiableMaskedTuple(AggregatorCheck.this.information.getThinFrameMask());
        }

        @Override
        public void onInitialize(MatchingFrame frame, ISearchContext context) {
            super.onInitialize(frame, context);
            this.maskedTuple.updateTuple((IModifiableTuple)frame);
            this.matcher = context.getMatcher(AggregatorCheck.this.information.getCallWithAdornment());
        }

        @Override
        protected boolean check(MatchingFrame frame, ISearchContext context) {
            IMultisetAggregationOperator operator = AggregatorCheck.this.aggregator.getAggregator().getOperator();
            Object result = this.aggregate(operator, AggregatorCheck.this.aggregator.getAggregatedColumn(), frame);
            return result == null ? false : Objects.equals(frame.getValue(AggregatorCheck.this.position), result);
        }

        private <Domain, Accumulator, AggregateResult> AggregateResult aggregate(IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, int aggregatedColumn, MatchingFrame initialFrame) {
            this.maskedTuple.updateTuple((IModifiableTuple)initialFrame);
            Stream<Object> valueStream = this.matcher.getAllMatches(AggregatorCheck.this.information.getParameterMask(), (ITuple)this.maskedTuple).map(match -> match.get(aggregatedColumn));
            return (AggregateResult)operator.aggregateStream(valueStream);
        }

        @Override
        public ISearchOperation getOperation() {
            return AggregatorCheck.this;
        }
    }
}

