/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.parser;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.wb.core.model.IRootProcessor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingFactory;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.parser.ParseState;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public class DatabindingRootProcessor
implements IRootProcessor {
    public static final IRootProcessor INSTANCE = new DatabindingRootProcessor();
    public static final Map<ICompilationUnit, ParseState> STATES = Maps.newHashMap();
    private List<IDatabindingFactory> m_factories;

    public void process(final JavaInfo root, List<JavaInfo> components) throws Exception {
        if (EditorState.get((AstEditor)root.getEditor()).isLiveComponent()) {
            return;
        }
        if (this.m_factories == null) {
            this.m_factories = ExternalFactoriesHelper.getElementsInstances(IDatabindingFactory.class, (String)"org.eclipse.wb.core.databinding.databindingFactories", (String)"factory");
        }
        for (IDatabindingFactory factory : this.m_factories) {
            IDatabindingsProvider databindingsProvider = factory.createProvider(root);
            if (databindingsProvider == null) continue;
            STATES.put(root.getEditor().getModelUnit(), new ParseState(databindingsProvider, factory.getPlugin()));
            root.addBroadcastListener((Object)new ObjectEventListener(){

                public void dispose() throws Exception {
                    STATES.remove(root.getEditor().getModelUnit());
                }
            });
            return;
        }
    }
}

