/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.property;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.BindWizard;
import org.eclipse.wb.internal.core.databinding.ui.property.AbstractBindingProperty;
import org.eclipse.wb.internal.core.databinding.ui.property.AbstractProperty;
import org.eclipse.wb.internal.core.databinding.ui.property.Context;
import org.eclipse.wb.internal.core.databinding.ui.property.ObservePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;

public abstract class AbstractObserveProperty
extends AbstractProperty {
    protected final IObserveInfo m_observeProperty;
    protected final List<AbstractBindingProperty> m_bindingProperties = Lists.newArrayList();
    private final String m_title;

    public AbstractObserveProperty(Context context, IObserveInfo observeProperty) throws Exception {
        super((PropertyEditor)ObservePropertyEditor.EDITOR, context);
        this.m_observeProperty = observeProperty;
        this.m_title = this.m_observeProperty.getPresentation().getText();
    }

    public final IObserveInfo getObserveProperty() {
        return this.m_observeProperty;
    }

    public final List<AbstractBindingProperty> getBindingProperties() {
        return this.m_bindingProperties;
    }

    public abstract void getBindings(List<IBindingInfo> var1, List<Boolean> var2) throws Exception;

    public abstract AbstractBindingProperty createBindingProperty() throws Exception;

    public void createBinding() throws Exception {
        AbstractObserveProperty.createBinding(this.m_context, this.m_observeProperty);
    }

    public static final void createBinding(Context context, IObserveInfo observeProperty) throws Exception {
        BindWizard wizard = new BindWizard(context, observeProperty);
        WizardDialog dialog = new WizardDialog(DesignerPlugin.getShell(), (IWizard)wizard);
        dialog.open();
    }

    public final String getTitle() {
        return this.m_title;
    }

    public final boolean isModified() throws Exception {
        ObservePropertyEditor.EDITOR.updateProperties(this);
        return !this.m_bindingProperties.isEmpty();
    }
}

